# Security Assessment Report Template

## Header

```markdown
# Security Assessment Report

**Target:** {{target}}
**Date:** {{date}}
**Level:** {{level}}
**Risk Score:** {{risk_score}}/100
**Risk Level:** {{risk_level}}
**Agents Used:** {{agent_count}}

---
```

## Executive Summary

```markdown
## Executive Summary

{{executive_summary}}

### Key Statistics
- **Total Findings:** {{total_findings}}
- **Critical:** {{critical_count}}
- **High:** {{high_count}}
- **OWASP 2025 Compliance:** {{owasp_score}}%
```

## Findings Section

```markdown
## Critical Findings (CVSS >= 9.0)

### {{finding_title}} [CVSS: {{cvss}}]

**Category:** {{owasp_category}}
**CWE:** {{cwe_id}}
**Severity:** Critical

**Description:**
{{finding_description}}

**Evidence:**
```
{{evidence}}
```

**Business Impact:**
{{business_impact}}

**Remediation:**
{{remediation_steps}}

**References:**
- {{reference_links}}

---
```

## OWASP 2025 Compliance

```markdown
## OWASP Top 10 2025 Compliance

| Category | Description | Status | Findings |
|----------|-------------|--------|----------|
| A01 | Broken Access Control | {{status}} | {{count}} |
| A02 | Security Misconfiguration | {{status}} | {{count}} |
| A03 | Supply Chain Failures (NEW) | {{status}} | {{count}} |
| A04 | Cryptographic Failures | {{status}} | {{count}} |
| A05 | Injection | {{status}} | {{count}} |
| A06 | Insecure Design | {{status}} | {{count}} |
| A07 | Authentication Failures | {{status}} | {{count}} |
| A08 | Integrity Failures | {{status}} | {{count}} |
| A09 | Logging & Alerting Failures | {{status}} | {{count}} |
| A10 | Exceptional Conditions (NEW) | {{status}} | {{count}} |
```

## LLM Security Section

```markdown
## LLM Security Assessment

| Test Category | Status | Findings |
|---------------|--------|----------|
| Prompt Injection | {{status}} | {{count}} |
| Jailbreak | {{status}} | {{count}} |
| Data Leakage | {{status}} | {{count}} |
| Output Manipulation | {{status}} | {{count}} |

### LLM Findings Detail

{{llm_findings}}
```

## Supply Chain Section

```markdown
## Supply Chain Audit

**SBOM Generated:** {{sbom_status}}
**Total Dependencies:** {{dep_count}}
**Vulnerable Dependencies:** {{vuln_count}}

### Vulnerable Dependencies

| Package | Version | CVE | Severity | Fixed Version |
|---------|---------|-----|----------|---------------|
{{supply_chain_table}}
```

## Remediation Timeline

```markdown
## Remediation Timeline

| Priority | Finding | Action | SLA | Owner |
|----------|---------|--------|-----|-------|
| P0 | {{finding}} | {{action}} | 24h | {{owner}} |
| P1 | {{finding}} | {{action}} | 7d | {{owner}} |
| P2 | {{finding}} | {{action}} | 30d | {{owner}} |
```

## Methodology

```markdown
## Methodology

### Agents Used
- **Planning Agent:** Scope decomposition, threat modeling
- **Intel Agents ({{intel_count}}):** CVE, tech threats, compliance
- **Scan Agents ({{scan_count}}):** Web/API, LLM, supply chain, injection, config
- **Exploit Analyst:** Deep analysis with ultrathink
- **Synthesis Agent:** Report generation

### Tools Used
{{tools_list}}

### Data Quality
- **Coverage:** {{coverage}}%
- **False Positive Rate:** {{fp_rate}}%
- **Ultrathink Analysis:** {{ultrathink_status}}
```

## Footer

```markdown
---

*Generated by Kali Pentester v2.0 - Ultrathink Expert Edition*
*Multi-Agent Penetration Testing System*
*{{timestamp}}*
```
