# OWASP Top 10 2025 Testing Checklist

Updated for OWASP Top 10:2025 with two new categories.

## A01:2025 - Broken Access Control

**Severity:** Critical | **CWEs:** 40

### Tests

| Test | Tool | Command |
|------|------|---------|
| IDOR | ffuf | `ffuf -u URL/api/users/FUZZ -w ids.txt` |
| Path Traversal | ffuf | `ffuf -u URL/file?path=FUZZ -w lfi.txt` |
| Force Browsing | gobuster | `gobuster dir -u URL -w common.txt` |
| CORS | curl | `curl -H "Origin: evil.com" URL` |
| JWT Bypass | jwt_tool | `jwt_tool TOKEN -T` |

### SSRF (Merged from A10:2021)

```bash
curl "URL?fetch=http://127.0.0.1:22"
curl "URL?fetch=http://169.254.169.254/latest/meta-data/"
```

## A02:2025 - Security Misconfiguration

**Severity:** High | **Moved from:** #5 in 2021

### Tests

| Test | Tool | Command |
|------|------|---------|
| Headers | curl | `curl -I URL` |
| Nikto | nikto | `nikto -h URL` |
| SSL/TLS | testssl | `testssl.sh URL` |
| Directory List | Browser | Check for open indexes |
| Default Creds | hydra | Credential testing |

### Security Headers Check

```bash
curl -I URL | grep -E "(X-Frame|X-Content|Content-Security|Strict-Transport|X-XSS)"
```

## A03:2025 - Software Supply Chain Failures (NEW)

**Severity:** High | **NEW in 2025**

### Tests

| Test | Tool | Command |
|------|------|---------|
| Dependency CVEs | trivy | `trivy fs PATH --format json` |
| JS Libraries | retire.js | `retire --js --jspath PATH` |
| Python Deps | pip-audit | `pip-audit` |
| Container | trivy | `trivy image IMAGE` |
| SBOM | syft | `syft PATH -o cyclonedx-json` |

### Supply Chain Checks

```bash
# Generate SBOM
syft . -o cyclonedx-json > sbom.json

# Scan dependencies
trivy fs . --severity HIGH,CRITICAL

# Check container
trivy image myapp:latest
```

## A04:2025 - Cryptographic Failures

**Severity:** High | **Moved from:** #2 in 2021

### Tests

| Test | Tool | Command |
|------|------|---------|
| SSL Scan | sslscan | `sslscan HOST` |
| TLS Test | testssl | `testssl.sh URL` |
| Cipher Enum | nmap | `nmap --script ssl-enum-ciphers -p 443 HOST` |

## A05:2025 - Injection

**Severity:** Critical | **Moved from:** #3 in 2021

### Tests

| Test | Tool | Command |
|------|------|---------|
| SQLi | sqlmap | `sqlmap -u "URL?id=1" --batch --dbs` |
| XSS | xsstrike | `xsstrike.py -u "URL?q=test"` |
| Command | commix | `commix -u "URL?cmd=test"` |
| Template | tplmap | `tplmap -u "URL?name=test"` |

## A06:2025 - Insecure Design

**Severity:** Medium | **Moved from:** #4 in 2021

### Tests

- Business logic flaws (manual)
- Rate limiting bypass
- Trust boundary violations
- Missing threat modeling

## A07:2025 - Authentication Failures

**Severity:** High

### Tests

| Test | Tool | Command |
|------|------|---------|
| Brute Force | hydra | `hydra -l admin -P rockyou.txt HOST http-post-form` |
| Session | Manual | Check session handling |
| 2FA Bypass | Manual | Verify MFA implementation |

## A08:2025 - Software & Data Integrity Failures

**Severity:** Medium

### Tests

- Insecure deserialization
- Missing SRI hashes
- Unsigned updates
- CI/CD pipeline security

## A09:2025 - Security Logging & Alerting Failures

**Severity:** Medium | **Name updated from "Monitoring"**

### Tests

- Log injection attempts
- Audit trail verification
- Alert configuration review

## A10:2025 - Mishandling of Exceptional Conditions (NEW)

**Severity:** Medium | **NEW in 2025** | **CWEs:** 24

### Tests

| Test | Description |
|------|-------------|
| Error Handling | Trigger errors, check for stack traces |
| Fail Open | Test if failures allow access |
| Logic Errors | Unexpected input handling |
| Resource Exhaustion | Memory/CPU limits |

### Error Handling Tests

```bash
# Trigger exceptions
curl "URL/api?id=null"
curl "URL/api?id=<script>"
curl "URL/api?id=-1"
curl "URL/api?id=999999999999"
```

## Quick Reference

| Category | Severity | Key Tools |
|----------|----------|-----------|
| A01 | Critical | ffuf, gobuster, jwt_tool |
| A02 | High | nikto, testssl, curl |
| A03 | High | trivy, syft, pip-audit |
| A04 | High | sslscan, testssl |
| A05 | Critical | sqlmap, xsstrike, commix |
| A06 | Medium | Manual analysis |
| A07 | High | hydra, burp |
| A08 | Medium | SRI check, SBOM |
| A09 | Medium | Log analysis |
| A10 | Medium | Error injection |
