# Kali Linux Pentesting Tool Guide

Quick reference for essential web application pentesting tools.

## Reconnaissance Tools

### Nmap - Network Scanner

```bash
# Basic service scan
nmap -sV <target>

# Full scan with scripts
nmap -sV -sC -p- <target>

# Web-focused scan
nmap -sV -p 80,443,8080,8443 --script=http-* <target>

# Vulnerability scan
nmap --script vuln <target>
```

### Whatweb - Web Technology Identifier

```bash
# Basic fingerprinting
whatweb <url>

# Aggressive mode
whatweb -a 3 <url>

# Output to file
whatweb <url> --log-json=output.json
```

### Gobuster - Directory Discovery

```bash
# Directory bruteforce
gobuster dir -u <url> -w /usr/share/wordlists/dirbuster/directory-list-2.3-medium.txt

# With file extensions
gobuster dir -u <url> -w wordlist.txt -x php,html,js

# Faster with more threads
gobuster dir -u <url> -w wordlist.txt -t 50
```

## Vulnerability Scanners

### OWASP ZAP - Web App Scanner

```bash
# Start ZAP daemon
zap.sh -daemon -port 8080 -config api.key=apikey

# Quick scan via CLI
zap-cli -p 8080 quick-scan <url>

# Active scan
zap-cli -p 8080 active-scan <url>

# Generate report
zap-cli -p 8080 report -o report.html -f html
```

### Nikto - Web Server Scanner

```bash
# Basic scan
nikto -h <url>

# With SSL
nikto -h <url> -ssl

# Save output
nikto -h <url> -o output.txt -Format txt

# Tune specific tests
nikto -h <url> -Tuning 9  # SQL injection focus
```

## Injection Tools

### SQLmap - SQL Injection

```bash
# Basic test
sqlmap -u "<url>?id=1"

# Aggressive testing
sqlmap -u "<url>?id=1" --risk=3 --level=5

# Extract databases
sqlmap -u "<url>?id=1" --dbs

# Extract tables
sqlmap -u "<url>?id=1" -D dbname --tables

# Dump data
sqlmap -u "<url>?id=1" -D dbname -T tablename --dump

# POST request
sqlmap -u "<url>" --data="user=test&pass=test" -p user

# With authentication cookie
sqlmap -u "<url>?id=1" --cookie="PHPSESSID=xxx"
```

### XSStrike - XSS Scanner

```bash
# Basic scan
python3 xsstrike.py -u "<url>?param=test"

# With POST data
python3 xsstrike.py -u "<url>" --data "param=test"

# Crawl and test
python3 xsstrike.py -u "<url>" --crawl

# Blind XSS
python3 xsstrike.py -u "<url>" --blind
```

### Commix - Command Injection

```bash
# Basic test
commix -u "<url>?cmd=test"

# With POST
commix -u "<url>" --data="cmd=test"

# OS shell
commix -u "<url>?cmd=test" --os-cmd="id"
```

## Password Attacks

### Hydra - Brute Force

```bash
# HTTP POST form
hydra -l admin -P /usr/share/wordlists/rockyou.txt \
  <host> http-post-form "/login:user=^USER^&pass=^PASS^:Invalid"

# HTTP Basic Auth
hydra -l admin -P passwords.txt <host> http-get /admin/

# SSH
hydra -l root -P passwords.txt <host> ssh

# With user list
hydra -L users.txt -P passwords.txt <host> http-post-form "..."
```

### John the Ripper - Password Cracking

```bash
# Crack password hashes
john --wordlist=/usr/share/wordlists/rockyou.txt hashes.txt

# Show cracked passwords
john --show hashes.txt

# Specific format
john --format=raw-md5 hashes.txt
```

## Exploitation Frameworks

### Metasploit Framework

```bash
# Start console
msfconsole

# Search exploits
search type:exploit platform:linux apache

# Use exploit
use exploit/multi/http/apache_mod_cgi_bash_env_exec

# Set options
set RHOSTS target.com
set RPORT 80

# Run exploit
exploit
```

### Burp Suite (GUI)

Key features:
- **Proxy**: Intercept/modify requests
- **Scanner**: Automated vulnerability scanning
- **Intruder**: Customized attacks
- **Repeater**: Manual request testing
- **Decoder**: Encode/decode data

## SSL/TLS Tools

### SSLscan

```bash
# Basic scan
sslscan <host>

# Check specific port
sslscan <host>:8443

# No color output
sslscan --no-colour <host>
```

### Testssl.sh

```bash
# Full test
testssl.sh <url>

# Quick test
testssl.sh -e --fast <url>

# Check specific vulnerabilities
testssl.sh --heartbleed --ccs --robot <url>
```

## Fuzzing Tools

### ffuf - Fast Fuzzer

```bash
# Directory fuzzing
ffuf -u <url>/FUZZ -w wordlist.txt

# Parameter fuzzing
ffuf -u "<url>?FUZZ=test" -w params.txt

# POST data fuzzing
ffuf -u <url> -X POST -d "user=FUZZ" -w users.txt

# Filter by status code
ffuf -u <url>/FUZZ -w wordlist.txt -mc 200,301

# Filter by response size
ffuf -u <url>/FUZZ -w wordlist.txt -fs 1234
```

### Wfuzz

```bash
# Basic fuzzing
wfuzz -c -z file,wordlist.txt <url>/FUZZ

# Hide specific response codes
wfuzz -c -z file,wordlist.txt --hc 404 <url>/FUZZ

# Cookie fuzzing
wfuzz -c -z file,wordlist.txt -b "session=FUZZ" <url>
```

## Wordlists

Essential wordlists in Kali:

| Wordlist | Path | Use Case |
|----------|------|----------|
| rockyou.txt | `/usr/share/wordlists/rockyou.txt` | Passwords |
| directory-list-2.3-medium.txt | `/usr/share/wordlists/dirbuster/` | Directory brute |
| common.txt | `/usr/share/wordlists/dirb/common.txt` | Quick directory scan |
| SecLists | `/usr/share/seclists/` | Comprehensive lists |

## Quick Cheat Sheet

```bash
# Full recon
nmap -sV -sC -p- <target> && whatweb <url> && gobuster dir -u <url> -w /usr/share/wordlists/dirb/common.txt

# Vulnerability scan
nikto -h <url> && sqlmap -u "<url>?id=1" --batch

# SSL check
sslscan <host> && testssl.sh <url>

# Password attack
hydra -l admin -P /usr/share/wordlists/rockyou.txt <host> http-post-form "/login:user=^USER^&pass=^PASS^:Failed"
```
