# Output Templates

Standard templates for optimized prompt delivery.

## Simple Optimization Output

```markdown
## Your Optimized Prompt

[Optimized prompt text]

## Key Improvements

- **[Improvement area]**: [What changed and why it's better]
- **[Improvement area]**: [What changed and why it's better]
```

## Standard Optimization Output

```markdown
## Your Optimized Prompt

[Optimized prompt text]

## Key Improvements

| Area      | Change                  | Benefit                                |
| --------- | ----------------------- | -------------------------------------- |
| Role      | Added expert persona    | Primes AI for domain-specific response |
| Structure | Added clear sections    | Improves response organization         |
| Context   | Layered background info | Provides necessary context             |
| Output    | Specified format        | Ensures consistent delivery            |

## Techniques Applied

- **[Technique name]**: [Brief explanation of application]
- **[Technique name]**: [Brief explanation of application]

## Pro Tip

[Practical advice for using this prompt effectively]
```

## Detailed Optimization Output

```markdown
## Your Optimized Prompt

[Optimized prompt text]

---

## Analysis Summary

### Original Assessment

- **Clarity**: [score/10] - [brief explanation]
- **Specificity**: [score/10] - [brief explanation]
- **Structure**: [score/10] - [brief explanation]

### Optimization Approach

[1-2 sentences on strategy taken]

## Key Improvements

### 1. [Improvement Category]

- **Before**: [original approach]
- **After**: [optimized approach]
- **Impact**: [expected improvement]

### 2. [Improvement Category]

- **Before**: [original approach]
- **After**: [optimized approach]
- **Impact**: [expected improvement]

## Techniques Applied

| Technique | Application   | Why Used    |
| --------- | ------------- | ----------- |
| [Name]    | [How applied] | [Rationale] |
| [Name]    | [How applied] | [Rationale] |

## Usage Guidance

### Best Results

- [Tip for optimal use]
- [Tip for optimal use]

### Variations

- For [scenario]: [modification suggestion]
- For [scenario]: [modification suggestion]

## Pro Tip

[Expert advice for this specific prompt type]
```

## Comparison Template

```markdown
## Prompt Comparison

### Original
```

[Original prompt]

```

### Optimized
```

[Optimized prompt]

```

### Side-by-Side Analysis

| Aspect | Original | Optimized |
|--------|----------|-----------|
| Role definition | [status] | [status] |
| Context | [status] | [status] |
| Task clarity | [status] | [status] |
| Output format | [status] | [status] |
| Constraints | [status] | [status] |
```

## DETAIL Mode Question Template

```markdown
## Clarifying Questions

To optimize this prompt effectively, I need a few details:

1. **[Question about intent/goal]**
   - Option A: [choice]
   - Option B: [choice]
   - Default: [intelligent default if no response]

2. **[Question about context/audience]**
   - [Open-ended or multiple choice]
   - Default: [intelligent default]

3. **[Question about output preferences]**
   - [Specific options]
   - Default: [intelligent default]

_Note: I'll proceed with defaults in 30 seconds if no response._
```

## Validation Report Template

```markdown
## Validation Report

### Intent Alignment

- Original intent: [extracted intent]
- Optimized addresses: [yes/partial/no]
- Notes: [any gaps or enhancements]

### Constraint Satisfaction

| Constraint     | Status | Notes         |
| -------------- | ------ | ------------- |
| [Constraint 1] | ✓/✗    | [explanation] |
| [Constraint 2] | ✓/✗    | [explanation] |

### Structure Assessment

- Appropriate for target AI: [yes/no]
- Reasoning: [brief explanation]

### Final Status: [APPROVED / NEEDS REVISION]
```
