# Technical Debt Analysis Report Template

Use this template for generating debt analysis reports.

---

## Technical Debt Analysis: {TARGET}

**Analysis Date:** {DATE}
**Analysis Level:** {LEVEL}/5
**Analyzed By:** resolve-debt-v2 multi-agent system

---

### Executive Summary

| Metric | Value |
|--------|-------|
| Total debt items identified | {TOTAL_ITEMS} |
| Critical items (immediate action) | {CRITICAL_COUNT} |
| High priority items | {HIGH_COUNT} |
| Medium priority items | {MEDIUM_COUNT} |
| Estimated total resolution effort | {ESTIMATED_HOURS} hours |

**Key Risk Areas:**
- {RISK_AREA_1}
- {RISK_AREA_2}
- {RISK_AREA_3}

---

### Debt Inventory

| ID | Type | Location | Severity | Description |
|----|------|----------|----------|-------------|
| {ID} | {TYPE} | {LOCATION} | {SEVERITY}/5 | {DESCRIPTION} |

**Type Legend:**
- CS: Code Smell
- DEP: Dependency Issue
- ARCH: Architecture Violation
- TEST: Test Coverage Gap

---

### Prioritized Resolution Plan

#### Critical - Address This Sprint

**{ID}: {TITLE}**
- **Problem:** {PROBLEM_DESCRIPTION}
- **Location:** `{FILE_PATH}:{LINE}`
- **Impact:** {IMPACT_DESCRIPTION}
- **Solution:** {SOLUTION_STEPS}
- **Prerequisites:** {PREREQUISITES}
- **Verification:** {VERIFICATION_STEPS}
- **Estimated Effort:** {EFFORT} hours

---

#### High Priority - Address This Quarter

**{ID}: {TITLE}**
- **Problem:** {PROBLEM_DESCRIPTION}
- **Location:** `{FILE_PATH}`
- **Impact:** {IMPACT_DESCRIPTION}
- **Solution:** {SOLUTION_SUMMARY}
- **Estimated Effort:** {EFFORT} hours

---

#### Medium Priority - Backlog

| ID | Issue | Location | Effort |
|----|-------|----------|--------|
| {ID} | {ISSUE_SUMMARY} | {LOCATION} | {EFFORT}h |

---

### Quick Wins (< 30 min each)

- [ ] **{ID}**: {QUICK_FIX_DESCRIPTION} (`{LOCATION}`)
- [ ] **{ID}**: {QUICK_FIX_DESCRIPTION} (`{LOCATION}`)
- [ ] **{ID}**: {QUICK_FIX_DESCRIPTION} (`{LOCATION}`)

---

### Implementation Order

Dependency-aware execution sequence:

```
Step 1: {FOUNDATION_FIX}
        -> Unblocks: {DEPENDENT_ITEMS}

Step 2: {NEXT_FIX}
        -> Depends on: Step 1
        -> Unblocks: {DEPENDENT_ITEMS}

Step 3: {NEXT_FIX}
        -> Depends on: Step 1, 2
        -> Unblocks: {DEPENDENT_ITEMS}
```

---

### Metrics to Track

| Metric | Before | Target | How to Measure |
|--------|--------|--------|----------------|
| Cyclomatic Complexity | {CURRENT} | {TARGET} | ESLint complexity rule |
| Test Coverage | {CURRENT}% | {TARGET}% | Jest/Istanbul coverage |
| Dependency Vulnerabilities | {CURRENT} | 0 | npm audit |
| Code Duplication | {CURRENT}% | <{TARGET}% | SonarQube/jscpd |
| Build Time | {CURRENT}s | <{TARGET}s | CI metrics |

---

### Appendix: Analysis Details

**Files Analyzed:** {FILE_COUNT}
**Workers Executed:** {WORKER_COUNT}
**Analysis Duration:** {DURATION}ms

**Worker Results Summary:**
- Code Smell Agent: {CS_COUNT} issues found
- Dependency Agent: {DEP_COUNT} issues found
- Architecture Agent: {ARCH_COUNT} issues found
- Test Coverage Agent: {TEST_COUNT} issues found

---

*Generated by resolve-debt-v2 multi-agent system*
