# Debug Report: {ERROR_TITLE}

**Generated:** {TIMESTAMP}
**Triage Category:** {CATEGORY}
**Confidence:** {CONFIDENCE}
**Agents Used:** {AGENTS_LIST}

---

## Executive Summary

{2-3 sentence summary identifying the root cause and recommended fix}

---

## Triage Classification

| Attribute | Value |
|-----------|-------|
| Category | {CATEGORY} |
| Confidence | {CONFIDENCE} |
| Key Indicators | {INDICATORS} |
| Selected Agents | {AGENTS} |

**Classification Reasoning:**
{REASONING}

---

## Root Cause Analysis

### Error Symptom

```
{ERROR_MESSAGE}
```

**Location:** `{FILE}:{LINE}`

### Call Chain Trace

```
{FUNCTION_5} ← {VALUE}
    │
{FUNCTION_4} ← {VALUE}
    │
{FUNCTION_3} ← {VALUE}
    │
{FUNCTION_2} ← {VALUE}
    │
{FUNCTION_1} ← ORIGIN: {BAD_VALUE}
```

### Origin Point

| Attribute | Value |
|-----------|-------|
| File | `{ORIGIN_FILE}:{ORIGIN_LINE}` |
| Function | `{ORIGIN_FUNCTION}` |
| Issue | {WHAT_IS_WRONG} |
| Why | {WHY_ITS_WRONG} |

---

## Evidence from Agents

### Systematic Debugging Findings

**Phase 1 - Investigation:**
{PHASE1_FINDINGS}

**Phase 2 - Pattern Analysis:**
{PHASE2_FINDINGS}

**Phase 3 - Hypothesis:**
{HYPOTHESIS}

### Root Cause Tracing Findings

{ROOTCAUSE_FINDINGS}

### Defense-in-Depth Findings

| Layer | Current State | Gap | Recommendation |
|-------|--------------|-----|----------------|
| Entry Point | {ENTRY_STATE} | {ENTRY_GAP} | {ENTRY_REC} |
| Business Logic | {LOGIC_STATE} | {LOGIC_GAP} | {LOGIC_REC} |
| Environment | {ENV_STATE} | {ENV_GAP} | {ENV_REC} |
| Debug | {DEBUG_STATE} | {DEBUG_GAP} | {DEBUG_REC} |

### Verification Findings

{VERIFICATION_FINDINGS}

---

## Recommended Fix

### Primary Fix

**File:** `{FIX_FILE}:{FIX_LINE}`

```{LANGUAGE}
{FIX_CODE}
```

**Explanation:**
{FIX_EXPLANATION}

### Regression Test

```{LANGUAGE}
{TEST_CODE}
```

---

## Prevention Layers

Add these validations to prevent recurrence:

### Layer 1: Entry Point Validation

```{LANGUAGE}
{LAYER1_CODE}
```

### Layer 2: Business Logic Validation

```{LANGUAGE}
{LAYER2_CODE}
```

### Layer 3: Environment Guards

```{LANGUAGE}
{LAYER3_CODE}
```

### Layer 4: Debug Instrumentation

```{LANGUAGE}
{LAYER4_CODE}
```

---

## Verification Steps

Run these commands to verify the fix:

### 1. Run Tests

```bash
{TEST_COMMAND}
```

**Expected:** {TEST_EXPECTED}

### 2. Regression Test (Red-Green)

```bash
# Step 1: Verify test passes with fix
{TEST_COMMAND}

# Step 2: Revert fix, verify test FAILS
git stash
{TEST_COMMAND}  # Should FAIL

# Step 3: Restore fix, verify test passes
git stash pop
{TEST_COMMAND}  # Should PASS
```

### 3. Build Verification

```bash
{BUILD_COMMAND}
```

**Expected:** Exit code 0, no errors

### 4. Related Tests

```bash
{RELATED_TESTS_COMMAND}
```

---

## Summary

| Metric | Value |
|--------|-------|
| Root Cause Identified | {YES_NO} |
| Fix Recommended | {YES_NO} |
| Prevention Layers Added | {COUNT}/4 |
| Verification Steps Defined | {YES_NO} |

**Next Steps:**
1. {STEP_1}
2. {STEP_2}
3. {STEP_3}

---

*Report generated by ultrathink-debugger multi-agent system*
