# Laboratory Report Template

## Patient Information

**Patient Name:** [Last, First]  
**Medical Record Number:** [MRN]  
**Date of Birth:** [MM/DD/YYYY]  
**Age/Sex:** [Age years, M/F]

**Ordering Physician:** [Name]  
**Location:** [Inpatient unit / Outpatient clinic]

---

## Specimen Information

**Specimen Type:** [Blood / Serum / Plasma / Urine / CSF / Other]  
**Collection Date/Time:** [MM/DD/YYYY at HH:MM]  
**Received Date/Time:** [MM/DD/YYYY at HH:MM]  
**Reported Date/Time:** [MM/DD/YYYY at HH:MM]

**Accession Number:** [Lab accession number]  
**Specimen Condition:** [Acceptable / See comments]  
**Fasting Status:** [Fasting / Non-fasting / Unknown] (if relevant)

---

## Laboratory Results

| Test Name | Result | Units | Reference Range | Flag |
|-----------|--------|-------|----------------|------|
| [Test] | [Value] | [Unit] | [Normal range] | [L/H/Critical] |

### Example: Complete Blood Count (CBC)

| Test | Result | Units | Reference Range | Flag |
|------|--------|-------|----------------|------|
| White Blood Cell Count | 12.5 | × 10³/μL | 4.5-11.0 | H |
| Hemoglobin | 10.2 | g/dL | 12.0-16.0 (F), 14.0-18.0 (M) | L |
| Hematocrit | 31.5 | % | 36.0-48.0 (F), 42.0-52.0 (M) | L |
| Platelet Count | 245 | × 10³/μL | 150-400 | - |
| MCV | 88.5 | fL | 80.0-100.0 | - |
| MCH | 29.5 | pg | 27.0-33.0 | - |
| MCHC | 33.2 | g/dL | 32.0-36.0 | - |
| RDW | 14.5 | % | 11.5-14.5 | - |

**Differential:**
| Cell Type | Result | Units | Reference Range | Flag |
|-----------|--------|-------|----------------|------|
| Neutrophils | 75 | % | 40-70 | H |
| Lymphocytes | 15 | % | 20-40 | L |
| Monocytes | 7 | % | 2-10 | - |
| Eosinophils | 2 | % | 1-4 | - |
| Basophils | 1 | % | 0-2 | - |

### Example: Basic Metabolic Panel (BMP)

| Test | Result | Units | Reference Range | Flag |
|------|--------|-------|----------------|------|
| Sodium | 138 | mEq/L | 136-145 | - |
| Potassium | 3.2 | mEq/L | 3.5-5.0 | L |
| Chloride | 102 | mEq/L | 98-107 | - |
| CO2 | 24 | mEq/L | 22-30 | - |
| Blood Urea Nitrogen | 28 | mg/dL | 7-20 | H |
| Creatinine | 1.8 | mg/dL | 0.6-1.2 (F), 0.7-1.3 (M) | H |
| Glucose | 145 | mg/dL | 70-100 (fasting) | H |
| eGFR | 42 | mL/min/1.73m² | >60 | L |

---

## Interpretation / Comments

[Clinical interpretation when applicable]

**Example for Anemia:**
```
Normocytic anemia with elevated WBC. Differential diagnosis includes anemia of chronic 
disease, recent blood loss, or hemolysis. Consider reticulocyte count, iron studies, 
and peripheral smear for further evaluation. Clinical correlation recommended.
```

**Example for Electrolyte Abnormality:**
```
Hypokalemia detected (K+ 3.2 mEq/L). Common causes include diuretic use, GI losses, or 
inadequate intake. Recommend potassium repletion and follow-up testing. Moderate 
azotemia present, consistent with acute kidney injury or chronic kidney disease. 
Clinical correlation with patient history and prior results recommended.
```

---

## Critical Values

[If any results meet criteria for critical values]

**Critical Result:** [Test name] = [Value] [Units]  
**Reference Range:** [Normal range]  
**Significance:** [Life-threatening, requires immediate action]

**Notification:**
- **Called to:** [Name and title of person notified]
- **Date/Time:** [MM/DD/YYYY at HH:MM]
- **Read-back verified:** [Yes]
- **Notified by:** [Lab personnel name]

**Example Critical Values:**
- Glucose <40 mg/dL or >500 mg/dL
- Potassium <2.5 mEq/L or >6.5 mEq/L
- Sodium <120 mEq/L or >160 mEq/L
- Hemoglobin <5.0 g/dL
- Platelets <20 × 10³/μL
- WBC <1.0 × 10³/μL or >50 × 10³/μL
- INR >5.0 (on warfarin)
- Positive blood culture
- Positive CSF Gram stain

---

## Quality Control

**Specimen Quality:** [Acceptable / See note]

**QC Notes:**
- [X] Specimen collected in appropriate tube
- [X] Specimen adequately labeled
- [X] Specimen volume sufficient
- [X] No hemolysis, lipemia, or icterus
- [X] Specimen processed within acceptable time

**Issues (if any):**
- [ ] Hemolyzed - may affect [specific tests]
- [ ] Clotted - unable to perform coagulation studies
- [ ] Insufficient volume - limited testing performed
- [ ] Delayed processing - stability concerns for [specific analytes]

---

## Methodology

**Test Method:** [Instrumentation and methodology]

Examples:
- **CBC:** Automated cell counter (Sysmex XN-1000)
- **Chemistry:** Spectrophotometry (Beckman AU5800)
- **Glucose:** Enzymatic assay, hexokinase method
- **HbA1c:** HPLC (high-performance liquid chromatography)
- **Troponin:** High-sensitivity immunoassay
- **Drug levels:** Liquid chromatography-mass spectrometry (LC-MS/MS)

---

## Special Tests Examples

### Hemoglobin A1c

| Test | Result | Units | Interpretation |
|------|--------|-------|----------------|
| HbA1c | 8.5 | % | Consistent with poorly controlled diabetes |
| HbA1c | 8.5 | % (69 mmol/mol) | Target <7% for most patients |

**Reference Ranges:**
- Non-diabetic: 4.0-5.6%
- Prediabetes: 5.7-6.4%
- Diabetes diagnosis: ≥6.5%
- Treatment target: <7% (individualized)

### Lipid Panel

| Test | Result | Units | Reference Range | Desirable |
|------|--------|-------|----------------|-----------|
| Total Cholesterol | 245 | mg/dL | - | <200 |
| LDL Cholesterol | 160 | mg/dL | - | <100 |
| HDL Cholesterol | 38 | mg/dL | - | >40 (M), >50 (F) |
| Triglycerides | 235 | mg/dL | - | <150 |
| VLDL Cholesterol (calc) | 47 | mg/dL | - | <30 |

### Coagulation Studies

| Test | Result | Units | Reference Range | Flag |
|------|--------|-------|----------------|------|
| PT | 18.5 | seconds | 11.0-13.5 | H |
| INR | 2.8 | ratio | 0.8-1.2 | H |
| PTT | 42 | seconds | 25-35 | H |

**Therapeutic Ranges (INR):**
- Atrial fibrillation: 2.0-3.0
- Mechanical heart valve: 2.5-3.5
- DVT/PE treatment: 2.0-3.0

### Thyroid Function Tests

| Test | Result | Units | Reference Range | Flag |
|------|--------|-------|----------------|------|
| TSH | 8.5 | μIU/mL | 0.4-4.0 | H |
| Free T4 | 0.7 | ng/dL | 0.8-1.8 | L |
| Free T3 | 2.1 | pg/mL | 2.3-4.2 | L |

**Interpretation:** Findings consistent with primary hypothyroidism

### Urinalysis

**Physical Examination:**
- Color: [Yellow / Amber / Other]
- Clarity: [Clear / Cloudy / Turbid]
- Specific Gravity: [1.005-1.030]

**Chemical Examination:**
| Test | Result | Reference |
|------|--------|-----------|
| pH | 6.0 | 5.0-8.0 |
| Protein | Trace | Negative |
| Glucose | Negative | Negative |
| Ketones | Negative | Negative |
| Blood | 2+ | Negative |
| Bilirubin | Negative | Negative |
| Urobilinogen | Normal | Normal |
| Nitrite | Negative | Negative |
| Leukocyte Esterase | Positive | Negative |

**Microscopic Examination (if indicated):**
- WBCs: [number] /hpf (normal <5)
- RBCs: [number] /hpf (normal <3)
- Epithelial cells: [Few/Moderate/Many]
- Bacteria: [None/Few/Moderate/Many]
- Casts: [Type and number]
- Crystals: [Type if present]

---

## Microbiology Report Format

### Culture Results

**Specimen Source:** [Blood / Urine / Sputum / Wound / Other]  
**Collection:** [Date and time]

**Gram Stain:**
[Results of Gram stain if performed]
Example: "Many Gram-positive cocci in clusters, many WBCs"

**Culture Results:**

**Organism:** [Identified organism]  
**Quantity:** [Light / Moderate / Heavy growth] or [CFU count]

**Antimicrobial Susceptibility Testing:**

| Antibiotic | Result | MIC (μg/mL) |
|------------|--------|-------------|
| [Drug name] | S/I/R | [Value] |

Example:
| Antibiotic | Result | MIC |
|------------|--------|-----|
| Ampicillin | R | >16 |
| Ceftriaxone | S | ≤1 |
| Levofloxacin | S | 0.5 |
| Vancomycin | S | 1 |

**Interpretation:** S = Susceptible, I = Intermediate, R = Resistant

---

## Molecular/Genetic Testing

**Test:** [Specific test name]  
**Method:** [PCR / Sequencing / Array / Other]  
**Result:** [Detected / Not detected / Variant identified]

**Interpretation:**
[Clinical significance of result]

---

## Reference Laboratory Results

[For send-out tests]

**Test:** [Name]  
**Performed by:** [Reference lab name and location]  
**Result:** [Value]  
**Reference Range:** [Range]  
**Method:** [Methodology]  
**Reported:** [Date]

---

## Laboratory Director Signature

**Medical Director:**  
[Name, MD]  
[Board Certifications]  
[CLIA License Number]

**Electronically signed:** [Date]

---

## LOINC Codes (for interoperability)

[LOINC codes for each test when applicable for electronic reporting]

Example:
- Hemoglobin: 718-7
- Glucose: 2345-7
- Creatinine: 2160-0
- TSH: 3016-3


