# SOAP Note Template

## Patient Information

**Patient Name:** [Last, First] or [Patient ID for teaching/research contexts]  
**Date of Birth:** [MM/DD/YYYY]  
**Medical Record Number:** [MRN]  
**Date of Visit:** [MM/DD/YYYY]  
**Time:** [HH:MM]  
**Location:** [Clinic, Hospital Floor, ED, etc.]  
**Provider:** [Your name and credentials]

---

## S - SUBJECTIVE

### Chief Complaint (CC)
"[Patient's chief complaint in their own words]"

### History of Present Illness (HPI)

[Patient Name] is a [age]-year-old [sex] with a history of [relevant PMHx] who presents with [chief complaint].

**Onset:** [When did symptoms start? Sudden or gradual?]

**Location:** [Where is the symptom? Does it radiate?]

**Duration:** [How long has this been going on?]

**Characterization:** [Describe the quality - sharp, dull, burning, etc.]

**Aggravating factors:** [What makes it worse?]

**Relieving factors:** [What makes it better?]

**Timing:** [Constant or intermittent? Frequency?]

**Severity:** [How bad is it? 0-10 scale if pain]

**Associated symptoms:** [Other symptoms occurring with this?]

**Prior treatment and response:** [What has patient tried? Did it help?]

**Functional impact:** [How does this affect daily activities?]

**Review of Systems (pertinent to visit):**
- Constitutional: [fever, chills, weight change, fatigue, night sweats]
- [Other relevant systems based on chief complaint]
- **Pertinent negatives:** [Important symptoms patient denies]

---

## O - OBJECTIVE

### Vital Signs
- Temperature: \_\_\_\_\_ °F (oral/axillary/tympanic)
- Blood Pressure: \_\_\_\_\_/\_\_\_\_\_ mmHg
- Heart Rate: \_\_\_\_\_ bpm
- Respiratory Rate: \_\_\_\_\_ breaths/min
- Oxygen Saturation: \_\_\_\_\_% on [room air / O2 at \_\_ L/min]
- Height: \_\_\_\_\_ cm / inches
- Weight: \_\_\_\_\_ kg / lbs
- BMI: \_\_\_\_\_ kg/m²
- Pain Score: \_\_\_/10

### Physical Examination

**General Appearance:**  
[Well-appearing, no distress / ill-appearing / mild/moderate/severe distress]

**HEENT:**  
- Head: [Normocephalic, atraumatic]
- Eyes: [PERRLA, EOMI, conjunctiva, sclera]
- Ears: [TMs clear bilaterally, canals patent]
- Nose: [Nares patent, no discharge]
- Throat: [Oropharynx clear, no erythema or exudate, mucosa moist]

**Neck:**  
[Supple, no lymphadenopathy, no thyromegaly, no JVD, carotids 2+ without bruits]

**Cardiovascular:**  
[RRR, normal S1/S2, no murmurs/rubs/gallops] OR [describe abnormalities]  
[Peripheral pulses: radial 2+/2+ bilaterally, dorsalis pedis 2+/2+ bilaterally]

**Pulmonary:**  
[Lungs clear to auscultation bilaterally, no wheezes/rales/rhonchi, normal work of breathing] OR [describe abnormalities]

**Abdomen:**  
[Soft, non-tender, non-distended, normoactive bowel sounds, no masses, no hepatosplenomegaly, no rebound/guarding]

**Extremities:**  
[No edema, no cyanosis, no clubbing, full range of motion, no joint swelling or tenderness]

**Skin:**  
[Warm and dry, no rashes, no lesions, normal turgor, capillary refill <2 sec]

**Neurological:**  
- Mental status: [Alert and oriented to person, place, time]
- Cranial nerves: [II-XII intact] OR [specify abnormalities]
- Motor: [5/5 strength all extremities, normal tone]
- Sensory: [Intact to light touch and pinprick]
- Reflexes: [2+ symmetric, downgoing Babinski]
- Gait: [Normal / not assessed]
- Coordination: [Finger-to-nose intact, rapid alternating movements normal]

**Psychiatric:**  
[Normal mood and affect, thought process logical and goal-directed, no SI/HI]

### Laboratory Results (if applicable)
| Test | Result | Reference Range | Flag |
|------|--------|----------------|------|
| [Test name] | [Value] [unit] | [Range] | [H/L/-] |

### Imaging Results (if applicable)
[Modality] ([Date]): [Key findings]

### Other Diagnostic Tests
[ECG, etc.]: [Results]

---

## A - ASSESSMENT

### Problem List with Assessment

**1. [Primary Problem/Diagnosis] ([ICD-10 code])**
   - [Brief assessment: severity, stability, progress toward goals]
   - [Relevant exam and lab findings supporting diagnosis]
   - [Differential diagnosis if uncertain]

**2. [Secondary Problem/Diagnosis] ([ICD-10 code])**
   - [Assessment]

**3. [Additional problems as needed]**

### Overall Assessment
[Summary statement about patient's overall status, response to treatment, trajectory]

---

## P - PLAN

### Problem-Based Plan

**1. [Primary Problem]**

**Diagnostics:**
- [Further tests, labs, imaging, consultations needed]
- [Rationale for testing]

**Therapeutics:**
- [Medications:]
  - [Drug name] [dose] [route] [frequency] x [duration]
  - Indication: [Why prescribed]
- [Procedures or interventions]
- [Non-pharmacological interventions]

**Monitoring:**
- [What to monitor, how often]
- [Parameters for follow-up labs or imaging]

**Education:**
- [Topics discussed with patient]
- [Patient understanding verified]
- [Written materials provided]

**Follow-up:**
- [When and where]
- [Specific goals for follow-up visit]

**Return Precautions:**
- [When to seek urgent/emergency care]
- [Warning signs discussed]

**2. [Secondary Problem]**

**Diagnostics:**
- [Tests or studies]

**Therapeutics:**
- [Medications or interventions]

**Monitoring:**
- [Parameters to follow]

**3. [Additional Problems]**
[Plan for each problem]

### Overall Plan Summary
- Total new prescriptions: [number]
- Referrals placed: [specialty, reason]
- Follow-up appointment: [date/timeframe and with whom]
- Patient verbalized understanding of plan: [Yes/No, questions answered]
- Time spent: [Total time and time spent on counseling/coordination if relevant for billing]

---

## Billing Information (if applicable)

**CPT Code:** [E/M code - 99201-99215 for office visits]

**Level of Service Justification:**
- History: [Problem focused / Expanded / Detailed / Comprehensive]
- Exam: [Problem focused / Expanded / Detailed / Comprehensive]
- Medical Decision Making: [Straightforward / Low / Moderate / High complexity]
  - Number of diagnoses/management options: [Minimal / Limited / Multiple / Extensive]
  - Amount of data to review: [Minimal / Limited / Moderate / Extensive]
  - Risk: [Minimal / Low / Moderate / High]

[OR if time-based:]
- Total time: [minutes]
- Time spent on counseling/coordination: [minutes] (>50% of visit)

---

## Signature

[Provider name, credentials]  
[Electronic signature or handwritten signature]  
[Date and time of documentation]

---

## Notes for Using This Template

**Best Practices:**
- Document as soon as possible after encounter
- Be specific and objective in observations
- Avoid copy-forward errors
- Review and update problem list
- Sign and date all entries
- Use standard abbreviations only

**Billing Considerations:**
- Document medical necessity
- Match documentation level to billing code
- For time-based billing, document total time and counseling time
- Include relevant history, exam, and MDM elements

**Legal Considerations:**
- Document facts, not opinions
- Quote patient when relevant
- Document non-compliance objectively
- Never alter records - use addendum for corrections
- Ensure legibility

**Customization:**
- Adapt level of detail to setting (quick outpatient visit vs. complex hospital consultation)
- Include or exclude sections as relevant
- Follow institutional templates if required
- Use problem-oriented approach consistently


