# Clinical Case Report Guidelines

## CARE Guidelines (CAse REport)

The CARE guidelines provide a framework for transparent and complete reporting of clinical cases. The CARE checklist ensures that case reports contain all necessary information for readers to assess the validity and applicability of the findings.

### CARE Checklist Items

#### Title (1 item)

**1. Title**
- Include the words "case report" or "case study" in the title
- Indicate the area of focus
- Be specific about the condition or intervention
- Examples:
  - Good: "Delayed Presentation of Aortic Dissection Mimicking Pneumonia: A Case Report"
  - Poor: "An Interesting Case"

#### Keywords (1 item)

**2. Keywords**
- Provide 2-5 keywords
- Use MeSH (Medical Subject Headings) terms when possible
- Facilitate indexing and search

ability
- Examples: "aortic dissection," "atypical presentation," "diagnostic imaging"

#### Abstract (4 items)

**3a. Introduction**
- What is unique about this case?
- Why is it worth reporting?
- 1-2 sentences

**3b. Patient's main concerns and important clinical findings**
- Primary symptoms
- Key physical examination or diagnostic findings

**3c. Main diagnoses, therapeutics interventions, and outcomes**
- Final diagnosis
- Key treatments
- Clinical outcome

**3d. Conclusion**
- What are the main takeaway messages?
- Clinical implications

**Abstract Length:** Typically 150-250 words, structured or unstructured depending on journal

#### Introduction (2 items)

**4. Background**
- Brief background on the medical condition
- Epidemiology if relevant
- Current understanding and management
- 2-4 paragraphs

**5. Why is this case novel?**
- What makes this case worth reporting?
- Unique presentation, diagnosis, or outcome
- Contribution to medical knowledge
- Literature gap being addressed

#### Patient Information (4 items)

**6. Patient demographics and other information**
- Age, sex, race/ethnicity (if relevant)
- Occupation (if relevant to case)
- Living situation (if relevant)
- Example: "A 45-year-old African American woman"

**7. Main symptoms of patient**
- Chief complaint
- Presenting symptoms
- Duration and characteristics
- Example: "Presented with sudden onset severe chest pain radiating to the back, associated with dyspnea"

**8. Medical, family, and psychosocial history**
- Relevant past medical history
- Medications and allergies
- Family history of relevant conditions
- Social history (smoking, alcohol, drugs, occupation)
- Prior treatments or interventions

**9. Relevant past interventions and outcomes**
- Prior hospitalizations
- Previous treatments for same or related conditions
- Outcomes of prior interventions

#### Clinical Findings (1 item)

**10. Describe the relevant physical examination findings**
- Vital signs
- Physical examination by system
- Pertinent positive findings
- Important negative findings
- Example:
  - "Vital signs: BP 180/110 mmHg (right arm), 140/80 mmHg (left arm), HR 105 bpm, RR 24/min
  - Cardiovascular: Diastolic murmur heard over left sternal border, diminished pulse in left radial artery
  - Pulmonary: Decreased breath sounds in left lung base"

#### Timeline (1 item)

**11. Describe important dates and times in this case**
- Chronological summary of events
- Onset of symptoms
- Healthcare encounters
- Diagnostic procedures
- Interventions
- Outcomes and follow-up

**Timeline Format Options:**
1. **Table format:**

| Date | Event |
|------|-------|
| Day 0 | Onset of chest pain and dyspnea |
| Day 0, 2 hours | Presented to emergency department |
| Day 0, 4 hours | CT angiography performed, diagnosed with aortic dissection |
| Day 0, 6 hours | Emergency surgery performed |
| Day 7 | Discharged home in stable condition |
| Month 3 | Follow-up imaging shows complete healing |

2. **Figure/graphic timeline**
3. **Narrative timeline embedded in text**

#### Diagnostic Assessment (5 items)

**12a. Diagnostic methods**
- List all diagnostic tests performed
- Laboratory tests
- Imaging studies
- Procedures (biopsy, catheterization, etc.)
- Pathology results
- Genetic testing if applicable

**12b. Diagnostic challenges**
- Difficulty in reaching diagnosis
- Atypical presentations
- Misleading initial findings
- Time to diagnosis

**12c. Diagnostic reasoning**
- Differential diagnosis considered
- Clinical reasoning process
- Why certain tests were ordered
- How diagnosis was narrowed

**12d. Prognostic characteristics**
- Severity of condition
- Staging if applicable
- Risk factors
- Expected prognosis

**12e. Strengths and limitations of diagnostic approaches**
- Appropriateness of diagnostic methods
- Limitations of tests used
- Alternative approaches considered

#### Therapeutic Intervention (4 items)

**13a. Types of interventions**
- Pharmacological interventions (medications with doses, routes, duration)
- Procedural or surgical interventions
- Lifestyle interventions
- Psychosocial interventions
- Complementary/alternative therapies
- Preventive interventions

Example:
- "Labetalol IV drip initiated for blood pressure control
- Emergency open surgical repair of ascending aortic dissection performed
- Post-operative anticoagulation withheld
- Beta-blocker and ACE inhibitor initiated post-operatively"

**13b. Administration of interventions**
- Timing of interventions
- Setting (emergency, inpatient, outpatient)
- Healthcare providers involved
- Patient adherence

**13c. Changes to interventions**
- Modifications during course of treatment
- Dose adjustments
- Changes due to adverse effects
- Switches to alternative therapies
- Rationale for changes

**13d. Strengths and limitations**
- Why these interventions were chosen
- Evidence supporting interventions
- Alternatives considered
- Limitations or barriers to treatment

#### Follow-Up and Outcomes (2 items)

**14a. Clinician and patient-assessed outcomes**
- Objective clinical outcomes
- Laboratory or imaging results
- Functional outcomes
- Patient-reported outcomes
- Quality of life
- Adverse events or complications

**14b. Important follow-up diagnostic and other test results**
- Follow-up imaging
- Laboratory monitoring
- Functional assessments
- Long-term outcomes
- Time points of follow-up

#### Discussion (5 items)

**15a. Strengths and limitations**
- What makes this case valuable?
- Limitations in diagnosis or treatment
- Limitations of case report methodology
- Generalizability

**15b. Relevant medical literature**
- Comparison to similar published cases
- Relationship to current understanding
- Novel aspects compared to literature
- Number and quality of similar cases

**15c. Rationale for conclusions**
- Why these conclusions are drawn
- Strength of evidence
- Alternative explanations considered

**15d. Main takeaways**
- Clinical lessons learned
- Practical implications for clinicians
- Educational value
- Contribution to medical knowledge

**15e. Future research or clinical care**
- Questions raised by this case
- Suggestions for future research
- Implications for clinical practice
- Areas needing further investigation

#### Patient Perspective (1 item)

**16. Patient's perspective or experience**
- Patient's own description of experience
- Impact on quality of life
- Patient's priorities and preferences
- Satisfaction with care
- Direct quotes when appropriate (with consent)

Example: "The patient stated: 'I thought I was having a heart attack, but the pain was different than I expected. I'm grateful the doctors figured out what was wrong so quickly.'"

This section is optional but encouraged as it provides valuable patient-centered information.

#### Informed Consent (1 item)

**17. Informed consent statement**
- Document that informed consent was obtained
- Specify what consent covers (case details, images, etc.)
- State that consent is available for review
- For pediatric cases, document parental/guardian consent
- For deceased patients or those unable to consent, document proxy consent

Examples:
- "Written informed consent was obtained from the patient for publication of this case report and accompanying images. A copy of the written consent is available for review by the Editor-in-Chief of this journal."
- "The patient provided written informed consent for publication of this case report. All identifying information has been removed to protect patient privacy."
- "Written informed consent was obtained from the patient's next of kin for publication of this case report as the patient was deceased at the time of manuscript preparation."

## Journal-Specific Requirements

### High-Impact Medical Journals

#### The Lancet
- Case reports rarely accepted (only if exceptional clinical significance)
- Prefer brief case reports (500-600 words, 1 figure)
- Structured abstract required
- Maximum 10 references

#### New England Journal of Medicine (NEJM)
- Clinical Problem-Solving format for diagnostic challenges
- Case Records of the Massachusetts General Hospital (CPC format)
- Brief case reports in Images in Clinical Medicine
- Strict word limits (typically <750 words for Images)

#### JAMA
- Brief case reports in Clinical Challenge format
- Focus on diagnostic reasoning
- Maximum 600 words
- 1-2 figures allowed

### Specialty Journals

#### BMJ Case Reports
- All case reports must follow CARE guidelines
- Structured abstract required
- Learning points section required (3-5 bullet points)
- Patient consent form required
- Word limit: 3000 words (excluding abstract and references)

#### Journal of Medical Case Reports
- Strictly follows CARE guidelines
- Open access publication
- Structured abstract: Background, Case presentation, Conclusions
- Timeline required
- Patient perspective encouraged

#### American Journal of Case Reports
- Open access
- Follows CARE guidelines
- Structured abstract required
- Minimum 1500 words
- No upper word limit

## De-identification and Privacy

### 18 HIPAA Identifiers to Remove

Complete list of protected health information (PHI) that must be removed for Safe Harbor de-identification:

1. **Names** - Patient name, family members' names, healthcare provider names
2. **Geographic subdivisions smaller than state** - Street addresses, cities, counties, ZIP codes (can keep first 3 digits if >20,000 people in area)
3. **Dates** - Exact dates of birth, admission, discharge, death (keep year or use intervals)
4. **Telephone numbers** - Any phone numbers related to patient
5. **Fax numbers**
6. **Email addresses**
7. **Social Security numbers**
8. **Medical record numbers**
9. **Health plan beneficiary numbers**
10. **Account numbers**
11. **Certificate/license numbers**
12. **Vehicle identifiers** - License plates, VINs
13. **Device identifiers and serial numbers** - Pacemakers, implants (unless generic)
14. **Web URLs**
15. **IP addresses**
16. **Biometric identifiers** - Fingerprints, voice prints, retinal scans
17. **Full-face photographs** - Must obscure or obtain consent
18. **Any other unique identifying characteristic or code**

### De-identification Best Practices

**Age Reporting:**
- For adults: Can use exact age or age ranges (e.g., "a woman in her 50s")
- For patients >89 years: Must aggregate (e.g., "a woman in her 90s" or ">89 years")
- For pediatric cases: Use months for infants, years for children

**Date Reporting:**
- Use relative time intervals instead of exact dates
- Example: "Three months prior to presentation..." instead of "On January 15, 2023..."
- Can keep year if needed for context
- Use "Day 0, Day 1, Day 2" for timelines

**Location:**
- State or country acceptable
- Remove city, hospital name, specific clinic
- Example: "A community hospital in the Midwest" or "A tertiary care center in California"

**Rare Conditions:**
- Very rare conditions may themselves be identifying
- Consider whether the combination of diagnosis, location, and timeframe could identify patient
- May need to be vague about certain details

**Images:**
- Crop or blur faces
- Remove jewelry, tattoos, or identifying marks
- Crop images to show only relevant clinical findings
- Consider using illustrations instead of photographs
- Black bars over eyes are NOT sufficient
- Get explicit consent for recognizable images

**Pathology and Imaging:**
- Remove patient identifiers from image headers
- Remove dates from images
- Remove medical record numbers from labels

## Writing Style and Language

### Clarity and Precision

**Use clear, specific language:**
- Good: "The patient's hemoglobin decreased from 12.5 g/dL to 7.2 g/dL over 48 hours"
- Poor: "The patient's blood count dropped significantly"

**Avoid ambiguous terms:**
- Instead of "several," specify the number
- Instead of "recently," give timeframe
- Instead of "significant," provide exact values and p-values if applicable

**Use active voice when appropriate:**
- Good: "We diagnosed the patient with acute appendicitis"
- Acceptable: "The patient was diagnosed with acute appendicitis"

### Professional Tone

- Objective and factual
- Avoid sensationalism
- Respectful toward patient and healthcare team
- Avoid value judgments
- Focus on clinical facts and medical reasoning

### Tense

- **Abstract**: Usually past tense
- **Introduction**: Present tense for background, past tense for case description
- **Case presentation**: Past tense
- **Discussion**: Present tense for established knowledge, past tense for this case

### Common Mistakes to Avoid

1. **Insufficient novelty** - Reporting common presentations without unique aspects
2. **Missing informed consent** - Failing to obtain or document consent
3. **Inadequate de-identification** - Leaving identifiable information
4. **Poor literature review** - Not contextualizing within existing knowledge
5. **Excessive length** - Including unnecessary details
6. **Lack of structure** - Not following CARE guidelines or journal format
7. **Overgeneralization** - Drawing broad conclusions from one case
8. **Missing timeline** - Not providing clear chronology
9. **Vague outcomes** - Not clearly describing clinical outcome
10. **No learning points** - Failing to articulate clinical lessons

## Learning Points Format

Many journals require a "Learning Points" or "Key Messages" section with 3-5 bulleted takeaways.

**Characteristics of good learning points:**
- Concise (1-2 sentences each)
- Clinically actionable
- Generalizable beyond this specific case
- Focus on diagnosis, treatment, or recognition
- Avoid overgeneralization

**Example:**
- "Aortic dissection can present with atypical symptoms that mimic pneumonia, including cough and dyspnea without chest pain."
- "Blood pressure differential between arms >20 mmHg should raise suspicion for aortic dissection."
- "CT angiography is the gold standard for diagnosing acute aortic dissection and should be performed urgently in high-risk patients."

## Literature Search Strategies

**Databases to search:**
- PubMed/MEDLINE
- Embase
- Google Scholar
- Scopus
- Web of Science

**Search terms:**
- Disease or condition name
- Key clinical features
- Treatment or intervention
- Use MeSH terms
- Combine with "case report" or "case series"

**When citing literature:**
- Cite most relevant and recent cases
- Include systematic reviews if available
- Cite original descriptions of rare conditions
- Balance supporting and contrasting evidence
- Typically 15-30 references for case report

## Ethical Considerations

### Informed Consent

**Required elements:**
- Purpose of publication
- What will be published (case details, images, outcomes)
- De-identification efforts
- Open access considerations (public availability)
- No effect on clinical care
- Right to withdraw
- Contact for questions

**Timing:**
- Best obtained during or shortly after clinical care
- Can be obtained retrospectively if patient available
- For deceased patients, next of kin consent

**Special situations:**
- Pediatric patients: Parent/guardian consent
- Incapacitated patients: Legal representative consent
- Deceased patients: Next of kin consent
- Patients lost to follow-up: Discuss with editor

### Authorship

**ICMJE criteria for authorship (all must be met):**
1. Substantial contributions to conception/design or acquisition/analysis/interpretation of data
2. Drafting or critically revising for important intellectual content
3. Final approval of version to be published
4. Agreement to be accountable for all aspects of the work

**Common authorship roles in case reports:**
- First author: Primary writer, often junior physician/trainee
- Senior author: Attending physician, supervisor
- Co-authors: Contributing specialists, consultants
- Acknowledgments: Contributors not meeting authorship criteria

## Submission Process

### Cover Letter Elements

- Brief introduction of the case
- Statement of novelty and significance
- Confirmation of CARE guideline adherence
- Statement that manuscript is not under consideration elsewhere
- Disclosure of any conflicts of interest
- Corresponding author contact information

### Required Documents

- Manuscript (following journal format)
- CARE checklist (completed)
- Patient consent form
- Copyright transfer agreement
- Conflict of interest disclosure
- ORCID iDs for all authors
- Cover letter

### Revision and Peer Review

**Common reviewer requests:**
- Expand literature review
- Clarify timeline
- Add more detail to diagnostics or treatment
- Improve discussion of pathophysiology
- Strengthen learning points
- Verify consent documentation
- Improve image quality

**Response to reviewers:**
- Address each comment point-by-point
- Provide line numbers for changes
- Justify if not making requested change
- Thank reviewers for feedback
- Proofread revised manuscript

## Case Report Formats by Type

### Diagnostic Challenge

Focus on diagnostic reasoning process, differential diagnosis, and key diagnostic clues.

### Rare Disease or Presentation

Emphasize rarity, epidemiology, and contribution to medical knowledge about the condition.

### Adverse Drug Reaction

Include drug details (dose, duration), timeline, causality assessment (Naranjo scale), and outcome after discontinuation.

### Treatment Innovation

Describe novel treatment approach, rationale, outcome, and comparison to standard treatment.

### Unexpected Outcome

Describe unexpected response to treatment or unusual disease course.

## Supplementary Resources

- CARE website: https://www.care-statement.org/
- CARE checklist: Available in multiple languages
- Example case reports: Review published cases in target journal
- Medical writing courses: Many institutions offer case report writing workshops

---

This reference provides comprehensive guidance for writing clinical case reports following CARE guidelines. Refer to this document when preparing case reports for journal submission, and use the CARE checklist to ensure completeness before submission.

