# Patient Documentation Standards

## SOAP Notes

SOAP (Subjective, Objective, Assessment, Plan) is the standard format for progress notes in clinical practice.

### Purpose and Use

**When to use SOAP notes:**
- Daily progress notes in hospital
- Outpatient visit documentation
- Subspecialty consultations
- Follow-up visits
- Documenting response to treatment

**Benefits:**
- Standardized structure
- Organized clinical reasoning
- Facilitates communication
- Supports billing and coding
- Legal documentation

### SOAP Components

#### S - Subjective

**Definition:** Information reported by the patient (symptoms, concerns, history)

**Elements to include:**
- Chief complaint or reason for visit
- History of present illness (HPI)
- Review of systems (ROS) relevant to visit
- Patient's description of symptoms
- Response to prior treatments
- Functional impact
- Patient concerns or questions

**HPI Elements (use OPQRST for pain/symptoms):**
- **O**nset: When did it start? Sudden or gradual?
- **P**rovocation/Palliation: What makes it better or worse?
- **Q**uality: What does it feel like? (sharp, dull, burning, etc.)
- **R**egion/Radiation: Where is it? Does it spread?
- **S**everity: How bad is it? (0-10 scale)
- **T**iming: Constant or intermittent? Duration? Frequency?

**Associated symptoms:**
- Other symptoms occurring with primary complaint
- Pertinent negatives (absence of expected symptoms)

**Response to treatment:**
- Medications taken and effect
- Prior interventions and outcomes
- Compliance with treatment plan

**Example Subjective section:**
```
S: Patient reports persistent cough for 5 days, productive of yellow sputum. Associated
with fever to 101.5°F, measured at home yesterday. Denies shortness of breath, chest
pain, or hemoptysis. Started on azithromycin 2 days ago by urgent care, with minimal
improvement. Reports decreased appetite but able to maintain hydration. Denies recent
travel or sick contacts.
```

#### O - Objective

**Definition:** Measurable, observable clinical data

**Elements to include:**

**Vital Signs:**
- Temperature (°F or °C)
- Blood pressure (mmHg)
- Heart rate (bpm)
- Respiratory rate (breaths/min)
- Oxygen saturation (%)
- Height and weight (calculate BMI)
- Pain score if applicable

**General Appearance:**
- Overall appearance (well, ill, distressed)
- Age appropriateness
- Nutritional status
- Hygiene
- Affect and behavior

**Physical Examination by System:**
- Organized head-to-toe or by systems
- Relevant findings for presenting complaint
- Include pertinent positives and negatives

**Standard examination systems:**
1. **HEENT** (Head, Eyes, Ears, Nose, Throat)
2. **Neck** (thyroid, lymph nodes, JVD, carotids)
3. **Cardiovascular** (heart sounds, murmurs, peripheral pulses, edema)
4. **Pulmonary/Respiratory** (breath sounds, work of breathing)
5. **Abdomen** (bowel sounds, tenderness, organomegaly, masses)
6. **Extremities** (edema, pulses, ROM, deformities)
7. **Neurological** (mental status, cranial nerves, motor, sensory, reflexes, gait)
8. **Skin** (rashes, lesions, wounds)
9. **Psychiatric** (mood, affect, thought process/content)

**Laboratory and Imaging Results:**
- Relevant test results
- Include reference ranges for abnormal values
- Note timing of tests relative to visit

**Example Objective section:**
```
O: Vitals: T 100.8°F, BP 128/82, HR 92, RR 18, SpO2 96% on room air
General: Alert, mild respiratory distress, appears mildly ill
HEENT: Oropharynx without erythema or exudates, TMs clear bilaterally
Neck: No lymphadenopathy, no JVD
Cardiovascular: Regular rate and rhythm, no murmurs
Pulmonary: Decreased breath sounds right lower lobe, dullness to percussion, egophony
present. No wheezes.
Abdomen: Soft, non-tender, no organomegaly
Extremities: No edema, pulses 2+ bilaterally
Neurological: Alert and oriented x3, no focal deficits

Labs (drawn today):
WBC 14.2 x10³/μL (H) [ref 4.5-11.0]
Hemoglobin 13.5 g/dL
Platelets 245 x10³/μL
CRP 8.5 mg/dL (H) [ref <0.5]

Chest X-ray: Right lower lobe consolidation consistent with pneumonia
```

#### A - Assessment

**Definition:** Clinical impression, diagnosis, and evaluation of patient status

**Elements to include:**
- Primary diagnosis or problem
- Secondary diagnoses or problems
- Differential diagnosis if uncertain
- Severity assessment
- Progress toward treatment goals
- Complications or new problems

**Format:**
- Problem list (numbered)
- Each problem with brief assessment
- Include ICD-10 codes when appropriate for billing

**Example Assessment section:**
```
A: 
1. Community-acquired pneumonia (CAP), right lower lobe (J18.1)
   - Moderate severity (CURB-65 score 1)
   - Appropriate for outpatient management
   - Minimal improvement on azithromycin, likely bacterial etiology
   
2. Dehydration, mild (E86.0)
   - Secondary to decreased PO intake
   
3. Type 2 diabetes mellitus (E11.9)
   - Well-controlled, continue home medications
```

#### P - Plan

**Definition:** Diagnostic and therapeutic interventions

**Elements to include:**
- Diagnostic plan (further testing, imaging, referrals)
- Therapeutic plan (medications, procedures, therapies)
- Patient education and counseling
- Follow-up arrangements
- Specific instructions for patient
- Return precautions (when to seek urgent care)

**Medication documentation:**
- Drug name (generic preferred)
- Dose and route
- Frequency
- Duration
- Indication

**Plan organization:**
- By problem (matches assessment)
- By intervention type (diagnostics, therapeutics, education)

**Example Plan section:**
```
P:
1. Community-acquired pneumonia:
   Diagnostics: None additional at this time
   Therapeutics:
   - Discontinue azithromycin
   - Start amoxicillin-clavulanate 875/125 mg PO BID x 7 days
   - Supportive care: adequate hydration, rest, acetaminophen for fever
   Education: 
   - Explained bacterial pneumonia diagnosis and antibiotic change
   - Discussed expected improvement within 48-72 hours
   - Return precautions: worsening dyspnea, high fever >103°F, confusion
   Follow-up: Phone call in 48 hours to assess response, clinic visit in 1 week
   
2. Dehydration:
   - Encourage PO fluids, goal 2 liters/day
   - Sports drinks or electrolyte solutions acceptable
   
3. Type 2 diabetes:
   - Continue metformin 1000 mg PO BID
   - Home glucose monitoring
   - Follow-up with endocrinology as scheduled

Patient verbalized understanding and agreement with plan.
```

### SOAP Note Best Practices

**Documentation standards:**
- Write legibly if handwritten
- Use standard abbreviations only
- Date and time each entry
- Sign and credential all entries
- Document in real-time or as soon as possible
- Avoid copy-forward errors
- Review and update problem list

**Billing considerations:**
- Document medical necessity
- Match documentation to billing level
- Include required elements for E/M coding
- Document time for time-based billing

**Legal considerations:**
- Document facts, not opinions or judgment
- Quote patient when relevant
- Document non-compliance objectively
- Never alter records
- Use addendums for corrections

## History and Physical (H&P)

### Purpose

- Comprehensive baseline assessment
- Document patient status at admission or initial encounter
- Guide diagnosis and treatment planning
- Required within 24 hours of admission (TJC requirement)

### H&P Components

#### Header Information

- Patient name, DOB, MRN
- Date and time of examination
- Admitting diagnosis
- Attending physician
- Service
- Location (ED, floor, ICU)

#### Chief Complaint (CC)

**Definition:** Brief statement of why patient is seeking care

**Format:**
- One sentence
- Use patient's own words (in quotes)
- Example: CC: "I can't catch my breath"

#### History of Present Illness (HPI)

**Purpose:** Detailed chronological narrative of current problem

**Required elements (for billing):**
- Location
- Quality
- Severity
- Duration
- Timing
- Context
- Modifying factors
- Associated signs/symptoms

**Structure:**
- Opening statement (demographics, presenting problem)
- Chronological description
- Symptom characterization
- Prior workup or treatment
- What prompted presentation now

**Example:**
```
HPI: Mr. Smith is a 65-year-old man with history of CHF (EF 35%) who presents with
3 days of progressive dyspnea on exertion. Patient reports dyspnea now occurs with
walking 10 feet (baseline 1-2 blocks). Associated with orthopnea (now requiring
3 pillows, baseline 1) and lower extremity swelling. Denies chest pain, palpitations,
or syncope. Reports medication compliance but notes running out of furosemide 2 days
ago. Weight increased 8 lbs over past week. Has not been monitoring daily weights
at home. Presented to ED today when dyspnea worsened and developed while at rest.
```

#### Past Medical History (PMH)

**Include:**
- Chronic medical conditions
- Previous hospitalizations
- Major illnesses
- Injuries
- Childhood illnesses (if relevant)

**Format:**
```
PMH:
1. Heart failure with reduced ejection fraction (2018), EF 35% on echo 6 months ago
2. Coronary artery disease, s/p CABG (2019)
3. Type 2 diabetes mellitus (2010)
4. Hypertension (2005)
5. Chronic kidney disease stage 3 (baseline Cr 1.8 mg/dL)
6. Hyperlipidemia
```

#### Past Surgical History (PSH)

**Include:**
- All surgeries and procedures
- Dates (year acceptable if exact date unknown)
- Complications if any

**Format:**
```
PSH:
1. CABG x4 (2019), complicated by post-op atrial fibrillation
2. Cholecystectomy (2015)
3. Appendectomy (childhood)
```

#### Medications

**Documentation:**
- Generic name preferred
- Dose, route, frequency
- Indication if not obvious
- Include over-the-counter medications
- Herbal supplements
- Note if patient unable to provide list

**Format:**
```
Medications:
1. Furosemide 40 mg PO daily (ran out 2 days ago)
2. Carvedilol 12.5 mg PO BID
3. Lisinopril 20 mg PO daily
4. Spironolactone 25 mg PO daily
5. Metformin 1000 mg PO BID
6. Atorvastatin 40 mg PO daily
7. Aspirin 81 mg PO daily
8. Multivitamin daily
```

#### Allergies

**Document:**
- Drug allergies with reaction
- Food allergies
- Environmental allergies
- NKDA if no known allergies

**Format:**
```
Allergies:
1. Penicillin → anaphylaxis (childhood)
2. Shellfish → hives
3. ACE inhibitors → angioedema
```

#### Family History (FH)

**Include:**
- First-degree relatives (parents, siblings, children)
- Age and health status or age at death and cause
- Relevant hereditary conditions
- Family history of presenting condition if relevant

**Format:**
```
Family History:
Father: CAD, MI age 58, alive age 85
Mother: Breast cancer, deceased age 72
Brother: Type 2 diabetes
Sister: Healthy
Children: 2 sons, both healthy
```

#### Social History (SH)

**Include:**
- Tobacco use (current, former, never; pack-years if applicable)
- Alcohol use (drinks per week, CAGE questions if indicated)
- Illicit drug use (current, former, never; type and route)
- Occupation
- Living situation (alone, with family, assisted living, etc.)
- Marital status
- Sexual history (if relevant)
- Exercise habits
- Diet
- Functional status

**Format:**
```
Social History:
Tobacco: Former smoker, quit 10 years ago (30 pack-year history)
Alcohol: 2-3 beers per week, denies binge drinking
Illicit drugs: Denies
Occupation: Retired electrician
Living situation: Lives at home with wife, 2-story house, bedroom upstairs
Marital status: Married
Exercise: Unable to exercise due to dyspnea
Diet: Low sodium diet (usually adherent)
Functional status: Independent in ADLs at baseline
```

#### Review of Systems (ROS)

**Purpose:** Systematic screening for symptoms by body system

**Requirements:**
- Minimum 10 systems for comprehensive exam
- Pertinent positives and negatives
- "All other systems reviewed and negative" acceptable if documented

**Systems:**
1. **Constitutional**: Fever, chills, night sweats, weight change, fatigue
2. **Eyes**: Vision changes, pain, discharge
3. **ENT**: Hearing loss, tinnitus, sinus problems, sore throat
4. **Cardiovascular**: Chest pain, palpitations, edema, claudication
5. **Respiratory**: Cough, dyspnea, wheezing, hemoptysis
6. **Gastrointestinal**: Nausea, vomiting, diarrhea, constipation, abdominal pain
7. **Genitourinary**: Dysuria, frequency, hematuria, incontinence
8. **Musculoskeletal**: Joint pain, swelling, stiffness, weakness
9. **Skin**: Rashes, lesions, itching, changes in moles
10. **Neurological**: Headache, dizziness, syncope, seizures, weakness, numbness
11. **Psychiatric**: Mood changes, depression, anxiety, sleep disturbance
12. **Endocrine**: Heat/cold intolerance, polyuria, polydipsia
13. **Hematologic/Lymphatic**: Easy bruising, bleeding, lymph node swelling
14. **Allergic/Immunologic**: Seasonal allergies, frequent infections

**Format:**
```
ROS:
Constitutional: Denies fever, chills. Reports fatigue and weight gain (8 lbs).
Cardiovascular: Reports dyspnea, orthopnea, lower extremity edema. Denies chest pain,
palpitations, syncope.
Respiratory: Denies cough, wheezing, hemoptysis.
Gastrointestinal: Denies nausea, vomiting, diarrhea, constipation, abdominal pain.
All other systems reviewed and negative.
```

#### Physical Examination

**General organization:**
- Vital signs first
- General appearance
- Systematic examination head-to-toe

**Vital signs:**
```
Vitals: T 98.2°F, BP 142/88, HR 105, RR 24, SpO2 88% on room air → 95% on 2L NC
Height: 5'10", Weight: 195 lbs (baseline 187 lbs), BMI 28
```

**System examinations:**

**General:** Well-developed, obese man in moderate respiratory distress, sitting upright in bed

**HEENT:**
- Head: Normocephalic, atraumatic
- Eyes: PERRLA, EOMI, no scleral icterus
- Ears: TMs clear bilaterally
- Nose: Nares patent, no discharge
- Throat: Oropharynx without erythema or exudates

**Neck:** Supple, no lymphadenopathy, JVP elevated to 12 cm, no thyromegaly

**Cardiovascular:**
- Inspection: No visible PMI
- Palpation: PMI laterally displaced
- Auscultation: Tachycardic regular rhythm, S3 gallop present, 2/6 holosystolic murmur at apex radiating to axilla
- Peripheral pulses: 2+ radial, 1+ dorsalis pedis bilaterally

**Pulmonary:**
- Inspection: Increased work of breathing, using accessory muscles
- Palpation: Tactile fremitus symmetric
- Percussion: Dullness to percussion at bilateral bases
- Auscultation: Bilateral crackles halfway up lung fields, no wheezes

**Abdomen:**
- Inspection: Obese, no distention
- Auscultation: Normoactive bowel sounds
- Percussion: Tympanic
- Palpation: Soft, non-tender, no masses, no hepatosplenomegaly

**Extremities:** 3+ pitting edema to mid-calf bilaterally, no cyanosis or clubbing

**Skin:** Warm and dry, no rashes

**Neurological:**
- Mental status: Alert and oriented to person, place, time
- Cranial nerves: II-XII intact
- Motor: 5/5 strength all extremities
- Sensory: Intact to light touch
- Reflexes: 2+ symmetric
- Gait: Deferred due to respiratory distress
- Cerebellar: Finger-to-nose intact

**Psychiatric:** Anxious affect appropriate to illness, normal thought process

#### Laboratory and Imaging

**Include:**
- All relevant labs with reference ranges
- Imaging studies with key findings
- ECG findings
- Other diagnostic tests

**Example:**
```
Laboratory Data:
CBC: WBC 8.5, Hgb 11.2 (L), Hct 34%, Plt 245
BMP: Na 132 (L), K 3.2 (L), Cl 98, CO2 30, BUN 45 (H), Cr 2.1 (H, baseline 1.8), glucose 145
Troponin: <0.04 (normal)
BNP: 1250 pg/mL (H, elevated)

Imaging:
Chest X-ray: Cardiomegaly, bilateral pleural effusions, pulmonary vascular congestion
consistent with volume overload

ECG: Sinus tachycardia at 105 bpm, left ventricular hypertrophy, no acute ST-T changes
```

#### Assessment and Plan

**Format:** Problem-based with numbered problem list

**Example:**
```
Assessment and Plan:

65-year-old man with history of CHF (EF 35%) presenting with acute decompensated
heart failure.

1. Acute decompensated heart failure (I50.23)
   - NYHA Class IV symptoms
   - Volume overload on exam and imaging
   - Precipitated by medication non-adherence (ran out of furosemide)
   - BNP elevated at 1250
   Diagnostics:
   - Echocardiogram to assess current EF and valvular function
   - Daily weights and strict I/O
   Therapeutics:
   - Furosemide 40 mg IV BID, goal negative 1-2L daily
   - Continue carvedilol, lisinopril, spironolactone
   - Oxygen 2L NC, goal SpO2 >92%
   - Low sodium diet (<2g/day), fluid restriction 1.5L/day
   - Telemetry monitoring
   Follow-up: Will reassess after diuresis, goal discharge in 3-5 days

2. Acute kidney injury on CKD stage 3 (N17.9, N18.3)
   - Cr 2.1 from baseline 1.8, likely prerenal from poor forward flow
   - Monitor daily, expect improvement with diuresis
   - Hold nephrotoxic agents

3. Hypokalemia (E87.6)
   - K 3.2, likely from prior diuretic use
   - Replete K 40 mEq PO x1, then reassess
   - Continue spironolactone for K-sparing effect

4. Hyponatremia (E87.1)
   - Na 132, likely dilutional from volume overload
   - Expect improvement with diuresis
   - Fluid restriction as above

5. Type 2 diabetes mellitus (E11.9)
   - Well-controlled
   - Continue home metformin
   - Monitor glucose while hospitalized

6. Coronary artery disease (I25.10)
   - Stable, no acute coronary syndrome
   - Continue aspirin, statin, beta-blocker

Code status: Full code
Disposition: Admit to telemetry floor
```

## Discharge Summary

### Purpose

- Communicate hospital care to outpatient providers
- Document hospital course and outcomes
- Ensure continuity of care
- Meet regulatory requirements (TJC, CMS)

### Timing

**Requirements:**
- Complete within 30 days of discharge (CMS)
- Many hospitals require within 24-48 hours
- Available at time of follow-up appointment

### Components

#### Header

- Patient demographics
- Admission date and discharge date
- Length of stay
- Attending physician
- Consulting services
- Primary care physician

#### Admission Diagnosis

Principal reason for hospitalization

#### Discharge Diagnosis

**Format:** Numbered list, prioritized

**Example:**
```
Discharge Diagnoses:
1. Acute decompensated heart failure
2. Acute kidney injury on chronic kidney disease stage 3
3. Hypokalemia
4. Hyponatremia
5. Coronary artery disease
6. Type 2 diabetes mellitus
```

#### Hospital Course

**Content:**
- Chronological narrative or problem-based
- Key events and interventions
- Response to treatment
- Procedures performed
- Consultations
- Complications
- Significant test results

**Example (brief):**
```
Hospital Course:
Mr. Smith was admitted with acute decompensated heart failure in the setting of
medication non-adherence. He was diuresed with IV furosemide with net negative
5 liters over 3 days, with significant improvement in dyspnea and resolution of
lower extremity edema. Echocardiogram showed persistent reduced EF of 30%, similar
to prior. Kidney function improved to baseline with diuresis. Electrolytes were
repleted and normalized. Patient was transitioned to oral furosemide on hospital
day 3 and remained stable. He was ambulating without dyspnea on room air by
discharge. Comprehensive heart failure education was provided.
```

#### Procedures

```
Procedures:
1. Echocardiogram transthoracic (hospital day 1)
```

#### Discharge Medications

**Format:**
- Complete list with instructions
- **NEW** medications highlighted
- **CHANGED** medications noted
- **DISCONTINUED** medications listed

**Example:**
```
Discharge Medications:
1. Furosemide 60 mg PO daily [INCREASED from 40 mg]
2. Carvedilol 12.5 mg PO BID [UNCHANGED]
3. Lisinopril 20 mg PO daily [UNCHANGED]
4. Spironolactone 25 mg PO daily [UNCHANGED]
5. Metformin 1000 mg PO BID [UNCHANGED]
6. Atorvastatin 40 mg PO daily [UNCHANGED]
7. Aspirin 81 mg PO daily [UNCHANGED]
```

#### Discharge Condition

```
Discharge Condition:
Hemodynamically stable, ambulatory, no supplemental oxygen requirement, euvolemic
on exam, baseline functional status restored.
```

#### Discharge Disposition

```
Discharge Disposition:
Home with self-care
```

#### Follow-up Plans

**Include:**
- Appointments scheduled
- Recommended follow-up timing
- Pending tests or studies at discharge
- Referrals made

**Example:**
```
Follow-up:
1. Cardiology appointment with Dr. Jones on [date] at [time]
2. Primary care with Dr. Smith in 1 week
3. Home health for vital sign monitoring and medication reconciliation
4. Repeat BMP in 1 week (arranged, lab slip provided)
```

#### Patient Instructions

**Include:**
- Activity restrictions
- Dietary restrictions
- Wound care (if applicable)
- Equipment or home services
- Monitoring instructions (daily weights, glucose, BP)
- Return precautions

**Example:**
```
Patient Instructions:
1. Weigh yourself daily every morning, call doctor if gain >2 lbs in 1 day or >5 lbs
   in 1 week
2. Low sodium diet (<2 grams per day)
3. Fluid restriction 2 liters per day
4. Take all medications as prescribed, do not run out of medications
5. Activity: Resume normal activities as tolerated
6. Return to ER or call 911 if: severe shortness of breath, chest pain, severe swelling,
   or other concerning symptoms
```

---

This reference provides comprehensive standards for patient clinical documentation including SOAP notes, H&P, and discharge summaries. Use these guidelines to ensure complete, accurate, and compliant clinical documentation.

