# Exploratory Data Analysis Report: {FILENAME}

**Generated:** {TIMESTAMP}

---

## Executive Summary

This report provides a comprehensive exploratory data analysis of the file `{FILENAME}`. The analysis includes file type identification, format-specific metadata extraction, data quality assessment, and recommendations for downstream analysis.

---

## Basic Information

- **Filename:** `{FILENAME}`
- **Full Path:** `{FILEPATH}`
- **File Size:** {FILE_SIZE_HUMAN} ({FILE_SIZE_BYTES} bytes)
- **Last Modified:** {MODIFIED_DATE}
- **Extension:** `.{EXTENSION}`
- **Format Category:** {CATEGORY}

---

## File Type Details

### Format Description
{FORMAT_DESCRIPTION}

### Typical Data Content
{TYPICAL_DATA}

### Common Use Cases
{USE_CASES}

### Python Libraries for Reading
{PYTHON_LIBRARIES}

---

## Data Structure Analysis

### Overview
{DATA_STRUCTURE_OVERVIEW}

### Dimensions
{DIMENSIONS}

### Data Types
{DATA_TYPES}

---

## Quality Assessment

### Completeness
- **Missing Values:** {MISSING_VALUES}
- **Data Coverage:** {COVERAGE}

### Validity
- **Range Check:** {RANGE_CHECK}
- **Format Compliance:** {FORMAT_COMPLIANCE}
- **Consistency:** {CONSISTENCY}

### Integrity
- **Checksum/Validation:** {VALIDATION}
- **File Corruption Check:** {CORRUPTION_CHECK}

---

## Statistical Summary

### Numerical Variables
{NUMERICAL_STATS}

### Categorical Variables
{CATEGORICAL_STATS}

### Distributions
{DISTRIBUTIONS}

---

## Data Characteristics

### Temporal Properties (if applicable)
- **Time Range:** {TIME_RANGE}
- **Sampling Rate:** {SAMPLING_RATE}
- **Missing Time Points:** {MISSING_TIMEPOINTS}

### Spatial Properties (if applicable)
- **Dimensions:** {SPATIAL_DIMENSIONS}
- **Resolution:** {SPATIAL_RESOLUTION}
- **Coordinate System:** {COORDINATE_SYSTEM}

### Experimental Metadata (if applicable)
- **Instrument:** {INSTRUMENT}
- **Method:** {METHOD}
- **Sample Info:** {SAMPLE_INFO}

---

## Key Findings

1. **Data Volume:** {DATA_VOLUME_FINDING}
2. **Data Quality:** {DATA_QUALITY_FINDING}
3. **Notable Patterns:** {PATTERNS_FINDING}
4. **Potential Issues:** {ISSUES_FINDING}

---

## Visualizations

### Distribution Plots
{DISTRIBUTION_PLOTS}

### Correlation Analysis
{CORRELATION_PLOTS}

### Time Series (if applicable)
{TIMESERIES_PLOTS}

---

## Recommendations for Further Analysis

### Immediate Actions
1. {RECOMMENDATION_1}
2. {RECOMMENDATION_2}
3. {RECOMMENDATION_3}

### Preprocessing Steps
- {PREPROCESSING_1}
- {PREPROCESSING_2}
- {PREPROCESSING_3}

### Analytical Approaches
{ANALYTICAL_APPROACHES}

### Tools and Methods
- **Recommended Software:** {RECOMMENDED_SOFTWARE}
- **Statistical Methods:** {STATISTICAL_METHODS}
- **Visualization Tools:** {VIZ_TOOLS}

---

## Data Processing Workflow

```
{WORKFLOW_DIAGRAM}
```

---

## Potential Challenges

1. **Challenge:** {CHALLENGE_1}
   - **Mitigation:** {MITIGATION_1}

2. **Challenge:** {CHALLENGE_2}
   - **Mitigation:** {MITIGATION_2}

---

## References and Resources

### Format Specification
- {FORMAT_SPEC_LINK}

### Python Libraries Documentation
- {LIBRARY_DOCS}

### Related Analysis Examples
- {EXAMPLE_LINKS}

---

## Appendix

### Complete File Metadata
```json
{COMPLETE_METADATA}
```

### Analysis Parameters
```json
{ANALYSIS_PARAMETERS}
```

### Software Versions
- Python: {PYTHON_VERSION}
- Key Libraries: {LIBRARY_VERSIONS}

---

*This report was automatically generated by the exploratory-data-analysis skill.*
*For questions or issues, refer to the skill documentation.*
