# NIH Specific Aims Page Template

**CRITICAL**: Exactly 1 page, 0.5-inch margins, 11-point font minimum

---

## Opening Paragraph: The Hook (3-5 sentences)

[Establish the importance of your research area with compelling statistics or biological significance]

**Template:**
[Disease/Problem] affects [number] people annually and [consequence - mortality, morbidity, cost]. Despite [current treatments/knowledge], [major limitation or gap]. [Why this limitation matters for patients/science]. [Opportunity or need for new approaches].

**Example:**
Type 2 diabetes (T2D) affects 37 million Americans and costs $327 billion annually in healthcare expenditures. Despite available therapies, fewer than 50% of patients achieve glycemic control, and complications including cardiovascular disease, neuropathy, and kidney failure remain common. Existing treatments primarily target insulin resistance and β-cell function, yet fail to address the underlying molecular heterogeneity driving variable therapeutic responses. Identifying molecular subtypes of T2D and their corresponding treatment vulnerabilities represents a critical unmet need for precision medicine approaches.

---

## Second Paragraph: Gap and Rationale (4-6 sentences)

[Define what's known, what's unknown, and why the gap matters]

**Template:**
Prior studies have established [current knowledge - 1-2 sentences]. However, [what remains unknown - the gap]. [Why current approaches are insufficient]. [Critical barrier to progress]. Understanding [the gap] is essential because [impact of filling the gap].

**Example:**
Prior studies have identified numerous genetic and environmental risk factors for T2D, and recent work has revealed metabolic heterogeneity among patients. However, molecular classification schemes have relied primarily on clinical phenotypes (age at onset, BMI, insulin levels) rather than underlying pathophysiology, limiting their therapeutic utility. Current approaches cannot predict which patients will respond to specific therapies, leading to inefficient trial-and-error treatment selection. Understanding the molecular drivers of T2D heterogeneity and their relationships to drug responses is essential for developing predictive biomarkers and targeted treatment strategies.

---

## Third Paragraph: Goal, Objective, Hypothesis, Rationale (5-7 sentences)

**Long-term goal**: [Overarching research program direction]

**Objective**: The objective of this application is to [specific goal of THIS grant - what you will accomplish].

**Central hypothesis**: [Testable prediction that unifies your aims]. 

This hypothesis is based on [rationale]: our preliminary data showing [key finding 1], [key finding 2], and [key finding 3] (Figures 1-2, Table 1). [Why this evidence supports the hypothesis].

**Example:**
Our long-term goal is to develop precision medicine approaches for type 2 diabetes based on molecular disease subtypes. The objective of this application is to define the molecular basis of T2D heterogeneity and identify subtype-specific therapeutic vulnerabilities. Our central hypothesis is that T2D comprises distinct molecular subtypes driven by different combinations of β-cell dysfunction, insulin resistance, and inflammation, and that these subtypes respond differentially to existing therapies. This hypothesis is based on our preliminary multi-omics profiling of 500 T2D patients revealing five distinct clusters with different genetic architectures, metabolic signatures, and clinical trajectories (Fig. 1). Retrospective analysis showed these subtypes had dramatically different responses to metformin and GLP-1 agonists (Fig. 2), and functional studies in islets confirmed subtype-specific mechanisms (Fig. 3). These findings suggest a molecular classification could guide treatment selection.

---

## Specific Aim 1: [Action Verb - What You Will Do]

[Brief rationale: why this aim is important, background context - 1-2 sentences]

**Working hypothesis**: [Testable prediction for this aim]

**Approach**: We will (1) [first set of experiments/methods], (2) [second set], and (3) [third set]. [Key model systems, sample sizes, or technical approaches]. 

**Expected outcomes**: We expect to [specific predictions], which will [how this advances knowledge or enables subsequent aims].

**Example:**

## Specific Aim 1: Define molecular subtypes of T2D through integrated multi-omics analysis

Current clinical classification of T2D lacks molecular granularity. Our preliminary clustering analysis identified 5 subtypes, but requires validation and mechanistic characterization.

**Working hypothesis**: T2D comprises at least five molecular subtypes with distinct genomic, transcriptomic, proteomic, and metabolomic signatures.

**Approach**: We will (1) perform multi-omics profiling (genome, transcriptome, proteome, metabolome) on 2,000 T2D patients from three independent cohorts, (2) apply unsupervised clustering and machine learning to identify robust subtypes, and (3) validate subtypes in 1,000 independent patients. We will develop a streamlined classification algorithm using the minimal set of biomarkers sufficient for subtype assignment.

**Expected outcomes**: We will define 5-7 molecular T2D subtypes, characterize their multi-omics signatures, and develop a clinically deployable classifier. This foundation will enable investigation of subtype-specific mechanisms (Aim 2) and treatment responses (Aim 3).

---

## Specific Aim 2: [Action Verb - What You Will Do]

[Brief rationale and background - 1-2 sentences]

**Working hypothesis**: [Testable prediction]

**Approach**: [Detailed methods - 3-5 sentences outlining key experiments, models, techniques, and sample sizes]

**Expected outcomes**: [Specific predictions and impact]

**Example:**

## Specific Aim 2: Elucidate pathophysiological mechanisms underlying each molecular subtype

Molecular subtypes likely reflect distinct disease mechanisms, but causal pathways remain unknown.

**Working hypothesis**: Each T2D subtype is driven by a distinct combination of β-cell dysfunction, hepatic insulin resistance, adipose tissue inflammation, and incretin deficiency.

**Approach**: Using patient-derived iPSCs, primary adipocytes, and liver organoids from each subtype, we will (1) assess β-cell function (insulin secretion dynamics, ER stress, apoptosis), (2) measure insulin signaling in hepatocytes and adipocytes using phosphoproteomics and glucose uptake assays, (3) profile immune cell infiltration and inflammatory cytokines in adipose tissue, and (4) measure GLP-1 secretion and receptor expression. We will perform integrative analysis relating cellular phenotypes to clinical outcomes in n=100 patients per subtype.

**Expected outcomes**: We will define the primary pathophysiological defects in each subtype and identify targetable vulnerabilities. This mechanistic understanding will inform selection of appropriate therapies in Aim 3.

---

## Specific Aim 3: [Action Verb - What You Will Do]

[Brief rationale - 1-2 sentences]

**Working hypothesis**: [Testable prediction]

**Approach**: [Methods - 3-5 sentences]

**Expected outcomes**: [Predictions and impact]

**Example:**

## Specific Aim 3: Determine subtype-specific responses to existing T2D therapies

Current treatment algorithms do not account for molecular heterogeneity, leading to suboptimal outcomes.

**Working hypothesis**: T2D subtypes exhibit differential responses to metformin, GLP-1 agonists, SGLT2 inhibitors, and insulin, based on their underlying pathophysiology.

**Approach**: We will (1) conduct retrospective analysis of treatment responses in 5,000 patients with known subtypes from electronic health records, (2) validate findings in a prospective observational cohort (n=500, 18-month follow-up), and (3) test predicted drug sensitivities in patient-derived cell models and humanized mice (n=15 per subtype per drug). Primary outcomes are HbA1c reduction, with secondary outcomes including weight, hypoglycemia, and cardiovascular risk markers.

**Expected outcomes**: We will identify optimal first-line therapies for each subtype and develop a treatment algorithm. Retrospective data suggest subtype-guided therapy could improve HbA1c control by 0.8-1.2% compared to standard care. Results will inform an investigator-initiated clinical trial (resources available through our Clinical Research Center).

---

## Closing Paragraph: Impact and Significance (3-5 sentences)

[Summarize expected outcomes, how it advances the field, and positive impact]

**Template:**
The proposed research is significant because [why it matters]. Results will [specific advances - knowledge, tools, treatments]. We expect findings will [broader impact on field or health]. This work will [transformative potential or next steps].

**Example:**
The proposed research is significant because it will establish a molecular taxonomy of type 2 diabetes and identify subtype-specific treatment strategies, addressing a critical barrier to precision medicine in this prevalent disease. Results will provide mechanistic insights into T2D heterogeneity, immediately applicable biomarkers for patient stratification, and evidence-based treatment algorithms. We expect findings will enable personalized therapeutic approaches that substantially improve glycemic control and reduce complications for the 37 million Americans with T2D. This work will establish new paradigms for precision medicine in complex metabolic diseases and provide the foundation for a prospective subtype-guided treatment trial that could transform clinical practice.

---

## Formatting Checklist

- [ ] Exactly 1 page (not 1.1, not 0.9)
- [ ] 0.5-inch margins (all sides)
- [ ] 11-point Arial/Helvetica or equivalent
- [ ] Readable line spacing
- [ ] Aim statements are bold or underlined
- [ ] Gene names italicized (*TP53*)
- [ ] Figures (if included) are legible
- [ ] All abbreviations defined at first use

## Content Checklist

- [ ] Opens with compelling importance statement
- [ ] Includes epidemiological data or significance metrics
- [ ] Clearly defines the gap in knowledge
- [ ] States long-term goal
- [ ] States specific objective of THIS application
- [ ] Presents testable central hypothesis (or research questions)
- [ ] Mentions preliminary data supporting feasibility
- [ ] Includes 2-4 specific aims
- [ ] Each aim has: rationale, hypothesis, approach, expected outcomes
- [ ] Aims are testable and achievable
- [ ] Aims are independent but synergistic
- [ ] Expected outcomes are specific
- [ ] Closes with impact statement
- [ ] Passes the "skim test" (aim statements tell the story)

## Tips for Success

1. **Write 10+ drafts** - This page is too important to rush
2. **Get extensive feedback** - From colleagues, mentors, people outside your field
3. **Read it aloud** - Check for flow and clarity
4. **Study funded examples** - Look at successful aims pages in your field
5. **Test on non-experts** - Can someone in a different field understand the importance?
6. **Check every word** - Every sentence must earn its place on this precious page

