# NIH (National Institutes of Health) Grant Writing Guidelines

## Agency Overview

**Mission**: To seek fundamental knowledge about the nature and behavior of living systems and to apply that knowledge to enhance health, lengthen life, and reduce illness and disability

**Annual Budget**: ~$47 billion (largest biomedical research funder globally)

**Website**: https://www.nih.gov

**Key Characteristics**:
- 27 Institutes and Centers (ICs), each with specific research focus
- Supports biomedical and behavioral research
- Strong emphasis on rigor, reproducibility, and translation
- Clinical trials and human subjects research
- Patient-oriented and population health research

## NIH Institutes and Centers (Major ICs)

- **NCI** - National Cancer Institute
- **NHLBI** - National Heart, Lung, and Blood Institute
- **NIDDK** - National Institute of Diabetes and Digestive and Kidney Diseases
- **NIAID** - National Institute of Allergy and Infectious Diseases
- **NIGMS** - National Institute of General Medical Sciences
- **NINDS** - National Institute of Neurological Disorders and Stroke
- **NIMH** - National Institute of Mental Health
- **NICHD** - National Institute of Child Health and Human Development
- **NEI** - National Eye Institute
- **NIEHS** - National Institute of Environmental Health Sciences
- **NIA** - National Institute on Aging
- **NIAAA** - National Institute on Alcohol Abuse and Alcoholism
- **NIDA** - National Institute on Drug Abuse
- **NHGRI** - National Human Genome Research Institute
- **NCCIH** - National Center for Complementary and Integrative Health

**Plus**: NIBIB, NIDCD, NIDCR, NINR, FIC, NLM, and others

## Core Review Criteria

NIH proposals are evaluated using **scored criteria** (1-9 scale, 1 = exceptional, 9 = poor) and **additional review considerations** (not scored but discussed).

### Scored Criteria (Overall Impact Score)

#### 1. Significance

**Definition**: Does the project address an important problem or critical barrier to progress?

**Key Questions**:
- Will the project improve scientific knowledge, technical capability, or clinical practice?
- How will successful completion move the field forward?
- Does it address important scientific question or health need?
- Is there a clear rationale based on literature or preliminary data?

**What Reviewers Look For**:
- Clear statement of the problem and its importance
- Evidence that solving this problem will advance the field
- Strong conceptual framework
- Potential for broad impact (not just narrow niche)
- Alignment with NIH and Institute mission

**Writing Strategy**:
- Open with compelling statement of health burden or knowledge gap
- Cite epidemiological data, morbidity/mortality statistics
- Show that current approaches are insufficient
- Demonstrate how your work will make a difference
- Connect to clinical or translational outcomes when possible

#### 2. Investigator(s)

**Definition**: Are the investigators appropriately trained and well-suited to carry out this work?

**Key Questions**:
- Do they have appropriate expertise and track record?
- Is the proposed leadership approach appropriate for the project?
- Do they have prior experience in the research area?
- For Early Stage Investigators (ESI), is appropriate mentoring/support available?

**What Reviewers Look For**:
- Publications in the relevant area
- Preliminary data demonstrating capability
- Productivity and consistency
- Appropriate team composition
- For new investigators: strong mentorship and institutional support
- Career trajectory aligned with proposed work

**Writing Strategy**:
- Highlight most relevant publications (not total number)
- Show progression and focus in research program
- Demonstrate that you have necessary skills
- If new area, show collaborations or training
- For multi-PI, clearly define complementary roles
- Show stability and institutional commitment

#### 3. Innovation

**Definition**: Does the application challenge existing paradigms or develop new methodologies, technologies, or interventions?

**Key Questions**:
- Does the project employ novel concepts, approaches, or methodologies?
- Are the aims original and innovative?
- Does it challenge existing paradigms or address an innovative hypothesis?
- Does it refine, improve, or develop new instrumentation or methods?

**What Reviewers Look For**:
- Departure from standard approaches
- Novel application of methods to new problems
- Development of new technologies or tools
- Paradigm-shifting concepts
- Creative experimental design
- NOT just new to you, but new to the field

**Writing Strategy**:
- Explicitly state what is innovative
- Contrast with existing approaches and limitations
- Explain why innovation is necessary
- Provide preliminary data supporting feasibility
- Balance novelty with achievability
- Avoid over-claiming (incremental work ≠ transformative)

#### 4. Approach

**Definition**: Are the overall strategy, methodology, and analyses well-reasoned, appropriate, and rigorous?

**Key Questions**:
- Are the research design and methods appropriate for the proposed aims?
- Are potential problems, alternative strategies, and benchmarks for success presented?
- Is the timeline reasonable and is there adequate statistical power?
- Are the data management and analysis plans appropriate?
- Is rigor and transparency evident in the experimental design?

**What Reviewers Look For**:
- Detailed, specific methodology
- Appropriate experimental design (controls, replicates, randomization, blinding)
- Statistical justification (power calculations, sample size)
- Potential pitfalls identified with alternatives
- Feasibility demonstrated with preliminary data
- Logical flow from aims through methods to expected outcomes
- Rigor and reproducibility measures

**Writing Strategy**:
- Provide sufficient detail to judge feasibility
- Use subheadings for organization
- Include flowcharts or diagrams
- Address authentication of key biological resources
- Discuss biological variables (sex, age, etc.)
- Identify potential problems proactively
- Provide contingency plans
- Show that timeline is realistic
- Include preliminary data throughout

#### 5. Environment

**Definition**: Will the scientific environment contribute to the probability of success?

**Key Questions**:
- Do the proposed studies benefit from unique features of the scientific environment?
- Are the institutional support, equipment, and resources available?
- Are collaborative arrangements and contributions from colleagues appropriate?
- Is the environment conducive to the proposed research?

**What Reviewers Look For**:
- Access to necessary facilities (core facilities, equipment, patient populations)
- Institutional commitment and support
- Collaborative networks
- Track record of institutional productivity
- Training environment (for training grants)
- Sufficient space and resources

**Writing Strategy**:
- Highlight unique institutional resources
- Describe relevant core facilities with capabilities
- Show institutional investment in your research area
- Include letters documenting access to resources
- Describe collaborative environment
- For clinical research, show access to patient populations

### Additional Review Considerations (Not Scored)

These factors are discussed but do not contribute to the numerical score:

#### Protection of Human Subjects
- IRB approval status and process
- Risks to subjects justified by potential benefits
- Protections against risks adequate
- Informed consent process appropriate
- Data and safety monitoring plan (for trials)
- Inclusion of women, minorities, and children (see below)

#### Inclusion of Women, Minorities, and Children
- Adequate plan for inclusion of all groups
- Justification if any group excluded
- Statistical power adequate to detect differences
- Outreach and recruitment plans appropriate

#### Vertebrate Animals
- IACUC approval status
- Proposed procedures appropriate and humane
- Minimization of discomfort, distress, pain
- Euthanasia method appropriate
- Justification of species and numbers

#### Biohazards
- Appropriate safeguards and containment
- Training and expertise adequate

#### Resubmission (A1 applications)
- Are concerns from previous review adequately addressed?
- Has the application been substantially improved?

#### Budget and Period of Support
- Is budget reasonable for proposed work?
- Is timeline appropriate?

#### Resource Sharing Plans
- Data sharing plan adequate
- Model organism sharing plan (if applicable)
- Genomic data sharing plan (if applicable)

## Proposal Structure and Page Limits

### Specific Aims (1 page)

**Most important page of the entire application.** Reviewers often make initial impressions based on this page alone.

**Structure** (see detailed template in `specific_aims_guide.md`):

**Opening Paragraph** (3-5 sentences):
- Long-term goal of your research program
- Health burden or knowledge gap
- Critical need that motivates the work

**Objective and Central Hypothesis** (1 paragraph):
- Objective of THIS grant
- Central hypothesis or research question
- Rationale (brief mention of preliminary data)

**Specific Aims** (2-4 aims):
- Each aim: 1 paragraph (half page max)
- Aim statement (1-2 sentences, starts with action verb)
- Working hypothesis or research question
- Rationale (why this aim, what preliminary data supports it)
- Approach summary (brief methods)
- Expected outcomes and interpretation

**Payoff Paragraph** (closing):
- Expected outcomes of the overall project
- How findings will advance the field
- Positive impact on health (if relevant)
- Next steps or future directions

**Critical Rules**:
- Exactly 1 page (0.5-inch margins, 11-point Arial or similar)
- Must stand alone (reviewers read this first)
- Clear, specific aims that are testable
- Aims should be independent but synergistic
- Avoid jargon (panel members may not be in your subfield)
- Every sentence must earn its place

### Research Strategy (12 pages for R01)

**Section A: Significance** (typically 2-3 pages)

**Purpose**: Convince reviewers the problem is important and worth solving

**Content**:
- State the problem and its importance (health burden, knowledge gap)
- Review current state of knowledge (focused literature review)
- Identify limitations of current approaches
- Explain conceptual advance your work will provide
- Describe potential impact on the field or health outcomes
- Explain alignment with NIH mission and Institute priorities

**Writing Tips**:
- Start broad (importance of the problem) then narrow (specific gap)
- Use epidemiological data (prevalence, mortality, costs)
- Cite key literature systematically
- Identify the specific barrier or gap your work addresses
- End with how your work will advance the field

**Section B: Innovation** (typically 1-2 pages)

**Purpose**: Articulate what is novel and transformative

**Content**:
- Describe innovative elements of the proposed research
- Explain novel concepts, approaches, or methodologies
- Contrast with existing approaches and their limitations
- Explain why innovation is necessary (not just different)
- Demonstrate that innovation is achievable (preliminary data)

**Writing Tips**:
- Be explicit about what is innovative (don't assume it's obvious)
- Distinguish incremental from transformative advances
- Provide evidence that novel approach can work
- Don't confuse "new to me" with "new to the field"
- Avoid over-claiming

**Section C: Approach** (typically 8-10 pages)

**Purpose**: Provide detailed research plan demonstrating feasibility

**Organization** (for each Specific Aim):

**Aim [Number]: [Aim Title]**

**Rationale and Preliminary Data**:
- Why this aim is important
- Preliminary results supporting feasibility
- Key figures and data

**Research Design**:
- Overall experimental design
- Subject/sample populations and numbers
- Randomization, blinding, controls
- Timeline for this aim

**Methods** (organized by sub-aim or experiment):
- Detailed procedures and protocols
- Materials, reagents, equipment
- Data collection procedures
- Biological variables considered

**Data Analysis**:
- Statistical approaches
- Sample size justification and power calculations
- How results will be interpreted

**Expected Outcomes**:
- What you expect to find
- How results will be interpreted
- Alternative outcomes and what they would mean

**Potential Pitfalls and Alternative Approaches**:
- What could go wrong (be proactive)
- Contingency plans
- Alternative strategies if initial approach doesn't work

**Timeline**: 
- Sequence of activities for this aim
- Estimated completion time

**Writing Tips**:
- Use consistent organization across aims
- Include subheadings for clarity
- Integrate preliminary data throughout (not just at beginning)
- Provide figures, flowcharts, and tables
- Address rigor and reproducibility explicitly
- Justify choice of methods and approaches
- Be specific about numbers, timelines, and analysis
- Show that you've thought through the research process

**Rigor and Reproducibility** (addressed throughout Approach):

NIH requires explicit discussion of:
- **Scientific rigor in experimental design**: Controls, replicates, blinding, randomization
- **Authentication of key biological resources**: Cell lines, antibodies, organisms
- **Consideration of biological variables**: Sex, age, strain, etc.
- **Statistical power**: Adequate sample sizes
- **Transparency**: Data management, protocols, reporting

### Bibliography (no page limit)

- Include all references cited
- Use consistent format (PubMed citations preferred)
- Include DOI or PMID when available

### Protection of Human Subjects or Vertebrate Animals (varies)

**Human Subjects Section**:
- Risks to subjects
- Protection against risks
- Potential benefits
- Importance of knowledge to be gained
- Inclusion of women and minorities
- Inclusion of children
- Data and safety monitoring

**Vertebrate Animals Section**:
- Justification of species and numbers
- Minimization of pain and distress
- Euthanasia method

## Key NIH Application Types

### R01 - Research Project Grant

**Description**: Standard NIH grant mechanism for established investigators

**Characteristics**:
- **Budget**: Modular (up to $250K direct costs/year) or detailed budget
- **Duration**: Typically 3-5 years
- **Eligibility**: Any eligible institution
- **Preliminary data**: Usually required (shows feasibility)
- **Page limits**: 12 pages Research Strategy

**Typical Timeline**:
- Prepare: 2-6 months
- Review: ~9 months from submission
- Earliest start: 9-12 months after submission

**Success Rate**: ~20% overall (varies by Institute)

**When to Apply**: When you have preliminary data and clear research direction

### R21 - Exploratory/Developmental Research Grant

**Description**: Encourages new exploratory and developmental research

**Characteristics**:
- **Budget**: Up to $275K total (direct costs) over 2 years
- **Duration**: Maximum 2 years
- **Preliminary data**: Not required (though can strengthen)
- **Page limits**: 6 pages Research Strategy
- **No-cost extensions**: Not allowed

**Purpose**:
- Pilot or feasibility studies
- Testing new methods or technologies
- Secondary analysis of existing data
- Exploratory clinical studies

**When to Apply**: When you need pilot data before R01, or for high-risk ideas

### R03 - Small Grant Program

**Description**: Small-scale research projects

**Characteristics**:
- **Budget**: Up to $50K/year direct costs (up to $100K total)
- **Duration**: Maximum 2 years
- **Page limits**: 6 pages Research Strategy

**Purpose**: Limited scope projects, pilot studies, secondary data analysis

### K Awards - Career Development Awards

**Purpose**: Support career development of researchers

**Major K Award Types**:

**K99/R00 - Pathway to Independence**:
- Two phases: K99 (mentored, 1-2 years) → R00 (independent, up to 3 years)
- For postdocs transitioning to independence
- Provides protected time and research support
- Competitive (~15% funded)

**K08 - Mentored Clinical Scientist Award**:
- For clinicians (MD, DO, DDS, etc.)
- 3-5 years protected time for research training
- Requires mentoring team
- Up to $100K direct costs/year

**K23 - Mentored Patient-Oriented Research Career Development Award**:
- For patient-oriented research
- Similar structure to K08

**All K Awards Require**:
- Career development plan
- Research plan (6-12 pages)
- Mentoring plan and letters from mentors
- Training plan
- Institutional commitment (75% protected time typically)

### Other Common Mechanisms

**R15 (AREA)**: For primarily undergraduate institutions

**P01**: Multi-project program project grants (large collaborative)

**U01**: Cooperative agreement (NIH involvement in conduct)

**R34**: Clinical trial planning grant

**DP1/DP2**: NIH Director's Pioneer/New Innovator Awards (special)

## Budget Preparation

### Modular Budgets (R01s up to $250K direct/year)

**Characteristics**:
- Requested in $25K increments (modules)
- Maximum 10 modules ($250K) per year
- Detailed budget not required
- Budget justification: Narrative (Personnel, Consortium, Other)
- Years 2-5: Brief justification if >$125K or increase >25%

**Personnel Justification**:
- List all personnel with roles, effort (% calendar months)
- Typical: PI (2-3 months = 16-25%), postdoc (12 months), grad student, tech
- Justify effort for each person
- Note: Salary cap applies (~$221,900 for 2024)

**Consortium/Contractual Costs**:
- F&A typically limited to 8% of total costs for subcontracts

**Other Costs**:
- Describe significant equipment, animals, patient costs, etc.

### Detailed Budgets (>$250K direct/year)

**Required Sections**:
- Personnel (with individual salary details)
- Equipment (≥$5,000 per item)
- Travel (domestic and foreign)
- Participant/Trainee Support Costs
- Other Direct Costs (materials, supplies, publications, consultants)
- Consortium/Contractual Costs (with detailed sub-budgets)
- Total Direct Costs
- Indirect Costs (F&A)

**Budget Justification**:
- Detailed narrative for each category
- Justify need for each item/person
- Explain calculations

### NIH Salary Cap

**Annual Update**: NIH sets maximum salary for grants
- 2024 Level: ~$221,900 (Executive Level II)
- Applies to all personnel
- Fringe benefits calculated on capped salary

### Allowable Costs

**Generally Allowed**:
- Salaries and wages
- Fringe benefits
- Equipment
- Supplies (consumables <$5,000)
- Travel (domestic and international)
- Consultant services
- Consortium/subaward costs
- Animal purchase and care
- Patient care costs (clinical trials)
- Alterations and renovations (with prior approval)
- Publication costs

**Generally Not Allowed** (without special justification):
- Office equipment (computers, printers, furniture)
- Administrative costs
- Tuition (except for K awards and training grants)

## Application Submission

### Deadlines

**Standard Dates** (most programs):
- February 5
- June 5
- October 5

**AIDS-Related Research**:
- January 7
- May 7
- September 7

**K Awards and Fellowship**: Different dates, typically 3 times/year

**Submission Time**: 5:00 PM local time of applicant organization

### Submission Systems

**eRA Commons**: Required for NIH submission
- Create account through institution
- Assign roles (PI, authorized organizational representative)

**ASSIST (Application Submission System & Interface for Submission Tracking)**:
- NIH's electronic submission system
- Create application, upload documents, submit

**Grants.gov**: Alternative submission route (not recommended)

### Just-in-Time Information

**After initial review** (if in fundable range), NIH requests:
- Other Support (updated)
- IRB/IACUC approval (or documentation that approval will be obtained)
- Vertebrate Animals/Human Subjects training certifications

**Timing**: Usually 6-9 months after submission

## Review Process

### Timeline

**Total Time**: ~9 months from submission to funding decision

**Stages**:
1. **Submission**: Deadline (Month 0)
2. **Referral**: Assignment to IC and study section (Month 1)
3. **Review**: Study section meeting (Months 3-4)
4. **Council**: Advisory council review (Months 6-7)
5. **Funding Decision**: Program officer and IC (Months 7-9)

### Study Sections

**Types**:
- **Standing Study Sections**: Permanent panels meeting 3x/year
- **Special Emphasis Panels (SEPs)**: Ad hoc panels for specific RFAs or topics
- **Scientific Review Groups (SRGs)**: Chartered study sections

**Process**:
- 3 assigned reviewers per application (prepare written critiques)
- ~15-25 applications discussed per study section
- ~50-100 applications assigned to each study section

**Participants**:
- Scientific Review Officer (SRO): NIH staff, manages process
- Reviewers: External scientists with expertise
- Grants management specialist
- Program officer (sometimes attends, doesn't vote)

### Scoring

**Preliminary Scoring** (before meeting):
- All panel members score 1-9 (1 = exceptional, 9 = poor)
- Applications in lower half typically "triaged" (not discussed)
- Top ~50% discussed at meeting

**Discussion** (at study section meeting):
- Assigned reviewers present their assessments
- Panel discusses strengths and weaknesses
- Open discussion among all panel members
- Questions about rigor, innovation, feasibility

**Final Scoring** (after discussion):
- All panel members score 1-9
- Scores averaged and multiplied by 10
- **Final Impact Score**: 10-90 (lower is better)
  - 10-20: Exceptional
  - 21-30: Outstanding
  - 31-40: Excellent (often fundable)
  - 41-50: Very good (may be fundable)
  - 51+: Less competitive

**Individual Criterion Scores**: Also scored 1-9
- Significance
- Investigator(s)
- Innovation
- Approach
- Environment

### Percentile Ranking

**After all study sections meet**, applications are percentile-ranked within IC
- Based on Impact Score relative to other applications reviewed by same IC
- Percentile typically more important than Impact Score for funding decisions
- Lower percentile = better (1st percentile = top 1%)

**Example**: Impact Score of 35 might be:
- 15th percentile at NIGMS (likely funded)
- 40th percentile at NCI (likely not funded)
- Depends on competitiveness of IC and available funding

### Summary Statement

**Received**: ~30 days after study section meeting

**Contents**:
- Overall Impact/Priority Score and Percentile
- Individual criterion scores
- Resume and Summary of Discussion
- Detailed critiques from 3 assigned reviewers
- Additional comments from other panel members
- Human Subjects, Animals, Biohazards reviews

**Interpreting**:
- Focus on consistent themes across reviewers
- Identify major vs. minor criticisms
- Note what reviewers found strong
- Use for resubmission planning

## Resubmission (A1 Applications)

### NIH Resubmission Policy

**One Resubmission Allowed**: Can resubmit once (A1) after initial review (A0)
- After A1 review, cannot resubmit again
- Must submit new application if A1 not funded

**No Limits on New Applications**: Can submit completely new application anytime

### Introduction to Resubmission (1 page)

**Required Section**: Separate 1-page introduction responding to previous review

**Structure**:
- **Header**: "INTRODUCTION TO RESUBMISSION"
- **Summary of Criticisms**: Brief overview of major criticisms
- **Response to Criticisms**: Point-by-point response with page references
- **Use bullet points** for clarity

**Example Format**:
```
INTRODUCTION TO RESUBMISSION

The previous review raised the following concerns:
1. Inadequate preliminary data demonstrating feasibility of Aim 2
2. Statistical power insufficient for Aim 3
3. Lack of detail about quality control procedures

We have addressed these concerns as follows:

1. Preliminary data for Aim 2 (Response, p. 8-9; Research Strategy, p. 18-20)
   • Generated pilot data showing [specific result]
   • Optimized protocol achieving [specific outcome]
   • New Figure 3 demonstrates feasibility

2. Statistical power for Aim 3 (Research Strategy, p. 24-25)
   • Increased sample size from n=15 to n=25 per group
   • Updated power calculations show >90% power
   • Budget adjusted accordingly

3. Quality control procedures (Research Strategy, p. 12, 19, 26)
   • Added detailed QC protocols for each method
   • Implemented validation criteria and acceptance thresholds
   • Described authentication of key reagents
```

**Tips**:
- Be respectful and professional (avoid defensiveness)
- Address every major criticism explicitly
- Indicate where changes are in revised application
- Show substantial revision, not minor tweaks
- Acknowledge valid criticisms and explain how addressed
- If disagree with criticism, explain politely with evidence

### Resubmission Strategy

**Decision Tree**:

**Impact Score ≤40 (Percentile ≤20)**: Strong application, likely competitive
- Address specific criticisms
- Strengthen weak areas
- Add preliminary data if criticized
- Consider minor scope adjustments

**Impact Score 41-50 (Percentile 21-40)**: Moderate application, needs improvement
- Substantial revision needed
- May need new preliminary data
- Consider revising aims if criticized
- Strengthen innovation or significance
- May want to wait for new data before resubmitting

**Impact Score ≥51 (Percentile ≥41)**: Weak application, major revision needed
- Consider whether resubmission is worthwhile
- May be better to develop new application
- If resubmitting: major restructuring likely needed
- Gather substantial new preliminary data
- Consider changing scope or aims

**Common Resubmission Improvements**:
1. **Add preliminary data**: Especially for Aim 2 or 3 if criticized
2. **Clarify methods**: Provide more detail, address technical concerns
3. **Increase rigor**: Better controls, larger n, statistical justification
4. **Revise specific aims**: If fundamentally flawed
5. **Add collaborators**: If expertise questioned
6. **Strengthen significance**: Better literature review, clearer impact
7. **Refocus innovation**: Clarify what's novel and why it matters

**Timing**:
- Can resubmit at any of the next 3 deadlines (36 months after initial submission)
- Use time wisely to generate new data
- Don't rush resubmission with minor changes

## NIH Funding Trends and Priorities (2024-2025)

### Current Priorities

- **Health Disparities and Health Equity**: Addressing disparities in disease burden
- **Alzheimer's Disease and Dementia**: Prevention, treatment, care
- **Substance Use and Mental Health**: Opioid crisis, addiction, mental health
- **Infectious Diseases**: Pandemic preparedness, antimicrobial resistance, vaccines
- **Cancer**: Cancer Moonshot initiatives
- **BRAIN Initiative**: Understanding the brain
- **All of Us Research Program**: Precision medicine
- **Climate Change and Health**: Environmental impacts on health
- **Artificial Intelligence**: AI for biomedical research and healthcare

### Success Rates by Career Stage

**Overall**: ~20% (varies by IC and mechanism)

**Established Investigators**: ~23%

**Early Stage Investigators (ESI)**: ~27% (higher due to ESI policy)
- ESI: Within 10 years of final degree, no prior R01-equivalent

**New Investigators**: ~24%
- New: No prior R01-equivalent (regardless of time since degree)

**Multiple PI**: ~18% (slightly lower than single PI)

### Paylines

**Varies by IC**: Each Institute sets own funding priorities

**Example Paylines (FY2023)**:
- NIGMS: ~23rd percentile
- NCI: ~12th percentile (highly competitive)
- NHLBI: ~11th percentile
- NIAID: ~15th percentile
- NIMH: ~12th percentile

**ESI Boost**: Most ICs fund ESIs at higher percentile than established investigators

**Check IC Websites**: Paylines and funding policies updated annually

## Tips for Competitive NIH Applications

### Do's

✅ **Start with Specific Aims page** - Most important page, revise extensively
✅ **Include substantial preliminary data** - Demonstrate feasibility (esp. for R01)
✅ **Be explicit about innovation** - Don't assume reviewers will recognize it
✅ **Address rigor and reproducibility** - Controls, power, authentication, variables
✅ **Provide detailed methods** - Enough detail to assess feasibility
✅ **Identify pitfalls proactively** - Show you've thought through challenges
✅ **Use figures and diagrams** - Clarify complex ideas, show preliminary data
✅ **Connect to health** - NIH mission is health-related
✅ **Write clearly** - Panel members may not be in your exact subfield
✅ **Get external review** - Mock review from colleagues and mentors

### Don'ts

❌ **Don't exceed page limits** - Automatic rejection
❌ **Don't be vague about methods** - "Standard protocols" is insufficient
❌ **Don't ignore sample size** - Power calculations required
❌ **Don't overpromise** - Be realistic about what's achievable
❌ **Don't forget human subjects/animals sections** - Common mistake
❌ **Don't submit without preliminary data** - For R01, this rarely succeeds
❌ **Don't assume reviewers know your work** - Provide context
❌ **Don't ignore sex as biological variable** - NIH policy requires consideration
❌ **Don't submit at deadline** - Technical issues happen frequently
❌ **Don't resubmit without substantial changes** - Minor revisions rarely succeed

## NIH Resources

- **NIH Homepage**: https://www.nih.gov
- **NIH RePORTER (funded grants)**: https://reporter.nih.gov
- **Grants & Funding**: https://grants.nih.gov
- **eRA Commons**: https://commons.era.nih.gov
- **ASSIST**: https://public.era.nih.gov/assist
- **Application Forms and Instructions**: https://grants.nih.gov/grants/how-to-apply-application-guide.html
- **NIH Data Sharing Policy**: https://sharing.nih.gov
- **Rigor and Reproducibility**: https://grants.nih.gov/reproducibility/index.htm

---

**Key Takeaway**: NIH applications succeed through clear articulation of an important health-related problem, preliminary data demonstrating feasibility, detailed rigorous approach, and innovative methods. The Specific Aims page is the most critical component—invest time in crafting a compelling narrative that immediately conveys significance and feasibility.

