# Citation Styles Guide

## Overview

Citation styles provide standardized formats for acknowledging sources in scientific writing. Different disciplines prefer different styles, and journals typically specify which style to use. The five most common citation styles in science are AMA, Vancouver, APA, Chicago, and IEEE.

## Choosing the Right Style

| Style | Primary Disciplines | In-Text Format |
|-------|-------------------|----------------|
| AMA | Medicine, health sciences | Superscript numbers¹ |
| Vancouver | Biomedical sciences | Numbers in brackets [1] |
| APA | Psychology, social sciences, education | Author-date (Smith, 2023) |
| Chicago | Humanities, history, some sciences | Notes-bibliography or author-date |
| IEEE | Engineering, computer science | Numbers in brackets [1] |
| ACS | Chemistry | Superscript numbers¹ or (1) |
| NLM | Life sciences, PubMed | Numbers in brackets [1] |

**Default recommendation**: When in doubt, check the journal's author guidelines. Most biomedical journals use Vancouver or AMA style.

## AMA Style (American Medical Association)

### Overview
- Used primarily in medical research
- Based on the *AMA Manual of Style* (11th edition, 2020)
- Numbered citations appearing as superscripts
- References listed numerically in order of appearance

### In-Text Citations

**Basic format**: Superscript numerals outside periods and commas, inside semicolons and colons.

**Examples:**
```
Several studies have demonstrated this effect.¹

The results were inconclusive,² although Smith et al³ reported otherwise.

These findings³⁻⁵ suggest a correlation.

One meta-analysis⁶ found significant heterogeneity; however, the pooled effect was significant.⁷
```

**Multiple citations**: Use commas or hyphens for ranges
```
Multiple studies¹,³,⁵⁻⁷ have confirmed this.
```

**Same source cited multiple times**: Use the same number throughout

### Reference List Format

**Journal Articles:**
```
1. Author AA, Author BB, Author CC. Title of article. Journal Name. Year;Volume(Issue):Page range. doi:xx.xxxx
```

**Example:**
```
1. Smith JD, Johnson AB, Williams CD. Effectiveness of cognitive behavioral therapy for anxiety disorders. JAMA Psychiatry. 2023;80(5):456-464. doi:10.1001/jamapsychiatry.2023.0123
```

**Books:**
```
2. Author AA. Book Title. Edition. Publisher; Year.
```

**Book Chapters:**
```
3. Chapter Author AA. Chapter title. In: Editor AA, Editor BB, eds. Book Title. Edition. Publisher; Year:Page range.
```

**Online Resources:**
```
4. Organization Name. Page title. Website name. Published date. Updated date. Accessed date. URL
```

### Special Cases

**More than 6 authors**: List first 3, then "et al"
```
Smith JD, Jones AB, Williams CD, et al.
```

**No author**: Begin with title

**Advance online publication**:
```
Published online Month Day, Year. doi:xx.xxxx
```

## Vancouver Style

### Overview
- Developed by the International Committee of Medical Journal Editors (ICMJE)
- Described in *Recommendations for the Conduct, Reporting, Editing, and Publication of Scholarly Work in Medical Journals*
- Also called "author-number style"
- Numbered citations in square brackets
- References listed numerically

### In-Text Citations

**Basic format**: Numbers in square brackets after the relevant text, before periods and commas.

**Examples:**
```
Several studies have shown this effect [1].

The results were inconclusive [2], although Smith et al [3] reported otherwise.

These findings [3-5] suggest a correlation.

Multiple studies [1,3,5-7] have confirmed this.
```

### Reference List Format

**Journal Articles:**
```
1. Author AA, Author BB, Author CC. Title of article. Journal Name. Year;Volume(Issue):Page range.
```

**Example:**
```
1. Smith JD, Johnson AB, Williams CD. Effectiveness of cognitive behavioral therapy for anxiety disorders. JAMA Psychiatry. 2023;80(5):456-464.
```

**Books:**
```
2. Author AA, Author BB. Book title. Edition. Place of publication: Publisher; Year.
```

**Book Chapters:**
```
3. Chapter Author AA, Chapter Author BB. Chapter title. In: Editor AA, Editor BB, editors. Book title. Edition. Place: Publisher; Year. p. Page range.
```

**Electronic Sources:**
```
4. Author AA. Title of page [Internet]. Place: Publisher; Date of publication [cited Date of citation]. Available from: URL
```

### Special Cases

**More than 6 authors**: List first 6, then "et al."

**Journal title abbreviations**: Use PubMed/Index Medicus abbreviations
- *The Journal of the American Medical Association* → *JAMA*
- *Nature Medicine* → *Nat Med*

**No volume or issue**: Use year and page numbers only

**Article in press**: Use "[Epub ahead of print]" notation

## APA Style (American Psychological Association)

### Overview
- Widely used in psychology, education, and social sciences
- Based on the *Publication Manual of the APA* (7th edition, 2020)
- Author-date format for in-text citations
- References listed alphabetically by author surname

### In-Text Citations

**Basic format**: (Author, Year)

**Examples:**
```
One study found significant effects (Smith, 2023).

Smith (2023) found significant effects.

Multiple studies (Jones, 2020; Smith, 2023; Williams, 2024) support this conclusion.
```

**Two authors**: Use "&" in parentheses, "and" in narrative
```
(Smith & Jones, 2023)
Smith and Jones (2023) demonstrated...
```

**Three or more authors**: Use "et al." after first author
```
(Smith et al., 2023)
Smith et al. (2023) reported...
```

**Multiple works by same author(s) in same year**: Add letters
```
(Smith, 2023a, 2023b)
```

**Direct quotations**: Include page numbers
```
(Smith, 2023, p. 45)
"Quote text" (Smith, 2023, p. 45).
Smith (2023) stated, "Quote text" (p. 45).
```

### Reference List Format

**Journal Articles:**
```
Author, A. A., Author, B. B., & Author, C. C. (Year). Title of article. Journal Name, Volume(Issue), page range. https://doi.org/xx.xxxx
```

**Example:**
```
Smith, J. D., Johnson, A. B., & Williams, C. D. (2023). Effectiveness of cognitive behavioral therapy for anxiety disorders. JAMA Psychiatry, 80(5), 456-464. https://doi.org/10.1001/jamapsychiatry.2023.0123
```

**Books:**
```
Author, A. A. (Year). Book title: Subtitle (Edition). Publisher. https://doi.org/xx.xxxx
```

**Book Chapters:**
```
Chapter Author, A. A., & Chapter Author, B. B. (Year). Chapter title. In E. E. Editor & F. F. Editor (Eds.), Book title (pp. page range). Publisher.
```

**Websites:**
```
Author, A. A. (Year, Month Day). Page title. Website Name. URL
```

### Capitalization Rules
- Sentence case for article and book titles (capitalize only first word and proper nouns)
- Title case for journal names (capitalize all major words)

**Example:**
```
Smith, J. D. (2023). Effects of stress on cognitive performance: A meta-analysis. Journal of Experimental Psychology: General, 152(3), 456-478.
```

### Special Cases

**No author**: Move title to author position
```
Title of work. (Year). Journal Name...
```

**No date**: Use (n.d.)
```
Smith, J. D. (n.d.). Title...
```

**Up to 20 authors**: List all authors with "&" before last
**21 or more authors**: List first 19, then "...", then final author

## Chicago Style

### Overview
- Based on *The Chicago Manual of Style* (17th edition, 2017)
- Two systems: Notes-Bibliography and Author-Date
- Notes-Bibliography common in humanities
- Author-Date common in sciences

### Notes-Bibliography System

**In-Text**: Superscript numbers for footnotes or endnotes
```
One study demonstrated this effect.¹
```

**Note format:**
```
1. John D. Smith, Alice B. Johnson, and Carol D. Williams, "Effectiveness of Cognitive Behavioral Therapy for Anxiety Disorders," JAMA Psychiatry 80, no. 5 (2023): 456-64.
```

**Bibliography format:**
```
Smith, John D., Alice B. Johnson, and Carol D. Williams. "Effectiveness of Cognitive Behavioral Therapy for Anxiety Disorders." JAMA Psychiatry 80, no. 5 (2023): 456-64.
```

### Author-Date System

**In-Text**: Similar to APA
```
(Smith, Johnson, and Williams 2023)
Smith, Johnson, and Williams (2023) found...
```

**Reference list**: Similar to APA but with different punctuation
```
Smith, John D., Alice B. Johnson, and Carol D. Williams. 2023. "Effectiveness of Cognitive Behavioral Therapy for Anxiety Disorders." JAMA Psychiatry 80 (5): 456-64.
```

### Special Features
- Full names in bibliography (not just initials)
- Uses "and" not "&"
- Different punctuation from APA

## IEEE Style

### Overview
- Used in engineering, computer science, and technology
- Published by the Institute of Electrical and Electronics Engineers
- Numbered citations in square brackets
- References listed numerically

### In-Text Citations

**Format**: Numbers in square brackets

**Examples:**
```
Several studies have demonstrated this effect [1].

The algorithm was described by Smith [2] and later improved [3], [4].

Multiple implementations [1]-[4] have been proposed.
```

### Reference List Format

**Journal Articles:**
```
[1] A. A. Author, B. B. Author, and C. C. Author, "Title of article," Journal Name, vol. X, no. X, pp. XX-XX, Month Year.
```

**Example:**
```
[1] J. D. Smith, A. B. Johnson, and C. D. Williams, "Effectiveness of cognitive behavioral therapy for anxiety disorders," JAMA Psychiatry, vol. 80, no. 5, pp. 456-464, May 2023.
```

**Books:**
```
[2] A. A. Author, Book Title, Edition. City, State: Publisher, Year.
```

**Conference Papers:**
```
[3] A. A. Author, "Paper title," in Proc. Conference Name, City, State, Year, pp. XX-XX.
```

**Online Sources:**
```
[4] A. A. Author. "Title." Website. URL (accessed Mon. Day, Year).
```

### Special Features
- Abbreviated first and middle names
- Uses "and" before last author (not comma)
- Month abbreviations (Jan., Feb., etc.)
- "vol." and "no." before volume and issue
- "pp." before page range

## Additional Styles

### ACS Style (American Chemical Society)

**In-Text**: Superscript numbers or numbers in parentheses
```
This reaction has been well studied.¹
This reaction has been well studied (1).
```

**Reference format:**
```
(1) Smith, J. D.; Johnson, A. B.; Williams, C. D. Title of Article. J. Am. Chem. Soc. 2023, 145, 1234-1245.
```

**Features:**
- Semicolons between authors
- Abbreviated journal names
- Year in bold
- No issue numbers

### NLM Style (National Library of Medicine)

**Very similar to Vancouver**, used by PubMed/MEDLINE

**Key differences:**
- Uses PubMed journal abbreviations
- Specific format for electronic publications
- PMID or PMCID can be included

**Example:**
```
Smith JD, Johnson AB, Williams CD. Effectiveness of cognitive behavioral therapy for anxiety disorders. JAMA Psychiatry. 2023 May;80(5):456-64. doi: 10.1001/jamapsychiatry.2023.0123. PMID: 12345678.
```

## General Citation Best Practices

### Across All Styles

**When to cite:**
- Direct quotations
- Paraphrased ideas from others
- Statistics, data, or figures from other sources
- Theories, models, or frameworks developed by others
- Information that is not common knowledge

**Citation density:**
- Introduction: Cite liberally to establish context
- Methods: Cite when referencing established protocols or instruments
- Results: Rarely cite (focus on your own findings)
- Discussion: Cite frequently when comparing to prior work

**Source quality:**
- Prefer peer-reviewed journal articles
- Cite original sources when possible (not secondary citations)
- Use recent sources (within 5-10 years for active fields)
- Ensure sources are reputable and relevant

**Common mistakes to avoid:**
- Inconsistent formatting
- Missing required elements (DOI, page numbers, etc.)
- Citing sources not actually read (citation chaining)
- Over-reliance on review articles instead of primary sources
- Including uncited references or missing cited references
- Incorrect author names or initials
- Wrong year of publication
- Truncated titles

### Managing Citations

**Reference Management Software:**
- **Zotero**: Free, open-source, browser integration
- **Mendeley**: Free, PDF annotation, social features
- **EndNote**: Commercial, powerful, institutional support
- **RefWorks**: Web-based, institutional subscriptions

**Software benefits:**
- Automatic formatting in multiple styles
- In-text citation insertion
- Reference list generation
- PDF organization
- Sharing capabilities

### Verifying Citations

**Before submission, check:**
1. Every in-text citation has a corresponding reference
2. Every reference is cited in text
3. Formatting is consistent throughout
4. Author names and initials are correct
5. Titles are accurate
6. Journal names match required abbreviations
7. Volume, issue, and page numbers are correct
8. DOIs are included (when required)
9. URLs are functional (for web sources)
10. Citations appear in correct order (numerical styles)

## DOI (Digital Object Identifier)

### What is a DOI?
A unique alphanumeric string identifying digital content permanently.

**Format:**
```
doi:10.1001/jamapsychiatry.2023.0123
or
https://doi.org/10.1001/jamapsychiatry.2023.0123
```

### When to include:
- Required by most journals for recent publications
- Preferred over URLs because DOIs don't change
- Look up DOIs at https://www.crossref.org/ if not provided

### Style-specific formatting:
- **AMA**: `doi:10.xxxx/xxxxx`
- **APA**: `https://doi.org/10.xxxx/xxxxx`
- **Vancouver**: Often omitted or added at journal's discretion
- **Chicago**: `https://doi.org/10.xxxx/xxxxx`

## Quick Reference: Journal Article Format

| Style | Format |
|-------|--------|
| **AMA** | Author AA, Author BB. Title of article. *Journal*. Year;Vol(Iss):pp. doi:xx |
| **Vancouver** | Author AA, Author BB. Title of article. Journal. Year;Vol(Iss):pp. |
| **APA** | Author, A. A., & Author, B. B. (Year). Title of article. *Journal*, Vol(Iss), pp. https://doi.org/xx |
| **Chicago A-D** | Author, A. A., and B. B. Author. Year. "Title." *Journal* Vol (Iss): pp. |
| **IEEE** | A. A. Author and B. B. Author, "Title," *Journal*, vol. X, no. X, pp. XX-XX, Mon. Year. |

## Common Abbreviations

### Journal Abbreviations
Follow the journal's specified system (usually Index Medicus or ISO):
- *The Journal of Biological Chemistry* → *J Biol Chem*
- *Proceedings of the National Academy of Sciences* → *Proc Natl Acad Sci USA*
- *Nature Medicine* → *Nat Med*

### Month Abbreviations
- Jan., Feb., Mar., Apr., May, June, July, Aug., Sept., Oct., Nov., Dec.
- Some styles use three-letter abbreviations without periods

### Edition Abbreviations
- 1st ed., 2nd ed., 3rd ed., etc.
- Or: 1st edition, 2nd edition

## Special Publication Types

### Preprints
```
APA: Author, A. A. (Year). Title [Preprint]. Repository Name. https://doi.org/xx.xxxx
```

### Theses and Dissertations
```
APA: Author, A. A. (Year). Title [Doctoral dissertation, University Name]. Repository Name. URL
```

### Conference Proceedings
```
IEEE: A. A. Author, "Title," in Proc. Conf. Name, City, Year, pp. XX-XX.
```

### Software/Code
```
APA: Author, A. A. (Year). Title (Version X.X) [Computer software]. Publisher. URL
```

### Datasets
```
APA: Author, A. A. (Year). Title of dataset (Version X) [Data set]. Repository. https://doi.org/xx.xxxx
```

## Transitioning Between Styles

When converting between citation styles:

1. **Use reference management software** for automatic conversion
2. **Check these elements** that vary by style:
   - In-text citation format (numbered vs. author-date)
   - Author name format (initials vs. full names)
   - Title capitalization (sentence case vs. title case)
   - Journal name formatting (abbreviated vs. full)
   - Punctuation (periods, commas, semicolons)
   - Use of italics and bold
   - Order of elements
3. **Manually verify** after automatic conversion
4. **Check journal guidelines** for specific requirements

## Journal-Specific Citation Styles and Requirements

### How to Identify a Journal's Citation Style

**Step 1: Check Author Guidelines**
- Every journal provides author instructions (usually "Instructions for Authors" or "Author Guidelines")
- Citation style is typically specified in "References" or "Citations" section
- Look for example references formatted in the journal's style

**Step 2: Review Recent Publications**
- Examine 3-5 recent articles from your target journal
- Note the in-text citation format (numbered vs. author-date)
- Compare reference list formatting
- Check for journal-specific variations

**Step 3: Verify Journal-Specific Variations**
Some journals use modified versions of standard styles:
- Abbreviated vs. full journal names
- DOI inclusion requirements
- Article titles in title case vs. sentence case
- Maximum number of authors before "et al."

### Common Journals and Their Citation Styles

| Journal | Citation Style | Key Features |
|---------|---------------|--------------|
| **JAMA, JAMA Network journals** | AMA | Superscript numbers, abbreviated journal names, no issue numbers |
| **New England Journal of Medicine** | Modified Vancouver | Numbered brackets, abbreviated journals, limited authors (3 then et al) |
| **The Lancet** | Vancouver | Numbered brackets, PubMed abbreviations |
| **BMJ** | Vancouver | Numbered in-text, DOIs required when available |
| **Nature, Nature journals** | Nature style (numbered) | Numbered superscripts, abbreviated journals, no article titles in some journals |
| **Science** | Science style (numbered) | Numbered in-text, abbreviated format |
| **Cell, Cell Press journals** | Cell style (author-year) | Author-date, specific formatting for multiple citations |
| **PLOS journals** | Vancouver | Numbered brackets, full journal names in some PLOS journals |
| **Journal of Biological Chemistry** | JBC style (numbered) | Numbered in-text, specific abbreviation rules |
| **Psychological journals** | APA | Author-date, DOIs required |
| **IEEE journals** | IEEE | Numbered brackets, specific format for conference papers |
| **ACS journals** | ACS | Superscript or numbered, semicolons between authors |

### Journal Family Consistency

**Journals from the same publisher often share citation styles:**

**Elsevier journals:**
- Vary widely; check specific journal
- Many use numbered Vancouver-style
- Some allow author-date

**Springer Nature journals:**
- Nature journals: Nature style (numbered, abbreviated)
- Springer journals: Often numbered or author-date depending on field
- BMC journals: Vancouver with full journal names

**Wiley journals:**
- Varies by field
- Many biomedical journals use Vancouver
- Psychology/social science journals often use APA

**American Chemical Society (ACS):**
- All ACS journals use ACS style
- Consistent across Journal of American Chemical Society, Analytical Chemistry, etc.

### High-Impact Journal and Conference Preferences

| Venue | Field | Citation Preference | Key Features |
|-------|-------|-------------------|--------------|
| **Nature/Science** | Multidisciplinary | Numbered, abbreviated | Space-saving, broad readability |
| **Cell family** | Life sciences | Author-date or numbered | Attribution visibility |
| **NEJM/Lancet/JAMA** | Medicine | Vancouver/AMA numbered | Medical standard |
| **NeurIPS/ICML/ICLR** | Machine Learning | Numbered [1] or (Author, Year) | Varies by conference, check template |
| **CVPR/ICCV/ECCV** | Computer Vision | Numbered [1], IEEE-like | Compact format |
| **ACL/EMNLP** | NLP | Author-year (ACL style) | Attribution-focused |

### Adapting Citations for Different Target Journals

**When switching journals after desk rejection or withdrawal:**

**Use reference management software:**
1. Import references into Zotero, Mendeley, or EndNote
2. Select target journal's citation style from software library
3. Regenerate citations and reference list automatically
4. Manually verify formatting matches journal examples

**Key elements to check when converting:**
- In-text format (switch numbered ↔ author-date)
- Journal name abbreviation style
- Article title capitalization
- Author name format (initials vs. full names)
- DOI format and inclusion
- Issue number inclusion/exclusion
- Page number format

**Manual verification essential for:**
- Preprints and non-standard sources
- Software/datasets citations
- Conference proceedings
- Dissertations and theses

### Venue-Specific Evaluation Criteria

**Content expectations:**
- **High-impact journals**: >50% citations from last 5 years; primary sources preferred
- **Medical journals**: Recent clinical evidence; systematic reviews valued
- **ML conferences**: Recent papers (last 2-3 years); preprints (arXiv) acceptable
- **Self-citation**: Keep <20% across all venues

**Format compliance (often automated):**
- Match venue citation style exactly
- All in-text citations have corresponding references
- Include DOIs when required (journals) or arXiv IDs (ML conferences)
- Use correct abbreviations (PubMed for medical, standard for ML)

**ML conference specifics:**
- **NeurIPS/ICML/ICLR**: ArXiv preprints widely cited; recent work heavily valued
- **Page limits strict**: Citation formatting affects space
- **Supplementary material**: Can include extended bibliography
- **Double-blind review**: Avoid obvious self-citation patterns during review

### Citation Density by Venue Type

| Venue Type | Expected Citations | Key Notes |
|-----------|-------------------|-----------|
| **Nature/Science research** | 30-50 | Selective, high-impact citations |
| **Medical journals (RCT)** | 25-40 | Recent clinical evidence |
| **Field-specific journals** | 30-60 | Comprehensive field coverage |
| **ML conferences (8-page)** | 20-40 | Space-limited, recent work |
| **Review articles** | 100-300+ | Comprehensive coverage |

**ML conference citation practices:**
- **NeurIPS/ICML**: 25-40 references typical for 8-page papers
- **Workshop papers**: 15-25 references
- **ArXiv preprints**: Widely accepted and cited
- **Related work**: Concise but comprehensive; often moved to appendix
- **Recency critical**: Cite work from last 1-2 years when relevant

### Pre-Submission Citation Checklist

**Content:**
- [ ] ≥50% citations from last 5-10 years (or 2-3 years for ML conferences)
- [ ] <20% self-citations; balanced perspectives
- [ ] Primary sources cited (not citation chains)
- [ ] All claims supported by appropriate citations

**Format:**
- [ ] Style matches venue exactly (check template)
- [ ] All in-text citations in reference list and vice versa
- [ ] DOIs/arXiv IDs included as required
- [ ] Abbreviations match venue style

**ML conferences additional:**
- [ ] ArXiv preprints properly formatted
- [ ] Self-citations anonymized if double-blind review
- [ ] References fit within page limits

## Resources for Citation Styles

### Official Manuals
- AMA: https://www.amamanualofstyle.com/
- Vancouver/ICMJE: http://www.icmje.org/
- APA: https://apastyle.apa.org/
- Chicago: https://www.chicagomanualofstyle.org/
- IEEE: https://ieeeauthorcenter.ieee.org/

### Journal-Specific Style Guides
- Nature: https://www.nature.com/nature/for-authors/formatting-guide
- Science: https://www.science.org/content/page/instructions-authors
- Cell: https://www.cell.com/cell/authors
- JAMA: https://jamanetwork.com/journals/jama/pages/instructions-for-authors

### Quick Reference Guides
- Purdue OWL: https://owl.purdue.edu/
- Citation Machine: https://www.citationmachine.net/
- EasyBib: https://www.easybib.com/

### Reference Management
- Zotero: https://www.zotero.org/
- Mendeley: https://www.mendeley.com/
- EndNote: https://endnote.com/

### Journal Citation Style Databases
- Journal Citation Reports (Clarivate): Lists journal citation styles
- EndNote style repository: >7000 journal-specific styles
- Zotero Style Repository: https://www.zotero.org/styles
