# Grant Proposal Requirements

Comprehensive requirements and formatting guidelines for major federal and private foundation grant programs.

**Last Updated**: 2024

---

## NSF (National Science Foundation)

### Overview

**Agency**: National Science Foundation  
**Typical Award**: $100K-$500K per year, 3-5 years  
**Success Rate**: 20-25% (varies by program)  
**Review Criteria**: Intellectual Merit + Broader Impacts (equally weighted)

---

### NSF Standard Grant Proposal

**Page Limits (NSF PAPPG - Proposal & Award Policies & Procedures Guide)**:

| Component | Page Limit | Font | Spacing |
|-----------|-----------|------|---------|
| **Project Summary** | 1 page | Any readable, 10pt+ | Any |
| **Project Description** | 15 pages | Times Roman 11pt or similar | Single |
| **References Cited** | No limit | Times Roman 11pt | Single |
| **Biographical Sketch** | 3 pages per person | Times Roman 11pt | Single |
| **Budget Justification** | 3-5 pages | Any readable | Any |
| **Current & Pending Support** | No limit | Times Roman 11pt | Single |
| **Facilities, Equipment** | 2 pages | Any readable | Any |
| **Data Management Plan** | 2 pages | Any readable | Any |

**Margins**: 1 inch (2.54 cm) on all sides (strictly enforced)

---

### NSF Project Summary (1 page)

**Required Sections** (clearly labeled):

1. **Overview** (1-2 paragraphs)
   - Concise description of research activity
   - Objectives and methods

2. **Intellectual Merit** (1 paragraph)
   - How project advances knowledge
   - Innovation and transformative potential
   - Qualifications of research team

3. **Broader Impacts** (1 paragraph)
   - Benefits to society
   - Broadening participation
   - Dissemination and outreach

**Format**: Can be full-page text or sectioned  
**Audience**: Non-specialists (broad scientific community)

**Template**: `assets/grants/nsf_project_summary.tex`

---

### NSF Project Description (15 pages)

**Typical Structure**:

1. **Introduction/Background** (2-3 pages)
   - Current state of knowledge
   - Research gap
   - Preliminary work/feasibility
   - Team qualifications

2. **Research Plan** (8-10 pages)
   - Objectives and hypotheses
   - Methods and approach
   - Timeline and milestones
   - Expected outcomes

3. **Broader Impacts** (1-2 pages)
   - Educational activities
   - Broadening participation (underrepresented groups)
   - Dissemination (publications, conferences, public outreach)
   - Societal benefits

4. **Results from Prior NSF Support** (1 page, if applicable)
   - Required if PI has had NSF support in past 5 years
   - Intellectual merit and broader impacts of prior work
   - Publications from prior NSF grants

**Key Requirements**:
- Intellectual Merit and Broader Impacts integrated throughout
- Figures and tables allowed (count toward page limit)
- Citations to references (use References Cited section)

**Template**: `assets/grants/nsf_proposal_template.tex`

---

### NSF Biographical Sketch (3 pages)

**Required Sections**:
1. **Professional Preparation**: Institutions, degrees, fields
2. **Appointments**: Current and previous positions
3. **Products**: Up to 5 most relevant, up to 5 other significant products
   - Can include publications, datasets, software, patents
4. **Synergistic Activities**: Up to 5 examples of impact beyond research

**Format**:
- NSF template must be used (SciENcv or NSF-approved format)
- No longer uses "Publications" but "Products"

---

### NSF Broader Impacts

**NSF-Recognized Categories** (demonstrate ≥1):
1. **Advance discovery while promoting teaching/learning**
2. **Broaden participation** of underrepresented groups
3. **Disseminate broadly** to enhance scientific/technological understanding
4. **Benefits to society** (economic, health, environment, national security)
5. **Develop scientific workforce** and infrastructure

**Best Practices**:
- Be specific with measurable outcomes
- Explain how activities will be assessed
- Integrate with research (don't treat as "add-on")
- Budget for broader impacts activities

**Examples**:
- K-12 outreach programs
- Curriculum development
- Training underrepresented students
- Public science communication
- Open-source software development

---

### NSF Budget

**Typical Categories**:
- **Senior Personnel**: PI, co-PIs (% effort, salary)
- **Other Personnel**: Postdocs, graduate students, undergrads
- **Fringe Benefits**: Institutional rates
- **Equipment**: Items >$5,000
- **Travel**: Domestic and foreign
- **Participant Support**: Workshops, conferences (separate category)
- **Other Direct Costs**: Materials, publication, subawards
- **Indirect Costs**: Institutional F&A rate

**Budget Justification**: Explain need for each item

---

### NSF Data Management Plan (2 pages)

**Required Content**:
- Types of data produced
- Standards for data format and metadata
- Policies for access and sharing
- Policies for re-use and redistribution
- Plans for archiving and preservation

**Acceptable Approaches**:
- Deposit in domain-specific repository
- Institutional repository
- Data available upon request (with restrictions justification)

---

### NSF Review Process

**Review Criteria** (equally weighted):

1. **Intellectual Merit**:
   - What is the potential to advance knowledge?
   - How well-conceived and organized?
   - Qualifications of PI and team?
   - Availability of resources?

2. **Broader Impacts**:
   - What are the potential benefits to society?
   - How well-suited to achieve broader impacts?

**Panel Review**: Proposals reviewed by panel of experts  
**Timeline**: Typically 6 months from deadline to award decision

---

### NSF LaTeX Templates

- **Full Proposal**: `assets/grants/nsf_proposal_template.tex`
- **Project Summary**: `assets/grants/nsf_project_summary.tex`
- **Biographical Sketch**: Use NSF SciENcv or template

**Resources**: 
- NSF PAPPG: https://www.nsf.gov/publications/pub_summ.jsp?ods_key=pappg
- NSF Fastlane: https://www.fastlane.nsf.gov/

---

## NIH (National Institutes of Health)

### Overview

**Agency**: National Institutes of Health  
**Funding Mechanisms**: 
- **R01**: Research Project Grant (most common)
- **R21**: Exploratory/Developmental Research Grant
- **K Awards**: Career Development Awards
**Success Rate**: 10-20% (varies by institute and mechanism)

---

### NIH R01 Research Grant

**Page Limits** (Research Strategy):

| Component | Page Limit | Font | Spacing |
|-----------|-----------|------|---------|
| **Specific Aims** | 1 page | Arial 11pt minimum | Any |
| **Research Strategy** | 12 pages | Arial 11pt minimum | 0.5 inch margins minimum |
| - Significance | Part of 12 | | |
| - Innovation | Part of 12 | | |
| - Approach | Part of 12 | | |
| **Bibliography** | No limit | Arial 11pt | |
| **Biographical Sketch** | 5 pages per person | Arial 11pt | |

**Margins**: 0.5 inch minimum (all sides)  
**Paper Size**: Letter (8.5 × 11 inches)

---

### NIH Specific Aims Page (1 page)

**THE MOST CRITICAL COMPONENT**

**Structure** (recommended):

1. **Opening paragraph** (2-3 sentences)
   - Hook: Significance of problem
   - Gap: What's not known

2. **Long-term goal** (1 sentence)
   - Overarching research vision

3. **Objective** (1-2 sentences)
   - What this proposal will accomplish
   - Central hypothesis

4. **Rationale** (2-3 sentences)
   - Why you expect success
   - Preliminary data supporting hypothesis

5. **Specific Aims** (3 aims typical)
   - **Aim 1**: [Title]. [1-2 sentence description. Working hypothesis. Expected outcome.]
   - **Aim 2**: [Title]. [1-2 sentence description. Working hypothesis. Expected outcome.]
   - **Aim 3**: [Title]. [1-2 sentence description. Working hypothesis. Expected outcome.]

6. **Payoff paragraph** (2-3 sentences)
   - Impact and significance
   - Innovation
   - Future directions

**Best Practices**:
- Crystal clear, compelling narrative
- State hypothesis explicitly
- Explain expected outcomes
- Show innovation and impact

**Template**: `assets/grants/nih_specific_aims.tex`

---

### NIH Research Strategy (12 pages)

**Required Sections**:

#### 1. Significance (typically 2-3 pages)
- **Importance**: Critical barrier to progress
- **Knowledge gap**: What's not known
- **Impact**: How project advances field
- **Rigor**: Scientific premise/prior work
- **References**: Cite key literature

#### 2. Innovation (typically 1-2 pages)
- **Novelty**: New concepts, approaches, methods
- **Challenge paradigms**: Shift thinking
- **Refined/new methodologies**: Technical innovation
- **Novel applications**: Existing tools in new ways

#### 3. Approach (typically 7-9 pages)
**For Each Aim**:
- **Rationale**: Why this aim
- **Experimental design**: Detailed methods
- **Expected outcomes**: What results mean
- **Potential problems & alternatives**: Mitigation strategies
- **Rigor and reproducibility**: Controls, replication, statistics
- **Timeline**: When each aim completed

**Additional Approach Content**:
- Preliminary data (critical for R01)
- Power analyses for sample sizes
- Statistical analysis plans
- Rigor of prior research cited

---

### NIH Biographical Sketch (5 pages)

**Sections** (NIH format):
1. **Personal Statement** (4 sentences explaining why you're suited)
2. **Positions, Honors, and Scientific Appointments**
3. **Contributions to Science** (Up to 5 contributions, up to 4 pubs each)
4. **Research Support** (current and completed grants, overlap checked)

**Format**: Must use NIH template (fillable PDF or format page)

---

### NIH Review Criteria

**Scored Criteria** (1-9 scale, 1=best):
1. **Significance**: Importance, impact
2. **Investigator(s)**: Qualifications, track record
3. **Innovation**: Novel concepts, methods
4. **Approach**: Feasibility, rigor, design
5. **Environment**: Institutional support, resources

**Additional Considerations** (not scored but noted):
- Vertebrate animals
- Biohazards
- Human subjects protections
- Inclusion of women, minorities, children
- Budget appropriateness

**Overall Impact Score**: 1-9 (synthesizes all criteria)

---

### NIH R21 (Exploratory Grant)

**Key Differences from R01**:
- **Research Strategy**: 6 pages (vs. 12 for R01)
- **Duration**: 2 years maximum
- **Budget**: $275K total costs over 2 years
- **Preliminary data**: Not required (exploratory nature)
- **Purpose**: High-risk, high-reward projects; new directions

**When to Choose R21 vs. R01**:
- R21: Early-stage, limited preliminary data, high-risk
- R01: Established line of research, strong preliminary data

---

### NIH K Awards (Career Development)

**Mechanisms**:
- **K01**: Mentored Research Scientist Development Award
- **K08**: Mentored Clinical Scientist Research Career Development Award
- **K23**: Mentored Patient-Oriented Research Career Development Award
- **K99/R00**: Pathway to Independence Award (postdoc to faculty)

**Key Components**:
- **Career Development Plan**: Training goals, timeline
- **Research Plan**: 6-12 pages (mechanism-dependent)
- **Mentor(s)**: Letters of support, mentoring plan
- **Institutional Commitment**: Environment, resources
- **Protected Time**: 75% research effort typical

---

### NIH Budget

**Modular vs. Detailed**:
- **Modular**: ≤$250K direct costs per year (25K increments)
- **Detailed**: >$250K direct costs per year

**Modular Budget**: Only need budget justification for personnel, consortium, equipment >$25K

**Budget Period**: Year-by-year (usually 5 years for R01)

---

### NIH LaTeX Templates

- **R01 Full Proposal**: `assets/grants/nih_r01_template.tex`
- **Specific Aims**: `assets/grants/nih_specific_aims.tex`
- **Biographical Sketch**: Use NIH fillable PDF or format page

**Resources**:
- NIH Application Guide: https://grants.nih.gov/grants/how-to-apply-application-guide.html
- SF424 Forms: https://grants.nih.gov/grants/how-to-apply-application-guide/forms-e/general-forms-e.pdf

---

## DOE (Department of Energy)

### Overview

**Agency**: U.S. Department of Energy  
**Offices**:
- **Office of Science**: Basic research (BES, BER, ASCR, NP, HEP, FES)
- **ARPA-E**: High-risk, high-reward energy technologies
- **EERE**: Energy efficiency and renewable energy

**Typical Award**: $200K-$1M per year, 3 years  
**Success Rate**: 10-30% (varies by program)

---

### DOE Office of Science Proposal

**Page Limits** (typical, varies by FOA):

| Component | Page Limit | Format |
|-----------|-----------|--------|
| **Project Narrative** | 10-20 pages | Times 11pt, 1" margins |
| **References** | No limit | |
| **Budget Justification** | 3-5 pages | |
| **Biographical Sketches** | 2-3 pages each | |
| **Current & Pending** | No limit | |
| **Facilities & Resources** | No limit | |
| **Data Management Plan** | 2 pages | |

---

### DOE Project Narrative Structure

**Typical Sections**:

1. **Background and Significance** (2-3 pages)
   - Energy relevance
   - Current state of knowledge
   - Research need

2. **Preliminary Work** (1-2 pages)
   - Team's qualifications
   - Relevant prior results

3. **Research Plan** (10-15 pages)
   - **Objectives**: Clear goals
   - **Technical approach**: Detailed methods
   - **Milestones and deliverables**: Specific, measurable
   - **Timeline**: Gantt chart common
   - **Team and management**: Roles, collaboration

4. **Broader Impacts** (1-2 pages)
   - Workforce development
   - Technology transfer potential
   - Publications and dissemination

---

### DOE-Specific Requirements

**Energy Relevance**: Must clearly tie to DOE mission
- Basic science: Fundamental understanding for energy applications
- Applied: Energy efficiency, renewable energy, grid, storage

**Technology Readiness Levels (TRLs)**: Often required to specify
- **TRL 1-3**: Basic research, proof of concept
- **TRL 4-6**: Component/subsystem validation
- **TRL 7-9**: System demonstration, deployment

**National Laboratory Collaboration**: Encouraged
- Include lab scientists as co-PIs or collaborators
- Letter of collaboration from lab

**Cost Sharing**: Sometimes required (check FOA)
- Can be in-kind (equipment, time)
- Must be documented

---

### DOE Budget Considerations

**Allowable Costs**:
- Personnel (salaries, benefits)
- Equipment
- Travel (especially to DOE national labs)
- Materials and supplies
- Subcontracts
- Indirect costs (negotiated F&A rate)

**Unallowable**:
- Construction
- Entertainment
- Some indirect costs (depends on institution type)

---

### DOE LaTeX Template

**Template**: `assets/grants/doe_proposal_template.tex`

**Resources**:
- DOE Office of Science Funding: https://science.osti.gov/grants
- EERE Funding: https://www.energy.gov/eere/funding/eere-funding-opportunities

---

## DARPA (Defense Advanced Research Projects Agency)

### Overview

**Agency**: Defense Advanced Research Projects Agency (DoD)  
**Mission**: High-risk, high-reward research for national security  
**Typical Award**: $500K-$5M per year, 2-4 years  
**Success Rate**: 5-15% (highly competitive)

---

### DARPA BAA (Broad Agency Announcement) Response

**Page Limits** (typical, varies by BAA):

| Component | Page Limit | Format |
|-----------|-----------|--------|
| **Technical and Management Proposal** | 20-25 pages | Times 12pt, 1" margins |
| **Cost Proposal** | Separate volume | |

---

### DARPA Technical Proposal Structure

**Key Sections**:

1. **Executive Summary** (1 page)
   - Vision and impact
   - Technical approach overview
   - Team qualifications

2. **Heilmeier Catechism** (1-2 pages)
   DARPA requires answering these questions:
   - **What are you trying to do?** Articulate objectives without jargon
   - **How is it done today? Limitations?** Current practice and shortcomings
   - **What is new in your approach?** Innovation
   - **Who cares?** Impact if successful
   - **If successful, what difference will it make?** Transformation
   - **What are the risks?** Technical risks and mitigation
   - **How much will it cost?** Budget overview
   - **How long will it take?** Timeline
   - **What are the mid-term and final exams?** Milestones for success

3. **Technical Approach** (10-15 pages)
   - Detailed technical plan
   - Task breakdown
   - Risk mitigation
   - Innovation justification

4. **Management Plan** (2-3 pages)
   - Team organization
   - Key personnel roles
   - Collaboration approach
   - Milestone schedule (Gantt chart)

5. **Capabilities and Experience** (2-3 pages)
   - Team qualifications
   - Relevant facilities and equipment
   - Similar past programs

6. **Transition Plan** (1-2 pages)
   - Path to DoD transition
   - End users identified
   - Technology transfer approach

---

### DARPA-Specific Considerations

**Engagement with Program Manager (PM)**:
- **Strongly encouraged** to contact PM before submission
- Discuss idea alignment with program goals
- PM can provide feedback on approach

**Transformative Impact**:
- Must demonstrate potential for "game-changing" impact
- Not incremental improvements

**Technical Risk**:
- High-risk approaches acceptable (even encouraged)
- Must show mitigation strategies

**National Security Relevance**:
- Clear connection to defense applications
- Dual-use (civilian + military) often valuable

**Metrics for Success**:
- Quantifiable milestones
- "Go/no-go" decision points

---

### DARPA Budget

**Full Cost Accounting**: Detailed justification required
- **Labor**: Hourly rates, hours per task
- **Materials**: Itemized
- **Equipment**: Justification for purchases
- **Travel**: Specific trips with purpose
- **Subcontracts**: Detailed subcontract budgets
- **Indirect Costs**: Negotiated rates

**Cost Realism**: Budget must be realistic for proposed work

---

### DARPA LaTeX Template

**Template**: `assets/grants/darpa_baa_response.tex`

**Resources**:
- DARPA Opportunities: https://www.darpa.mil/work-with-us/opportunities
- BAA Listings: SAM.gov (formerly FedBizOpps)

---

## Private Foundations

### Gates Foundation

**Focus Areas**: Global health, poverty alleviation, education  
**Typical Award**: Varies widely ($100K to $10M+)

**Proposal Requirements**:
- **Letter of Inquiry** (2-3 pages): Initial screening
- **Full Proposal** (if invited): 10-15 pages
- **Theory of Change**: How intervention leads to impact
- **Monitoring & Evaluation**: Metrics, data collection

**Key Emphases**:
- Scalability and sustainability
- Impact in low-resource settings
- Partnerships with local organizations
- Data-driven decision making

---

### Wellcome Trust

**Focus**: Biomedical research, global health  
**Geographic**: UK and international  
**Typical Award**: £100K to £5M

**Proposal Format** (varies by scheme):
- **Investigator Awards**: Track record and research vision
- **Project Grants**: Specific research project
- **Career Development**: Early/mid-career researchers

**Requirements**:
- Research plan
- Track record
- Value for money justification
- Patient and public involvement

---

### Howard Hughes Medical Institute (HHMI)

**Type**: Investigator appointments (not grants)  
**Award**: ~$9M over 7 years (renewable)  
**Focus**: Biomedical research, early-career scientists

**Selection**:
- Nomination by institution
- Track record of innovation
- Research vision for next 5-7 years
- Scientific leadership potential

---

### Chan Zuckerberg Initiative (CZI)

**Focus**: Science, education, justice & opportunity  
**Award Types**:
- **Imaging**: Advanced imaging technologies
- **Neurodegeneration Challenge**: AD, ALS, PD, FTD
- **Single-Cell Biology**: Tools and resources

**Emphasis**:
- Open science (data sharing, open-source)
- Collaboration across institutions
- Technology development
- Diversity and inclusion

---

## Quick Reference Table

| Agency | Typical Award | Duration | Key Criteria | Template |
|--------|--------------|----------|--------------|----------|
| **NSF** | $100K-500K/yr | 3-5 yrs | Intellectual Merit + Broader Impacts | `nsf_proposal_template.tex` |
| **NIH R01** | $250K-500K/yr | 5 yrs | Significance, Innovation, Approach | `nih_r01_template.tex` |
| **NIH R21** | $275K total | 2 yrs | Exploratory, high-risk | `nih_r21_template.tex` |
| **DOE** | $200K-1M/yr | 3 yrs | Energy relevance, TRLs | `doe_proposal_template.tex` |
| **DARPA** | $500K-5M/yr | 2-4 yrs | Transformative, Heilmeier | `darpa_baa_response.tex` |

---

## General Best Practices

### Writing Effective Proposals

1. **Start early**: 2-3 months minimum
2. **Read the call carefully**: Follow requirements exactly
3. **Know your reviewers**: Write for expert audience
4. **Tell a story**: Compelling narrative with clear logic
5. **Be specific**: Concrete objectives, methods, outcomes
6. **Show feasibility**: Preliminary data, expertise
7. **Address weaknesses**: Acknowledge and mitigate risks

### Common Mistakes to Avoid

1. **Vague objectives**: "Understand X" → "Determine whether X causes Y"
2. **Lack of innovation**: Incremental vs. transformative
3. **Poor broader impacts** (NSF): Generic, unintegrated
4. **Weak specific aims** (NIH): Most critical page!
5. **Missing preliminary data**: Show feasibility
6. **Unrealistic timeline**: Be honest about what's achievable
7. **Formatting violations**: Auto-rejection possible
8. **Typos and errors**: Suggests lack of care

### Timeline for Proposal Development

**3 months before deadline**:
- Identify opportunity
- Assemble team
- Outline aims/objectives

**2 months before**:
- Draft aims/objectives
- Preliminary budget
- Contact program officer (if allowed)

**1 month before**:
- Full first draft
- Internal review
- Revise based on feedback

**2 weeks before**:
- Final revisions
- Proofread carefully
- Assemble all documents

**1 week before**:
- Institutional review/approval
- Budget finalization
- Submission system upload

**2 days before**:
- Final check
- Submit (don't wait until deadline!)

---

## Resources

### Grant Writing Guides
- NSF PAPPG: https://www.nsf.gov/publications/pub_summ.jsp?ods_key=pappg
- NIH Application Guide: https://grants.nih.gov/grants/how-to-apply-application-guide.html
- GrantForward (database): https://www.grantforward.com/
- Pivot (database): https://pivot.proquest.com/

### Institutional Resources
- Office of Sponsored Research (OSR)
- Grant writing workshops
- Internal mock reviews
- Budget/compliance offices

---

## Summary

**Key Takeaways**:

1. **Know the agency**: Different missions, different emphases
2. **Follow the rules**: Page limits, fonts, margins strictly enforced
3. **Tell a compelling story**: Clear problem, innovative solution, feasible plan
4. **Demonstrate impact**: Intellectual merit (NSF/NIH) or mission relevance (DOE/DARPA)
5. **Show feasibility**: Preliminary data, team expertise, resources
6. **Budget realistically**: Justify all costs
7. **Proofread carefully**: Typos undermine credibility
8. **Submit early**: Technical glitches happen

**Remember**: Grant writing is a skill developed over time. Seek feedback, revise, and persist!

