# Common AI/LLM Icons Reference

This file contains a comprehensive list of popular AI/LLM icons available in the lobe-icons library.

## Models

| Icon Name | Description |
|-----------|-------------|
| `claude` | Anthropic Claude |
| `chatgpt` | ChatGPT |
| `gpt` | GPT models |
| `gemini` | Google Gemini |
| `llama` | Meta LLaMA |
| `mistral` | Mistral AI |
| `chatglm` | 智谱 ChatGLM |
| `baichuan` | 百川 Baichuan |
| `deepseek` | DeepSeek |
| `qwen` | 通义千问 Qwen |
| `yi` | 零一万物 Yi |
| `aya` | Cohere Aya |

## Providers

| Icon Name | Description |
|-----------|-------------|
| `openai` | OpenAI |
| `anthropic` | Anthropic |
| `google` | Google |
| `cohere` | Cohere |
| `huggingface` | Hugging Face |
| `openrouter` | OpenRouter |
| `perplexity` | Perplexity |
| `stability` | Stability AI |
| `alibaba` | 阿里巴巴 Alibaba |
| `alibabacloud` | 阿里云 Alibaba Cloud |
| `tencent` | 腾讯 Tencent |
| `baidu` | 百度 Baidu |
| `zhipu` | 智谱 AI |
| `moonshot` | 月之暗面 Moonshot (Kimi) |
| `minimax` | MiniMax |
| `zeroone` | 零一万物 01.AI |
| `ai21` | AI21 Labs (Jamba) |

## Applications

| Icon Name | Description |
|-----------|-------------|
| `lobechat` | LobeChat |
| `comfyui` | ComfyUI |
| `automatic` | Automatic1111 (SD WebUI) |
| `midjourney` | Midjourney |
| `runway` | Runway |
| `capcut` | CapCut |
| `cline` | Cline |
| `colab` | Google Colab |
| `copilotkit` | CopilotKit |
| `aistudio` | Google AI Studio |
| `clipdrop` | Clipdrop |

## Chinese AI Providers & Models

| Icon Name | Chinese Name | Description |
|-----------|--------------|-------------|
| `chatglm` | 智谱清言 | ChatGLM |
| `zhipu` | 智谱 | Zhipu AI |
| `baichuan` | 百川 | Baichuan |
| `deepseek` | 深度求索 | DeepSeek |
| `moonshot` | 月之暗面 | Moonshot (Kimi) |
| `minimax` | 稀宇科技 | MiniMax |
| `zeroone` | 零一万物 | 01.AI |
| `qwen` | 通义千问 | Qwen |
| `yi` | 零一万物 | Yi |
| `alibaba` | 阿里巴巴 | Alibaba |
| `alibabacloud` | 阿里云 | Alibaba Cloud |
| `tencent` | 腾讯 | Tencent |
| `baidu` | 百度 | Baidu |
| `ai360` | 360智脑 | 360 AI Brain |
| `aimass` | 紫东太初 | AiMass |
| `aihubmix` | 推理时代 | AiHubMix |
| `codegeex` | — | CodeGeeX |

## Tips for Finding Icons

1. **Icon naming**: Usually lowercase, hyphenated (e.g., `anthropic`, `chatglm`)
2. **Company vs Product**: Some have both (e.g., `alibaba` and `alibabacloud`, `zhipu` and `chatglm`)
3. **Color variants**: Many icons have `-color` suffix for colored versions
4. **Browse all**: Visit https://lobehub.com/icons to see the complete catalog
