# Slide Template Library (Assertion-Evidence Style)

> **Rule**: All slide headings must be **assertion sentences** (complete, testable claims), not topic labels. Body content provides **evidence** (charts, tables, diagrams, bullet points). Keep to **3-5 bullet points maximum** per slide. Place data sources in the footer (bottom-right).

---

## Core Slide Templates

### 1. Cover Slide

**Purpose**: Introduce the main conclusion/proposition upfront.

**Structure**:
```
HEADING: [Main Conclusion as Assertion Sentence]
SUBHEADING: [Context, Occasion, or Target Audience]
FOOTER: [Date] | [Presenter Name/Organization]
```

**Example**:
```
HEADING: Mastering Three Variables Unlocks Consistently Great Coffee at Home
SUBHEADING: A Practical Guide for Coffee Enthusiasts
FOOTER: October 2025 | Coffee Workshop Series
```

---

### 2. Table of Contents

**Purpose**: Show the roadmap (3-5 chapters matching first-level reasons).

**Structure**:
```
HEADING: Roadmap / What We'll Cover
CHAPTERS:
1. [First Reason/Chapter]
2. [Second Reason/Chapter]
3. [Third Reason/Chapter]
4. [Optional Fourth]
5. [Optional Fifth]
```

**Example**:
```
HEADING: Roadmap
1. Grind Size Controls Extraction Rate
2. Water Temperature Affects Flavor Balance
3. Brew Time Determines Strength
4. Simple Equipment Upgrades Improve Consistency
```

---

### 3. Problem Statement (Problem Slide)

**Purpose**: Assert why the current situation is unsatisfactory or why action is needed now.

**Structure**:
```
HEADING: [Assertion about the problem's severity or impact]
EVIDENCE:
- Key metric or statistic showing problem scale
- Real-world consequence or example
- Visual: trend chart (decline/growth) or comparison table
SOURCE: [Data citation in footer]
```

**Example**:
```
HEADING: Inconsistent home coffee wastes premium beans and disappoints drinkers daily
EVIDENCE:
- 68% of home brewers report frequent "bad cup" experiences (Source: 2024 Coffee Survey)
- Average household wastes 2 lbs of beans/year due to poor technique
- Visual: Bar chart showing #1 complaint: "Can't replicate good results"
SOURCE: National Coffee Association, 2024 Home Brewing Survey
```

---

### 4. Opportunity / Goal (Aspiration Slide)

**Purpose**: Assert what success looks like or what can be achieved.

**Structure**:
```
HEADING: [Assertion about the achievable outcome]
EVIDENCE:
- Quantified benefit or goal metric
- Success example or case study
- Visual: target state diagram or before/after comparison
SOURCE: [Citation if applicable]
```

**Example**:
```
HEADING: Mastering three simple variables delivers cafe-quality coffee at one-tenth the cost
EVIDENCE:
- Home brewing cost: $0.50/cup vs. cafe $5/cup
- 90% satisfaction rate with proper technique (vs. 32% without)
- Visual: Cost comparison bar chart + satisfaction curve
SOURCE: Coffee Economics Institute, 2025
```

---

### 5. Solution Overview (Three-Part Solution)

**Purpose**: Assert that a specific approach (typically 3 components) solves the problem.

**Structure**:
```
HEADING: [Assertion about the solution's effectiveness]
COMPONENTS:
A. [Component 1 - brief phrase]
B. [Component 2 - brief phrase]
C. [Component 3 - brief phrase]
VISUAL: Three-box diagram or process flow
```

**Example**:
```
HEADING: Three brewing variables—grind size, water temp, and time—control every cup's quality
COMPONENTS:
A. Grind Size → controls extraction rate
B. Water Temperature → affects flavor compounds
C. Brew Time → determines strength & balance
VISUAL: Three interconnected gears diagram
```

---

### 6. Evidence Slide (Type 1: Comparison)

**Purpose**: Assert that one option is superior/different from another.

**Structure**:
```
HEADING: [Assertion stating the comparison result]
EVIDENCE:
- Table or side-by-side comparison (A vs B)
- Key differentiators highlighted
- Visual: comparison table, bar chart (grouped/stacked), or Venn diagram
SOURCE: [Citation]
```

**Example**:
```
HEADING: Burr grinders produce uniform particles, while blade grinders create inconsistent sizes
EVIDENCE:
- Burr: 85% particles within 5% of target size
- Blade: Only 40% particles within target range; 30% "fines" that over-extract
- Visual: Histogram comparing particle size distribution
SOURCE: Coffee Research Institute, 2024
```

---

### 7. Evidence Slide (Type 2: Trend Over Time)

**Purpose**: Assert a trend or change over time.

**Structure**:
```
HEADING: [Assertion about the trend direction/magnitude]
EVIDENCE:
- Time-series data points
- Annotation of key events or inflection points
- Visual: line chart, area chart, or combo chart
SOURCE: [Citation]
```

**Example**:
```
HEADING: Optimal extraction occurs between 195-205°F, with quality dropping sharply outside this range
EVIDENCE:
- Peak flavor score at 200°F: 8.7/10
- Below 190°F: sour, under-extracted (score 4.2/10)
- Above 210°F: bitter, over-extracted (score 3.8/10)
- Visual: Line chart with shaded optimal zone
SOURCE: Specialty Coffee Association Temperature Study, 2023
```

---

### 8. Evidence Slide (Type 3: Process / Steps)

**Purpose**: Assert that following a sequence leads to a result.

**Structure**:
```
HEADING: [Assertion about the process outcome]
STEPS:
1. [Step 1 - action verb + brief description]
2. [Step 2]
3. [Step 3]
4. [Step 4]
VISUAL: Flowchart, numbered diagram, or timeline
```

**Example**:
```
HEADING: Four simple steps ensure consistent pour-over coffee every time
STEPS:
1. Weigh 20g coffee, grind to medium-fine (sand texture)
2. Heat water to 200°F, wet filter to remove paper taste
3. Bloom for 30 seconds with 40g water, then pour in circles to 320g total
4. Finish brew at 3:00-3:30 minutes
VISUAL: Four-panel illustrated timeline
```

---

### 9. Evidence Slide (Type 4: Data Breakdown / Composition)

**Purpose**: Assert how parts contribute to a whole.

**Structure**:
```
HEADING: [Assertion about the composition or breakdown]
EVIDENCE:
- Percentage breakdown by category
- Contribution of each component
- Visual: stacked bar/area chart, treemap, or waterfall chart
SOURCE: [Citation]
```

**Example**:
```
HEADING: Coffee flavor compounds extract in three phases, with sugars peaking at 2 minutes
EVIDENCE:
- Acids: 30% extracted in first 60 sec
- Sugars: 50% extracted at 90-150 sec (peak flavor)
- Bitter compounds: 20% extracted after 180 sec (avoid over-extraction)
- Visual: Stacked area chart showing compound % over time
SOURCE: Coffee Chemistry Lab, UC Davis, 2024
```

---

### 10. Risk & Mitigation

**Purpose**: Assert that identified risks are manageable with specific actions.

**Structure**:
```
HEADING: [Assertion that risks can be controlled/mitigated]
RISKS & MITIGATIONS:
- Risk 1: [Brief description] → Mitigation: [Action]
- Risk 2: [Brief description] → Mitigation: [Action]
- Risk 3: [Brief description] → Mitigation: [Action]
VISUAL: Risk matrix (likelihood × impact) or mitigation table
```

**Example**:
```
HEADING: Common brewing pitfalls are easily avoided with simple adjustments
RISKS & MITIGATIONS:
- Bitter coffee → Reduce water temp to 195°F or shorten brew time by 30 sec
- Weak coffee → Increase coffee dose by 2g or extend brew time by 20 sec
- Sour coffee → Raise water temp to 205°F or use finer grind
VISUAL: Troubleshooting flowchart
```

---

### 11. Case Study / Example

**Purpose**: Assert that a real-world example demonstrates the approach's effectiveness.

**Structure**:
```
HEADING: [Assertion about what the case demonstrates]
CASE DETAILS:
- Context: [Who, what, when]
- Challenge: [Problem faced]
- Action: [Solution applied]
- Result: [Quantified outcome]
VISUAL: Before/after comparison or result metrics
SOURCE: [Citation or attribution]
```

**Example**:
```
HEADING: Adjusting grind size alone improved home brewer satisfaction from 40% to 85%
CASE DETAILS:
- Context: 50-person home brewer cohort, 4-week trial
- Challenge: Inconsistent flavor, 40% satisfaction baseline
- Action: Switched from blade to burr grinder, calibrated grind size per method
- Result: Satisfaction rose to 85%, "bad cup" rate dropped from 32% to 6%
VISUAL: Before/after bar chart + satisfaction curve
SOURCE: Coffee Education Center, Seattle, 2024
```

---

### 12. Roadmap / Timeline

**Purpose**: Assert that a phased approach achieves milestones on schedule.

**Structure**:
```
HEADING: [Assertion about timeline feasibility or sequence]
PHASES:
- Phase 1: [Milestone] by [Date]
- Phase 2: [Milestone] by [Date]
- Phase 3: [Milestone] by [Date]
- Phase 4: [Milestone] by [Date]
VISUAL: Gantt chart, timeline, or milestone roadmap
```

**Example**:
```
HEADING: Four-week progression builds brewing skills from beginner to confident home barista
PHASES:
- Week 1: Master grind size (try 3 grind settings, pick best)
- Week 2: Dial in water temperature (test 195°F, 200°F, 205°F)
- Week 3: Optimize brew time (adjust by 15-sec increments)
- Week 4: Combine variables, replicate best cup 3× consistently
VISUAL: Four-week timeline with icons
```

---

### 13. Conclusion & Call to Action (CTA)

**Purpose**: Restate the main conclusion and prompt immediate action.

**Structure**:
```
HEADING: [Restatement of main conclusion]
CTA: [Specific action with deadline/next step]
SUPPORTING POINTS (optional):
- Recap key benefit 1
- Recap key benefit 2
- Recap key benefit 3
VISUAL: Summary icon or "Next Steps" checklist
```

**Example**:
```
HEADING: Mastering grind, temp, and time transforms every home cup into a cafe-quality experience
CTA: Pick one technique from today's session and try it with your next brew
KEY TAKEAWAYS:
- Grind size controls extraction rate—match it to your method
- Water temp 195-205°F unlocks balanced flavors
- Brew time fine-tunes strength and prevents bitterness
VISUAL: Three-point checklist with icons
```

---

### 14. Backup Slides

**Purpose**: Provide detailed data, methodology, or FAQs without cluttering main deck.

**Structure**:
```
HEADING: [Topic or Question]
CONTENT: Detailed table, extended data, formulas, references
NOTE: "Backup slide—not presented, available for Q&A"
```

**Example Backup Slides**:
- Detailed brewing ratio chart (1:15 to 1:18)
- Equipment comparison matrix (10 grinder models)
- Troubleshooting guide (problem → likely cause → fix)
- Methodology: How we measured extraction % and flavor scores
- References & Further Reading

---

## Micro-Templates (Quick Patterns for Specific Data Types)

### A. Comparison (A vs B)

| Feature | Option A | Option B | Winner |
|---------|----------|----------|--------|
| Cost | $X | $Y | A/B |
| Speed | Fast | Slow | A |
| Quality | Good | Excellent | B |

**Heading Example**: "Option B delivers superior quality despite higher upfront cost"

---

### B. Pyramid Summary (Key Takeaways)

```
MAIN POINT
├── Supporting Point 1
│   ├── Evidence 1a
│   └── Evidence 1b
├── Supporting Point 2
│   ├── Evidence 2a
│   └── Evidence 2b
└── Supporting Point 3
    ├── Evidence 3a
    └── Evidence 3b
```

---

### C. Process (4 Steps)

```
1️⃣ [Step 1] → 2️⃣ [Step 2] → 3️⃣ [Step 3] → 4️⃣ [Step 4] → ✅ Result
```

---

### D. KPI Dashboard

```
┌─────────────┬─────────────┬─────────────┐
│ Metric 1    │ Metric 2    │ Metric 3    │
│ 85% ↑       │ $1.2M ↓     │ 4.2/5 →     │
│ vs. 78% LY  │ vs. $1.5M   │ flat        │
└─────────────┴─────────────┴─────────────┘
```

**Heading Example**: "Customer satisfaction rose 7 points while costs dropped 20%"

---

### E. Geographic / Regional Distribution

**Visual**: Choropleth map or bar chart by region

**Heading Example**: "West Coast accounts for 60% of premium coffee sales"

---

### F. Funnel (Conversion Process)

```
Stage 1: 1000 visitors
  ↓ 40% convert
Stage 2: 400 sign-ups
  ↓ 25% convert
Stage 3: 100 purchases
```

**Heading Example**: "10% end-to-end conversion beats industry average by 3 points"

---

### G. Pareto (80/20)

**Visual**: Bar chart (descending) + cumulative line overlay

**Heading Example**: "Top 3 issues account for 80% of customer complaints"

---

### H. Sensitivity / Scenario Analysis

| Scenario | Assumption 1 | Assumption 2 | Result |
|----------|--------------|--------------|--------|
| Best Case | High | Low | $500K |
| Base Case | Medium | Medium | $300K |
| Worst Case | Low | High | $100K |

**Heading Example**: "Base case ROI of $300K remains positive even in worst-case scenario"

---

### I. Cost Structure (Waterfall)

```
Starting Value: $1000
- Cost A: -$200
- Cost B: -$150
- Cost C: -$100
+ Revenue: +$600
= Final Value: $1150
```

**Visual**: Waterfall chart showing cumulative impact

---

### J. Contribution (Stacked Bar/Area)

**Visual**: Stacked bar or area chart showing each component's contribution to total

**Heading Example**: "Product A contributes 55% of total revenue despite being only 30% of units sold"

---

## Template Selection Decision Tree

**Use this decision tree to pick the right template**:

1. **Is this the first or last slide?**
   - First → Cover Slide (Template 1)
   - Last → Conclusion & CTA (Template 13)

2. **Are you introducing the structure?**
   - Yes → Table of Contents (Template 2)

3. **Are you explaining why something matters?**
   - Problem → Problem Statement (Template 3)
   - Opportunity → Opportunity/Goal (Template 4)

4. **Are you presenting the solution approach?**
   - Yes → Solution Overview (Template 5)

5. **Are you showing evidence?**
   - Comparing options → Comparison (Template 6)
   - Showing trend → Trend Over Time (Template 7)
   - Explaining process → Process/Steps (Template 8)
   - Breaking down data → Data Breakdown (Template 9)

6. **Are you addressing concerns?**
   - Yes → Risk & Mitigation (Template 10)

7. **Are you showing proof?**
   - Yes → Case Study (Template 11)

8. **Are you showing timeline?**
   - Yes → Roadmap/Timeline (Template 12)

9. **Is this extra detail for Q&A?**
   - Yes → Backup Slides (Template 14)

---

## Best Practices

1. **Consistency**: Use the same template for similar slide types throughout the deck
2. **Hierarchy**: Maintain consistent visual hierarchy (heading > subheading > body > footer)
3. **White Space**: Don't fill every pixel—leave breathing room (see STYLE-GUIDE.md)
4. **One Idea**: Each slide conveys exactly one testable assertion
5. **Evidence-First**: Body content supports the heading assertion with visuals/data, not long text
6. **Accessibility**: All templates must meet WCAG AA contrast requirements (see STYLE-GUIDE.md)

---

**Next Steps**: Once you've selected templates for all slides, proceed to Stage 4 (Evidence & Charts) in WORKFLOW.md.
