# Theoretical Background and References

This document provides the theoretical foundations for the try-first-tell-later pedagogical approach, drawing from multiple research traditions in learning sciences.

## Overview

Try-first-tell-later integrates insights from:
- **Productive Failure**: Benefits of struggling before instruction
- **Testing Effect / Retrieval Practice**: Learning through attempted recall
- **Variation Theory**: Learning through discernment of critical aspects via patterns of variation and invariance
- **Socratic Method**: Learning through questioning and dialogue

## Productive Failure

### Core Concept

**Productive Failure** is the finding that engaging learners in problem-solving before receiving instruction produces better learning outcomes than traditional instruction-first approaches, even when initial attempts are unsuccessful.

Kapur (2008) defines productive failure as "a learning design that affords learners opportunities to generate and explore representations and solution methods (RSMs) for solving complex, novel problems... The failure to generate the canonical solution is thus productive."

### Key Findings

**1. Struggle Before Structure**
- Students who attempt to solve problems before instruction develop deeper understanding than those who receive instruction first
- The struggle activates relevant prior knowledge and reveals gaps
- Initial failure is not just acceptable—it's beneficial for learning

**2. Knowledge Assembly and Differentiation**
- Attempting problems helps learners assemble, organize, and differentiate their prior knowledge
- This prepares them to understand and appreciate the subsequent instruction
- Creates awareness of what they don't know

**3. Delayed Performance, Enhanced Learning**
- Students in productive failure conditions may perform worse on immediate tests
- But they show superior performance on delayed tests and transfer tasks
- The initial struggle leads to more robust, flexible knowledge

### Application to Try-First-Tell-Later

When we ask students to predict, design, or reason before providing explanations:
- We create productive failure opportunities
- Students activate and test their prior knowledge
- The subsequent explanation is better understood because students know what they need to learn
- The contrast between their attempt and the expert solution highlights critical aspects

### Key References

- Kapur, M. (2008). Productive failure. *Cognition and Instruction*, 26(3), 379-424.
  - Foundational paper introducing the concept
  - Demonstrates benefits in mathematics learning

- Kapur, M., & Bielaczyc, K. (2012). Designing for productive failure. *Journal of the Learning Sciences*, 21(1), 45-83.
  - Design principles for productive failure interventions
  - Discusses when and how to implement productive failure

- Kapur, M. (2014). Productive failure in learning math. *Cognitive Science*, 38(5), 1008-1022.
  - Meta-analysis showing robustness of the effect
  - Explores mechanisms underlying productive failure

- Kapur, M., & Bielaczyc, K. (2012). Designing for productive failure. *Journal of the Learning Sciences*, 21(1), 45-83.

## Testing Effect / Retrieval Practice

### Core Concept

The **Testing Effect** (also called **Retrieval Practice**) is the finding that actively retrieving information from memory produces better long-term retention than passive study, even when retrieval is unsuccessful.

Attempting to recall or use information strengthens memory more effectively than re-reading or reviewing.

### Key Findings

**1. Retrieval Strengthens Memory**
- The act of retrieving information from memory changes the memory itself
- Makes the information more accessible in the future
- Creates more robust, durable learning than passive re-exposure

**2. Testing Before Learning**
- Even unsuccessful retrieval attempts benefit subsequent learning
- Pre-testing (testing before material is taught) improves learning of subsequently presented material
- Creates "retrieval effort" that enhances encoding

**3. Desirable Difficulties**
- Making learning harder (within appropriate bounds) can make it better
- Retrieval practice is "desirably difficult"—challenging but beneficial
- Students often underestimate the value because it feels harder than passive review

**4. Transfer Benefits**
- Retrieval practice doesn't just help you remember what you practiced
- Enhances ability to apply knowledge in new contexts
- Promotes deeper processing and organization of knowledge

### Application to Try-First-Tell-Later

When we prompt students to predict or attempt before explaining:
- We create retrieval opportunities (students must access relevant prior knowledge)
- Even failed predictions trigger retrieval processes
- The attempted retrieval primes students for the incoming information
- Comparing prediction with answer creates additional encoding opportunities

### Key References

- Roediger, H. L., & Karpicke, J. D. (2006). Test-enhanced learning: Taking memory tests improves long-term retention. *Psychological Science*, 17(3), 249-255.
  - Seminal demonstration of the testing effect
  - Shows testing is more effective than repeated study

- Karpicke, J. D., & Roediger, H. L. (2008). The critical importance of retrieval for learning. *Science*, 319(5865), 966-968.
  - Further evidence for retrieval practice
  - Challenges common study strategies

- Bjork, R. A., & Bjork, E. L. (2011). Making things hard on yourself, but in a good way: Creating desirable difficulties to enhance learning. In M. A. Gernsbacher et al. (Eds.), *Psychology and the real world* (pp. 56-64). Worth Publishers.
  - Framework of desirable difficulties
  - Explains why harder learning can be better learning

- Richland, L. E., Kornell, N., & Kao, L. S. (2009). The pretesting effect: Do unsuccessful retrieval attempts enhance learning? *Journal of Experimental Psychology: Applied*, 15(3), 243-257.
  - Shows benefits of retrieval attempts before learning
  - Directly relevant to try-first approach

- Kornell, N., Hays, M. J., & Bjork, R. A. (2009). Unsuccessful retrieval attempts enhance subsequent learning. *Journal of Experimental Psychology: Learning, Memory, and Cognition*, 35(4), 989-998.

## Variation Theory of Learning

### Core Concept

**Variation Theory**, developed by Ference Marton and colleagues, proposes that learning occurs through discernment of critical aspects of what is to be learned. Discernment requires experiencing variation in one dimension against a background of invariance in others.

Marton's principle: "To learn something, the learner must discern what is to be learned. Discerning the object of learning amounts to discerning its critical aspects" (Marton & Pang, 2006).

### Key Concepts

**1. Object of Learning**
- What is to be learned
- Can be a concept, skill, relationship, principle, etc.

**2. Critical Aspects**
- The features that must be discerned for understanding to occur
- What makes this concept different from similar concepts
- What varies while other aspects remain invariant

**3. Necessary Condition for Learning**
- Learners must experience **variation in a dimension corresponding to a critical aspect**
- This variation must occur **against a background of invariance** in other aspects
- "When some aspect of a phenomenon or an event varies while another aspect or other aspects remain invariant, the varying aspect will be discerned"

### Four Patterns of Variation

**1. Contrast**
- Experiencing what something is versus what it is not
- Makes learners aware that an aspect exists
- Example: Show tall vs. short object to discern height

**2. Separation**
- Isolating critical features from the whole
- Varying one aspect while holding others constant
- Example: Vary only resistance to show its effect in circuits

**3. Generalization**
- Same critical aspect across different contexts
- Invariance of pattern despite variation in appearance
- Example: Same mathematical principle in different problem types

**4. Fusion**
- Experiencing multiple critical aspects simultaneously
- Varying several aspects at once to see interrelationships
- Example: Vary both voltage and resistance to understand Ohm's law

### Application to Try-First-Tell-Later

Try-first-tell-later creates powerful variation patterns:

**Student Prediction → Expert Explanation** creates contrast:
- **Variant**: The understanding/approach
- **Invariant**: The problem/concept
- **Discernment**: Critical aspects of expert approach vs. naive approach

**Multiple attempts → Canonical solution** creates separation:
- **Variant**: Different solution strategies
- **Invariant**: Problem requirements
- **Discernment**: What makes the canonical solution effective

**Try across contexts** creates generalization:
- **Variant**: Context/application
- **Invariant**: Underlying principle
- **Discernment**: The general pattern

The approach is particularly powerful because it creates **double contrast**:
1. First contrast: Student's known approaches vs. new problem (during attempt)
2. Second contrast: Student's approach vs. expert knowledge (during explanation)

This double contrast enhances discernment of critical aspects.

### Key References

- Marton, F., & Booth, S. (1997). *Learning and Awareness*. Mahwah, NJ: Lawrence Erlbaum.
  - Foundational book on variation theory
  - Phenomenographic research basis

- Marton, F., & Pang, M. F. (2006). On Some Necessary Conditions of Learning. *Journal of the Learning Sciences*, 15(2), 193-220.
  - Defines the necessary conditions for learning
  - Explains the four patterns of variation

- Marton, F. (2015). *Necessary Conditions of Learning*. London: Routledge.
  - Comprehensive treatment of variation theory
  - Many educational examples

- Marton, F., & Tsui, A. (2004). *Classroom discourse and the space of learning*. Mahwah, NJ: Lawrence Erlbaum.
  - Application to classroom teaching
  - Analysis of how teachers create spaces of learning

- Runesson, U. (2006). What is it possible to learn? On variation as a necessary condition for learning. *Scandinavian Journal of Educational Research*, 50(4), 397-410.
  - Clear explanation of how variation enables learning
  - Classroom examples

## The Socratic Method

### Core Concept

The **Socratic Method** is a form of inquiry-based teaching where learning occurs through questioning and dialogue rather than direct transmission of knowledge. Named after the Greek philosopher Socrates, who used systematic questioning to help students discover knowledge themselves.

### Key Principles

**1. Learning Through Questioning**
- Knowledge is developed through careful questioning
- Questions guide students to discover answers themselves
- Teacher acts as facilitator rather than information provider

**2. Eliciting Prior Knowledge**
- Questions activate what students already know
- Makes implicit knowledge explicit
- Reveals gaps and misconceptions

**3. Examining Assumptions**
- Questions probe the foundations of beliefs
- Encourages critical thinking
- Reveals hidden assumptions and contradictions

**4. Progressive Questioning**
- Builds from simple to complex
- Each answer leads to deeper questions
- Scaffolds understanding through dialogue

### Types of Socratic Questions

1. **Clarification questions**: "What do you mean by...?"
2. **Probing assumptions**: "What are you assuming here?"
3. **Probing reasons and evidence**: "Why do you think that?"
4. **Viewpoint questions**: "What would be an alternative?"
5. **Probing implications**: "What would happen if...?"
6. **Questions about the question**: "Why is this question important?"

### Application to Try-First-Tell-Later

Try-first-tell-later is a modern implementation of Socratic principles:

- **Questions before answers**: Ask students to think before telling them
- **Activating prior knowledge**: Prompts engage existing understanding
- **Revealing assumptions**: Design and reasoning prompts expose implicit beliefs
- **Progressive understanding**: Sequence of prompts builds understanding
- **Critical thinking**: Comparison and reflection prompts encourage evaluation

The key difference from classical Socratic method:
- Socratic: Entirely through dialogue, no direct instruction
- Try-first-tell-later: Questions followed by direct explanation
- Try-first-tell-later works better for complex technical material where pure discovery is inefficient

### Key References

- Paul, R., & Elder, L. (2007). *The Thinker's Guide to the Art of Socratic Questioning*. Foundation for Critical Thinking.
  - Practical guide to Socratic questioning
  - Types and purposes of questions

- Overholser, J. C. (1992). Socrates in the classroom. *College Teaching*, 40(1), 14-19.
  - Application to modern education
  - Benefits and challenges

- Reich, R. (2003). The Socratic Method: What it is and how to use it in the classroom. *Speaking of Teaching*, 13(1), 1-4.
  - Clear explanation for teachers
  - Practical implementation advice

## Integration of Theoretical Perspectives

Try-first-tell-later powerfully integrates these four theoretical traditions:

### From Productive Failure
- **Design principle**: Create opportunities for struggle before instruction
- **Mechanism**: Activates and organizes prior knowledge
- **Benefit**: Better prepared to understand subsequent explanation

### From Testing Effect
- **Design principle**: Require retrieval before presenting information
- **Mechanism**: Retrieval processes strengthen memory and encoding
- **Benefit**: Information is better remembered and more accessible

### From Variation Theory
- **Design principle**: Create patterns of variation that enable discernment
- **Mechanism**: Contrast between attempt and explanation reveals critical aspects
- **Benefit**: Students discern what makes expert knowledge effective

### From Socratic Method
- **Design principle**: Use questions to guide discovery
- **Mechanism**: Questions activate thinking and reveal understanding
- **Benefit**: Active learning rather than passive reception

### Synergistic Effects

These traditions reinforce each other:

1. **Questions create retrieval opportunities** (Socratic → Testing Effect)
2. **Retrieval activates knowledge for productive struggle** (Testing → Productive Failure)
3. **Struggle reveals what varies vs. what's invariant** (Productive Failure → Variation Theory)
4. **Variation patterns guide question design** (Variation Theory → Socratic)

The try-first-tell-later approach doesn't just apply one theory—it creates a unified pedagogical framework that leverages all four traditions simultaneously.

## Evidence Base

### Meta-Analyses and Reviews

- **Testing Effect**: Multiple meta-analyses confirm robust benefits across ages, materials, and contexts (Rowland, 2014; Adesope et al., 2017)

- **Productive Failure**: Shows consistent benefits, particularly for conceptual understanding and transfer (Kapur, 2014)

- **Variation Theory**: Applied successfully in multiple countries and subjects, particularly mathematics (Pang & Marton, 2003; Häggström, 2008)

### Boundary Conditions

**When try-first-tell-later works best**:
- Students have some relevant prior knowledge to activate
- Problems are challenging but not impossible
- Clear explanation follows the attempt
- The contrast between attempt and solution is made explicit

**When to be cautious**:
- Completely novel domains with no prior knowledge base
- Extremely complex material where struggle would be overwhelming
- When time is severely limited
- When frustration tolerance is low

### Open Questions

Research continues on:
- Optimal difficulty level for attempts
- How much scaffolding to provide during attempt phase
- Best ways to structure the follow-up explanation
- Individual differences in response to this approach
- Transfer effects to real-world problem solving

## Additional References

### Productive Failure

- Loibl, K., Roll, I., & Rummel, N. (2017). Towards a theory of when and how problem solving followed by instruction supports learning. *Educational Psychology Review*, 29(4), 693-715.

- DeCaro, M. S., & Rittle-Johnson, B. (2012). Exploring mathematics problems prepares children to learn from instruction. *Journal of Experimental Child Psychology*, 113(4), 552-568.

### Testing Effect / Retrieval Practice

- Adesope, O. O., Trevisan, D. A., & Sundararajan, N. (2017). Rethinking the use of tests: A meta-analysis of practice testing. *Review of Educational Research*, 87(3), 659-701.

- Rowland, C. A. (2014). The effect of testing versus restudy on retention: a meta-analytic review of the testing effect. *Psychological Bulletin*, 140(6), 1432-1463.

- Butler, A. C. (2010). Repeated testing produces superior transfer of learning relative to repeated studying. *Journal of Experimental Psychology: Learning, Memory, and Cognition*, 36(5), 1118-1133.

### Variation Theory

- Pang, M. F., & Marton, F. (2003). Beyond "lesson study": Comparing two ways of facilitating the grasp of some economic concepts. *Instructional Science*, 31(3), 175-194.

- Häggström, J. (2008). Teaching systems of linear equations in Sweden and China: What is made possible to learn? *Göteborg Studies in Educational Sciences*, 266.

- Lo, M. L. (2012). *Variation theory and the improvement of teaching and learning*. Göteborg: Acta Universitatis Gothoburgensis.

### Socratic Method / Questioning

- Boghossian, P. (2012). *Socratic pedagogy: Perplexity, humiliation, shame and a broken egg*. *Educational Philosophy and Theory*, 44(7), 710-720.

- Cotton, K. (1988). *Classroom questioning*. North West Regional Educational Laboratory.

- Chin, C. (2006). Classroom interaction in science: Teacher questioning and feedback to students' responses. *International Journal of Science Education*, 28(11), 1315-1346.

## Conclusion

The try-first-tell-later approach is grounded in multiple converging lines of research showing that:

1. **Attempting before learning** (productive failure) prepares students to understand instruction
2. **Retrieving before presenting** (testing effect) strengthens memory and learning
3. **Creating variation patterns** (variation theory) enables discernment of critical aspects
4. **Questioning before telling** (Socratic method) activates thinking and reveals understanding

These principles combine to create a powerful pedagogical approach that consistently produces deeper, more durable learning than traditional tell-first methods.

The research base is robust, spanning multiple decades, disciplines, and educational contexts. While questions remain about optimal implementation, the fundamental effectiveness of engaging learners' thinking before providing explanations is well-established.
