# Competitor Analysis Guide

## Analysis Workflow

### Step 1: Identify Competitors

**Direct Competitors**
- Same functionality
- Same target audience
- Same platform(s)

**Indirect Competitors**
- Solve similar problem differently
- Adjacent features
- Partial overlap

**Aspirational Competitors**
- Top apps in category
- Leaders in space
- Apps to learn from

### Step 2: Data Collection Process

For each competitor, gather:

1. **Basic Info**
   - App name and subtitle
   - Developer name
   - Category and sub-categories
   - Price and monetization model

2. **ASO Elements**
   - Full app title (note keyword placement)
   - Subtitle/short description
   - First 200 characters of description
   - Visual style (icon, screenshots)

3. **Performance Indicators**
   - Current ranking in relevant categories
   - Number of ratings
   - Average rating
   - Number of reviews
   - Last update date

4. **Keyword Analysis**
   - Keywords visible in metadata
   - Recurring themes across competitors
   - Unique positioning angles

### Step 3: Web Search Strategy

Use web_search tool to find:

**Search Patterns:**
1. `"app name" site:apps.apple.com` → Direct App Store link
2. `"app name" review` → Professional reviews (keywords mentioned)
3. `"best [category] apps"` → Listicles with top apps
4. `"[category] app keywords"` → ASO discussions
5. `site:apps.apple.com [category]` → Similar apps in category

**What to Extract:**
- How reviewers describe the app (natural keywords)
- Features they highlight
- User problems it solves
- Comparisons to other apps

### Step 4: Keyword Gap Analysis

Compare your keyword set vs competitors:

1. **Common Keywords**: What everyone uses (table stakes)
2. **Unique Keywords**: What only you could/should use
3. **Missing Keywords**: What competitors use that you don't
4. **Opportunity Keywords**: High-value keywords underutilized by competitors

### Step 5: Positioning Analysis

Identify each competitor's:
- **Primary value proposition** (what they lead with)
- **Key differentiators** (what makes them unique)
- **Target user** (who they're for)
- **Tone/brand** (how they communicate)

Find gaps:
- Underserved user segments
- Unemphasized features
- Different positioning angles

## Competitive Intelligence Template

```
COMPETITOR: [App Name]

Basic Info:
- Subtitle: [text]
- Category: [primary] / [secondary]
- Price: [free/paid/freemium]

ASO Keywords Identified:
- In Title: [keywords]
- In Subtitle: [keywords]  
- Inferred from description: [keywords]

Rankings:
- Category rank: #[X] in [Category]
- Keyword rankings: [list if known]

Performance:
- Ratings: [X.X] stars ([Y] ratings)
- Last updated: [date]
- Update frequency: [estimate]

Positioning:
- Main value prop: [one sentence]
- Key features emphasized: [list]
- Target audience: [description]
- Unique angle: [what sets them apart]

Strengths (vs our app):
- [what they do better]

Weaknesses (vs our app):
- [what we do better]

Keyword Opportunities:
- [keywords they use that we should consider]

Visual Strategy:
- Icon style: [description]
- Screenshot approach: [description]
```

## Analyzing Search Results

When using web_search for competitor research:

### App Store Listings
Look for:
- Exact title and subtitle text
- Category placements
- Screenshot sequences
- What features are highlighted

### Review Sites & Blogs
Extract:
- How they describe the app (natural language keywords)
- Common user complaints (gaps to fill)
- Praised features (what matters to users)
- Comparison points (how it's positioned vs others)

### "Best of" Lists
Identify:
- Which apps consistently appear
- How they're described in comparisons
- What criteria matter most
- Emerging trends in the category

## Competitive Keyword Extraction

From competitor analysis, create:

### Keyword Inventory
All keywords found across competitors, categorized:
- **Universal** (90%+ of competitors use)
- **Common** (50-90% use)
- **Occasional** (10-50% use)
- **Rare** (< 10% use)

### Strategic Decisions
- **Adopt**: Common keywords you're missing
- **Differentiate**: Avoid oversaturated keywords, find alternatives
- **Own**: Unique keywords that fit your strengths
- **Ignore**: Irrelevant keywords despite competitor usage

## Red Flags

Avoid copying if you see:
- Keyword stuffing (unnatural text)
- Trademark violations
- Misleading claims
- Irrelevant keywords (likely not working)

## Ongoing Monitoring

Set up periodic checks (monthly):
- Changes to competitor metadata
- New competitors entering space
- Ranking changes
- Feature additions/removals
- Visual refresh patterns

Use findings to:
- Update your keywords
- Adjust positioning
- Identify feature gaps
- Stay ahead of trends
