# Keyword Research Strategies

## Keyword Generation Methods

### 1. Semantic Analysis
From app description, extract:
- **Core functionality verbs**: edit, track, manage, create, share
- **Feature nouns**: photo, video, document, task, budget
- **User problems**: organize, save time, simplify, improve
- **User goals**: learn, achieve, monitor, discover

### 2. User Intent Mapping

**Navigational Intent** (looking for specific app type)
- "[category] app" (e.g., "photo editor app")
- "best [category]" (e.g., "best budget tracker")
- "[specific need]" (e.g., "remove background from photo")

**Informational Intent** (learning/comparing)
- "how to [action]" (e.g., "how to edit photos")
- "[action] tutorial"
- "learn [skill]"

**Transactional Intent** (ready to download)
- "free [category] app"
- "[specific feature]" (e.g., "batch photo editor")
- "[problem] solution"

### 3. Keyword Expansion Techniques

**Synonym Expansion**
- photo → picture, image, pic, snapshot
- edit → modify, adjust, enhance, retouch
- track → monitor, log, record, measure

**Related Concepts**
- photo editor → filters, effects, collage, beauty, selfie
- budget tracker → expense, finance, money, savings

**Feature-Based**
- Core features → specific tools/capabilities
- Example: "video editor" → "trim video", "add music", "transitions"

**Problem-Solution**
- User pain points → your solution
- Example: "blurry photos" → "photo enhancer"

### 4. Competitive Keyword Mining

Look for in competitor apps:
- Keywords in their title/subtitle
- Features they emphasize
- Categories they rank in
- Common words across top 10 apps

### 5. Long-Tail Keyword Strategy

Pattern: [modifier] + [core keyword] + [qualifier]
- "free photo editor for instagram"
- "easy budget tracker with receipt scanner"
- "professional video editor for beginners"

Benefits:
- Less competition
- Higher conversion (more specific intent)
- Easier to rank

## Keyword Prioritization Framework

### Scoring Dimensions
1. **Relevance** (1-10): How well keyword matches app functionality
2. **Volume** (1-10): Estimated search volume
3. **Competition** (1-10): Number of apps targeting keyword (inverse score)
4. **Conversion Potential** (1-10): Likelihood to convert searchers

### Priority Formula
Score = (Relevance × 0.4) + (Volume × 0.2) + (Competition × 0.2) + (Conversion × 0.2)

### Keyword Tiers
- **Tier 1** (Score 8-10): Primary keywords for title/subtitle
- **Tier 2** (Score 6-7.9): Secondary keywords for keyword field
- **Tier 3** (Score 4-5.9): Long-tail for description

## Category-Specific Keyword Patterns

### Photo/Video Apps
- Core: edit, filter, effects, collage, camera
- Actions: crop, resize, rotate, enhance, retouch
- Styles: vintage, professional, artistic, beauty
- Formats: instagram, portrait, landscape

### Productivity Apps
- Core: organize, manage, track, plan, note
- Actions: schedule, remind, sync, share, collaborate
- Benefits: simple, easy, fast, efficient, smart
- Targets: work, personal, team, project, daily

### Finance Apps
- Core: budget, expense, money, finance, savings
- Actions: track, manage, analyze, plan, invest
- Benefits: secure, simple, automated, smart
- Targets: personal, family, business, bills

### Health & Fitness Apps
- Core: workout, fitness, health, exercise, diet
- Actions: track, monitor, plan, achieve, improve
- Benefits: personalized, effective, easy, quick
- Targets: weight, muscle, cardio, nutrition

### Education Apps
- Core: learn, study, practice, master, improve
- Actions: teach, train, quiz, test, memorize
- Benefits: interactive, fun, effective, engaging
- Subjects: language, math, coding, music, art

## Keyword Quality Checklist

✅ **Good Keywords:**
- Specific and descriptive
- Match actual user searches
- Relevant to app functionality
- Have search volume
- Achievable competition level

❌ **Bad Keywords:**
- Too generic ("app", "good", "best")
- Competitor brand names
- Irrelevant to app
- No search volume
- Impossible to rank for

## Multi-Language Considerations

### Translation Approaches

**Option 1: Direct Translation**
- Translate keywords literally
- Works for: Universal concepts, features
- Example: "photo editor" → "editor de fotos" (ES)

**Option 2: Localized Search Behavior**
- Research how locals search
- May use different terms
- Example: "autumn" (US) vs "fall" (US) vs "autumn" (UK)

**Option 3: Cultural Adaptation**
- Adapt to local preferences/needs
- Consider regional differences
- Example: Different popular app categories per region

### Testing Strategy
1. Start with direct translations
2. Monitor performance per locale
3. Research local top apps
4. Adjust based on data
5. A/B test variations
