theme: Zurich, 1
footer: Visual Storytelling
slidenumbers: true

---

[.background-color: #1a1a1a]
[.text: #ffffff]

# Visual Storytelling
## The Art of Image-Driven Presentations

### A Deckset Showcase

---

## Why Visual Presentations?

Research shows:
- 🧠 Brain processes images 60,000x faster than text
- 👁️ 90% of information transmitted to brain is visual
- 📊 People remember 80% of what they see
- 📖 Only 20% of what they read

^ Emphasize the power of visual communication
^ Reference studies if asked
^ This sets up why we focus on images

---

## Planning Your Visual Story

1. **Define your message** - What's the core idea?
2. **Find great images** - Quality matters
3. **Create flow** - Visual narrative arc
4. **Balance text and images** - Less text, more impact
5. **Practice transitions** - Smooth storytelling

^ Each presentation needs a clear narrative
^ Images should support, not distract

---

![](https://images.unsplash.com/photo-1451187580459-43490279c0fa?w=2000)

# [fit] Technology
# [fit] Shapes Our Future

^ Full-screen background image example
^ Note: Replace with actual local image paths
^ Text overlays work great on dark images

---

![left](https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=1200)

## Data Visualization

Modern tools allow us to:
- Transform complex data
- Reveal hidden patterns
- Tell compelling stories
- Drive decision-making

^ Left-aligned image example
^ Content appears on the right side
^ Great for before/after comparisons

---

![right filtered](https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=1200)

## Analytics Matter

**Key Metrics:**
- User engagement: +45%
- Conversion rate: +32%
- Customer satisfaction: 4.8/5
- Revenue growth: +28%

^ Right-aligned image with filter
^ Numbers stand out on simple backgrounds

---

## Image Composition

![inline fill](https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800)![inline fill](https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=800)

^ Two images side by side
^ Perfect for comparisons
^ Can show before/after, A/B testing, etc.

---

## Image Grid Layout

![inline fill](https://images.unsplash.com/photo-1557804506-669a67965ba0?w=600)![inline fill](https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=600)
![inline fill](https://images.unsplash.com/photo-1521737711867-e3b97375f902?w=600)![inline fill](https://images.unsplash.com/photo-1522202176988-66273c2fd55f?w=600)

^ Four images in a grid
^ Great for showcasing team, products, or features
^ Keep images consistent in style

---

![](https://images.unsplash.com/photo-1519389950473-47ba0277781c?w=2000)

## [fit] Collaboration
## [fit] Drives Innovation

^ Dark image with light text overlay
^ [fit] ensures text scales appropriately
^ Creates dramatic impact

---

## Custom Image Sizing

![inline 40%](https://images.unsplash.com/photo-1551650975-87deedd944c3?w=600)

Control image size with percentage modifiers:
- `![inline 25%]` - Quarter size
- `![inline 50%]` - Half size
- `![inline 75%]` - Three-quarters
- `![inline fill]` - Fill available space

^ Precise control over image dimensions
^ Useful for logos and icons

---

## Rounded Corners

![inline corner-radius(32)](https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=600)

Add rounded corners to soften the look:

```markdown
![inline corner-radius(16)](image.jpg)
```

^ Modern, friendly aesthetic
^ Great for profile pictures or UI screenshots

---

![left](https://images.unsplash.com/photo-1512295767273-ac109ac3acfa?w=1200)

## Product Showcase

**Features:**
- 🎯 Intuitive interface
- ⚡ Lightning fast
- 🔒 Secure by design
- 🌍 Global reach

^ Product images on left, features on right
^ Icons add visual interest to text
^ Keep bullet points short

---

## Video Integration

Videos can be embedded directly:

```markdown
![](demo.mp4)
![autoplay loop](background.mp4)
```

**Options:**
- `autoplay` - Start automatically
- `loop` - Repeat continuously
- `mute` - Silence audio

^ Videos must be local files
^ Keep videos short (under 30 seconds)
^ Test playback before presenting

---

[.column]

## Left Column

Content for the left side:
- Statistics
- Benefits
- Features

[.column]

![inline](https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=600)

^ Two-column layout with mixed content
^ Text left, image right
^ Great for detailed explanations

---

![](https://images.unsplash.com/photo-1522071901873-411886a10004?w=2000)

# Customer Success Story

> "This solution transformed our workflow and increased productivity by 3x."

**— Sarah Johnson, CEO**

^ Quote overlay on background image
^ Testimonials are powerful with visuals
^ Use high-quality professional photos

---

## Before & After

![inline fill](https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?w=800)![inline fill](https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800)

**Before:** Manual processes
**After:** Automated workflow

^ Visual proof of improvement
^ Side-by-side comparison is compelling

---

## Image Best Practices

**Do:**
- ✅ Use high-resolution images (1920x1080+)
- ✅ Maintain consistent style
- ✅ Optimize file sizes (keep under 5MB)
- ✅ Use meaningful images that support your message

**Don't:**
- ❌ Use low-quality or pixelated images
- ❌ Mix incompatible styles
- ❌ Overload slides with too many images
- ❌ Use images just for decoration

^ Quality over quantity always
^ Every image should serve a purpose

---

## Finding Great Images

**Free resources:**
- Unsplash - unsplash.com
- Pexels - pexels.com
- Pixabay - pixabay.com

**Premium:**
- Adobe Stock
- Shutterstock
- Getty Images

^ Always check licensing
^ Give attribution when required

---

## Mermaid Diagrams

```mermaid
graph LR
    A[Idea] -->|Design| B[Prototype]
    B -->|Test| C[Feedback]
    C -->|Refine| B
    B -->|Launch| D[Product]
    D -->|Analyze| E[Insights]
    E -->|Iterate| A
```

^ Diagrams are visual too!
^ Great for processes and flows
^ Auto-generated from text

---

## Timeline Visualization

```mermaid
gantt
    title Product Roadmap
    dateFormat  YYYY-MM-DD
    section Phase 1
    Research           :2024-01-01, 30d
    Design            :2024-02-01, 45d
    section Phase 2
    Development       :2024-03-15, 60d
    Testing           :2024-05-15, 30d
    section Phase 3
    Launch            :2024-06-15, 7d
```

^ Gantt charts from markdown
^ Perfect for project timelines

---

![](https://images.unsplash.com/photo-1504384308090-c894fdcc538d?w=2000)

[.text: #ffffff]

# Visual Hierarchy

## Use Size
## And Position
### To Guide Attention

^ Demonstrate visual hierarchy
^ Larger text draws the eye first
^ Strategic placement matters

---

## Color and Mood

[.background-color: #FF6B6B]
[.text: #ffffff]

### Energetic & Bold

---

## Color and Mood

[.background-color: #4ECDC4]
[.text: #ffffff]

### Calm & Professional

---

## Color and Mood

[.background-color: #95E1D3]
[.text: #2C3E50]

### Fresh & Modern

^ Colors evoke emotions
^ Choose palettes that match your message
^ Be consistent throughout

---

## Contrast is Key

![](https://images.unsplash.com/photo-1451187580459-43490279c0fa?w=2000)
[.text: #ffffff, alignment(center)]

# [fit] Light Text on Dark Images

^ High contrast ensures readability
^ Test on projector if possible
^ Avoid busy backgrounds under text

---

## Typography Matters

# Large Heading
## Regular Heading
### Small Heading

Use heading hierarchy to create **visual rhythm** and guide the viewer's eye through your content.

^ Don't just use bold for everything
^ Proper heading levels create structure

---

## Combining Elements

![inline 50%](https://images.unsplash.com/photo-1551288049-bebda4e38f71?w=600)

**Key Metrics:**

| Quarter | Revenue | Growth |
|---------|---------|--------|
| Q1      | $2.4M   | +18%   |
| Q2      | $3.1M   | +29%   |
| Q3      | $3.8M   | +23%   |

^ Mix images, tables, and text
^ Each element supports the narrative
^ Don't overcrowd the slide

---

## Presenting Tips

1. **Arrive early** - Test image display
2. **Check colors** - Projectors vary
3. **Have backup** - PDF export ready
4. **Practice timing** - Know when images appear
5. **Tell stories** - Connect images to narrative

^ Technical preparation is crucial
^ Images lose impact if poorly displayed

---

![](https://images.unsplash.com/photo-1522071820081-009f0129c71c?w=2000)

## Remote Presentations

**Consider:**
- Screen resolution limits
- Bandwidth constraints
- Platform compatibility
- Viewer attention span

^ Virtual presentations need special care
^ Test on actual video conferencing tool

---

## Export Options

Deckset can export to:
- 📄 PDF (with presenter notes)
- 🖼️ Images (PNG/JPEG)
- 📹 Video (coming soon)

```bash
# Command line export
deckset export presentation.md
```

^ Share visual decks easily
^ PDF maintains quality

---

## Accessibility

**Make visuals accessible:**
- Use alt text (in presenter notes)
- Ensure sufficient contrast
- Don't rely solely on color
- Provide text descriptions
- Test with screen readers

^ Inclusive design reaches more people
^ Alt text in notes helps accessibility

---

![](https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?w=2000)

# [fit] Every Image
# [fit] Tells a Story

^ Choose images intentionally
^ They should enhance, not distract

---

## Final Checklist

- [ ] All images high resolution?
- [ ] Consistent visual style?
- [ ] Colors work on projector?
- [ ] File sizes optimized?
- [ ] Backup copy ready?
- [ ] Presenter notes complete?

^ Go through before presentation day
^ Prevent technical issues

---

[.hide-footer]
[.background-color: #2C3E50]
[.text: #ffffff, alignment(center)]

# Thank You

## Questions?

### Connect: @visualstoryteller

^ End with clean, simple slide
^ Make contact info visible
^ Hide footer for cleaner look
