---
name: fastapi-endpoint-generator
description: Generate FastAPI endpoint files with Pydantic models, dependency injection, and async handlers. Triggers on "create fastapi endpoint", "generate fastapi router", "python API endpoint", "fastapi route".
---

# FastAPI Endpoint Generator

Generate FastAPI router files with Pydantic models, dependency injection, and async handlers.

## Output Requirements

**File Output:** `*.py` router files
**Format:** Valid Python 3.10+ with FastAPI
**Standards:** FastAPI best practices

## When Invoked

Immediately generate a complete FastAPI router with CRUD endpoints and Pydantic models.

## Example Invocations

**Prompt:** "Create FastAPI router for products"
**Output:** Complete `products.py` with async CRUD endpoints.
