---
name: gitignore-generator
description: Generate comprehensive .gitignore files tailored to specific tech stacks, frameworks, and development environments. Triggers on "create gitignore", "generate .gitignore for", "gitignore for", "ignore files for".
---

# Gitignore Generator

Generate comprehensive `.gitignore` files tailored to specific technology stacks and development environments.

## Output Requirements

**File Output:** `.gitignore`
**Format:** One pattern per line, comments with `#`
**Structure:** Organized by category with section headers

## When Invoked

Immediately generate a complete `.gitignore` appropriate for the specified stack. Combine multiple technology patterns when multiple frameworks are mentioned.

## Pattern Syntax Reference

```bash
# Ignore specific file
filename.ext

# Ignore all files with extension
*.ext

# Ignore directory
dirname/

# Ignore files in any subdirectory
**/filename.ext

# Negate (don't ignore)
!important.ext

# Ignore in root only
/filename.ext
```

## Stack Templates

### Node.js / JavaScript / TypeScript
```gitignore
# Dependencies
node_modules/
.pnp/
.pnp.js

# Build outputs
dist/
build/
out/
.next/
.nuxt/
.output/

# Cache
.npm/
.eslintcache
.cache/
*.tsbuildinfo

# Environment
.env
.env.local
.env.*.local
.env.development
.env.test
.env.production

# Logs
logs/
*.log
npm-debug.log*
yarn-debug.log*
yarn-error.log*
pnpm-debug.log*
lerna-debug.log*

# Testing
coverage/
.nyc_output/

# IDE
.idea/
.vscode/*
!.vscode/extensions.json
!.vscode/settings.json
*.swp
*.swo
*~

# OS
.DS_Store
Thumbs.db
*.pem

# Misc
*.local
.turbo/
```

### Python
```gitignore
# Byte-compiled / optimized / DLL files
__pycache__/
*.py[cod]
*$py.class

# Virtual environments
venv/
env/
.venv/
.env/
ENV/

# Distribution / packaging
build/
dist/
eggs/
*.egg-info/
*.egg
.eggs/
wheels/
*.whl

# Installer logs
pip-log.txt
pip-delete-this-directory.txt

# Unit test / coverage
htmlcov/
.tox/
.nox/
.coverage
.coverage.*
coverage.xml
*.cover
*.py,cover
.hypothesis/
.pytest_cache/
nosetests.xml

# Type checkers
.mypy_cache/
.dmypy.json
dmypy.json
.pytype/

# Jupyter Notebooks
.ipynb_checkpoints/
*.ipynb_metadata/

# Environment
.env
.env.local
*.env

# IDE
.idea/
.vscode/
*.swp
*.swo

# OS
.DS_Store
Thumbs.db
```

### Go
```gitignore
# Binaries
*.exe
*.exe~
*.dll
*.so
*.dylib
bin/

# Test binary
*.test

# Output
/output/

# Go workspace
go.work
go.work.sum

# Dependency directories
vendor/

# IDE
.idea/
.vscode/
*.swp

# OS
.DS_Store
Thumbs.db

# Environment
.env
.env.*

# Build
dist/
```

### Java / Kotlin / Gradle
```gitignore
# Compiled class files
*.class

# Log files
*.log

# Package files
*.jar
*.war
*.nar
*.ear
*.zip
*.tar.gz
*.rar

# Build directories
build/
target/
out/

# Gradle
.gradle/
gradle-app.setting
!gradle-wrapper.jar
!gradle-wrapper.properties

# Maven
pom.xml.tag
pom.xml.releaseBackup
pom.xml.versionsBackup
pom.xml.next
release.properties
dependency-reduced-pom.xml
buildNumber.properties
.mvn/timing.properties
.mvn/wrapper/maven-wrapper.jar

# IDE - IntelliJ IDEA
.idea/
*.iws
*.iml
*.ipr
cmake-build-*/

# IDE - Eclipse
.apt_generated/
.classpath
.factorypath
.project
.settings/
.springBeans
.sts4-cache/
bin/

# IDE - NetBeans
/nbproject/private/
/nbbuild/
/dist/
/nbdist/
/.nb-gradle/

# IDE - VS Code
.vscode/

# OS
.DS_Store
Thumbs.db

# Environment
.env
```

### React / Next.js
```gitignore
# Dependencies
node_modules/
.pnp/
.pnp.js

# Testing
coverage/

# Next.js
.next/
out/

# Production
build/
dist/

# Misc
.DS_Store
*.pem

# Debug
npm-debug.log*
yarn-debug.log*
yarn-error.log*

# Local env files
.env
.env.local
.env.development.local
.env.test.local
.env.production.local

# Vercel
.vercel/

# TypeScript
*.tsbuildinfo
next-env.d.ts

# IDE
.idea/
.vscode/
```

### Rust
```gitignore
# Generated by Cargo
debug/
target/

# Remove Cargo.lock from gitignore if creating an executable
# Cargo.lock

# Backup files
**/*.rs.bk
*.pdb

# IDE
.idea/
.vscode/
*.swp

# OS
.DS_Store
Thumbs.db

# Environment
.env
```

### Docker
```gitignore
# Docker files to ignore
docker-compose*.override.yml

# Environment files (often contain secrets)
.env
.env.*
!.env.example

# Ignore build context items that shouldn't be in image
.git/
.gitignore
.dockerignore
Dockerfile*
docker-compose*
README.md
docs/
tests/
*.md

# IDE
.idea/
.vscode/

# OS
.DS_Store
Thumbs.db
```

### Full-Stack (Node + React + Docker)
```gitignore
# ========================================
# Dependencies
# ========================================
node_modules/
.pnp/
.pnp.js

# ========================================
# Build Outputs
# ========================================
dist/
build/
.next/
out/

# ========================================
# Testing & Coverage
# ========================================
coverage/
.nyc_output/
*.lcov

# ========================================
# Environment Variables
# ========================================
.env
.env.local
.env.*.local
.env.development
.env.test
.env.production
!.env.example

# ========================================
# Logs
# ========================================
logs/
*.log
npm-debug.log*
yarn-debug.log*
yarn-error.log*

# ========================================
# Cache
# ========================================
.cache/
.eslintcache
*.tsbuildinfo
.turbo/

# ========================================
# IDE & Editors
# ========================================
.idea/
.vscode/*
!.vscode/extensions.json
!.vscode/settings.json
*.swp
*.swo
*~

# ========================================
# Operating System
# ========================================
.DS_Store
.DS_Store?
._*
.Spotlight-V100
.Trashes
ehthumbs.db
Thumbs.db

# ========================================
# Docker
# ========================================
docker-compose.override.yml

# ========================================
# Database
# ========================================
*.sqlite
*.sqlite3
*.db

# ========================================
# Secrets & Keys
# ========================================
*.pem
*.key
*.crt
secrets/
.secrets/

# ========================================
# Misc
# ========================================
*.local
.temp/
tmp/
```

### Data Science / ML
```gitignore
# Byte-compiled / optimized
__pycache__/
*.py[cod]
*$py.class

# Virtual environments
venv/
env/
.venv/

# Distribution
build/
dist/
*.egg-info/

# Jupyter
.ipynb_checkpoints/
*.ipynb_metadata/

# Data files (often too large for git)
data/
datasets/
*.csv
*.parquet
*.h5
*.hdf5
!data/.gitkeep

# Model files
models/
*.pkl
*.pickle
*.joblib
*.h5
*.hdf5
*.pt
*.pth
*.onnx
*.pb
!models/.gitkeep

# Logs and outputs
logs/
outputs/
results/
mlruns/
wandb/

# Weights & Biases
wandb/

# DVC
/dvc.lock
.dvc/tmp/
.dvc/cache/

# IDE
.idea/
.vscode/
*.swp

# Environment
.env

# OS
.DS_Store
Thumbs.db
```

## Combination Logic

When multiple stacks are mentioned, combine their patterns and:
1. Deduplicate identical patterns
2. Group by category (dependencies, build, IDE, etc.)
3. Add section headers for clarity

## Validation Checklist

Before outputting, verify:
- [ ] Covers all common generated files for the stack
- [ ] Includes IDE files (.idea, .vscode)
- [ ] Includes OS files (.DS_Store, Thumbs.db)
- [ ] Environment files are ignored
- [ ] Build output directories included
- [ ] Test coverage directories included
- [ ] Has clear section headers
- [ ] No patterns that would ignore essential files

## Example Invocations

**Prompt:** "Create gitignore for a Python FastAPI project"
**Output:** Complete `.gitignore` with Python, virtualenv, testing, IDE patterns.

**Prompt:** "Generate .gitignore for Next.js TypeScript app"
**Output:** Complete `.gitignore` with Node, Next.js, TypeScript patterns.

**Prompt:** "Gitignore for Go microservice with Docker"
**Output:** Complete `.gitignore` combining Go, Docker, IDE patterns.
