---
name: nextjs-page-generator
description: Generate Next.js page components with App Router, Server Components, and data fetching. Triggers on "create nextjs page", "generate next.js route", "nextjs app router page", "next page component".
---

# Next.js Page Generator

Generate Next.js page components using App Router with Server/Client Components and data fetching.

## Output Requirements

**File Output:** `page.tsx`, `layout.tsx`, `loading.tsx`, `error.tsx`
**Format:** Valid Next.js 14 TypeScript
**Standards:** Next.js App Router conventions

## When Invoked

Immediately generate complete Next.js page files with appropriate patterns for the use case.

## Example Invocations

**Prompt:** "Create Next.js page for product listing"
**Output:** Complete `app/products/page.tsx` with Server Component data fetching.
