# Gemini Audio Reference Documentation

This directory contains comprehensive reference documentation for the Gemini Audio skill.

## Files

### [api-reference.md](./api-reference.md)
Complete API reference including:
- Audio Understanding API endpoints and methods
- Speech Generation API
- Files API for audio uploads
- Request/response formats for Python, JavaScript, Go, and REST
- Common parameters and configurations
- Error handling and rate limits
- Token counting

### [code-examples.md](./code-examples.md)
Comprehensive code examples including:
- Basic and advanced audio understanding
- Transcription with timestamps
- Audio summarization and analysis
- Speech generation examples
- Multi-file processing
- Integration patterns (Flask, batch processing)
- Production-ready implementations

### [best-practices.md](./best-practices.md)
Optimization and best practices covering:
- File management strategies
- Cost optimization techniques
- Prompt engineering for audio
- Performance optimization
- Quality guidelines
- Security best practices
- Error handling patterns

### [tts-guide.md](./tts-guide.md)
Advanced text-to-speech guide including:
- Voice control techniques
- Prompt engineering for TTS
- Style, pace, tone, and emotion control
- Multi-paragraph speech generation
- Quality optimization
- Common use cases (podcasts, audiobooks, e-learning)
- Production best practices

## Quick Navigation

**Getting Started**:
1. Start with the main [SKILL.md](../SKILL.md) for overview
2. Check [api-reference.md](./api-reference.md) for API details
3. Review [code-examples.md](./code-examples.md) for implementations

**For Audio Analysis**:
- [code-examples.md](./code-examples.md) - Audio Understanding Examples
- [best-practices.md](./best-practices.md) - Prompt Engineering section

**For Speech Generation**:
- [tts-guide.md](./tts-guide.md) - Complete TTS guide
- [code-examples.md](./code-examples.md) - Speech Generation Examples

**For Production**:
- [best-practices.md](./best-practices.md) - All sections
- [api-reference.md](./api-reference.md) - Error Handling

## External Resources

- [Official Audio Documentation](https://ai.google.dev/gemini-api/docs/audio)
- [Speech Generation Documentation](https://ai.google.dev/gemini-api/docs/speech-generation)
- [API Reference](https://ai.google.dev/api/generate-content)
- [Get API Key](https://aistudio.google.com/apikey)
