# Framework Selection Guide

This document provides detailed information about each analytical framework to help select the most appropriate one(s) for different scenarios.

## Framework Comparison Matrix

| Framework | Complexity | Time Required | Best Industry Fit | Output Type |
|-----------|-----------|---------------|-------------------|-------------|
| First Principles Thinking | High | Long | Tech, Innovation, R&D | Novel solutions, fundamental insights |
| 5 Whys | Low | Short | Manufacturing, Operations, IT | Root cause identification |
| SWOT Analysis | Medium | Medium | Business, Strategy, Marketing | Strategic assessment |
| Porter's Five Forces | Medium-High | Medium | Business, Consulting, Investment | Competitive landscape |
| Cost-Benefit Analysis | Medium | Medium | Finance, Project Management, Policy | Financial justification |
| Design Thinking | High | Long | Product, UX, Social Innovation | User-centered solutions |
| Systems Thinking | High | Long | Policy, Environment, Organizational | Systemic understanding |
| Socratic Method | Medium | Medium | Education, Philosophy, Consulting | Deep understanding |
| Pareto Analysis | Low-Medium | Short | Operations, Quality, Time Management | Prioritization list |
| MECE Principle | Medium | Short-Medium | Consulting, Strategy, Analysis | Structured breakdown |
| Hypothesis-Driven | Medium-High | Medium | Research, Data Science, Strategy | Tested hypotheses |
| Scenario Planning | High | Long | Strategy, Risk, Policy | Future scenarios |

## Detailed Framework Profiles

### 1. First Principles Thinking

**Philosophy:** Break down problems to fundamental truths and rebuild from scratch.

**Strengths:**
- Generates truly innovative solutions
- Avoids cognitive biases
- Builds deep understanding
- Challenges assumptions effectively

**Limitations:**
- Time-intensive
- Requires deep domain knowledge
- Can be overly theoretical
- May miss practical constraints

**Ideal User Profile:** Innovators, engineers, entrepreneurs, scientists

**Real-World Examples:**
- SpaceX redefining rocket costs
- Tesla rethinking battery technology
- Redesigning supply chains from scratch

### 2. 5 Whys

**Philosophy:** Ask "why" five times to reach root causes.

**Strengths:**
- Simple and quick
- No special tools needed
- Uncovers hidden causes
- Team-friendly

**Limitations:**
- May oversimplify complex issues
- Can lead to multiple root causes
- Relies on team knowledge
- May stop too early

**Ideal User Profile:** Operations managers, quality teams, process improvers

**Real-World Examples:**
- Manufacturing defect analysis
- Software bug diagnosis
- Customer complaint resolution

### 3. SWOT Analysis

**Philosophy:** Evaluate Strengths, Weaknesses, Opportunities, and Threats.

**Strengths:**
- Comprehensive overview
- Easy to understand
- Flexible application
- Good for team brainstorming

**Limitations:**
- Can be subjective
- Lacks prioritization
- Static snapshot
- May miss interconnections

**Ideal User Profile:** Business managers, strategists, project leaders

**Real-World Examples:**
- Market entry decisions
- Product launch planning
- Competitive positioning

### 4. Porter's Five Forces

**Philosophy:** Analyze competitive forces shaping industry profitability.

**Strengths:**
- Industry-level perspective
- Identifies profit potential
- Strategic positioning insights
- Well-established framework

**Limitations:**
- Industry-focused (not firm-specific)
- Static analysis
- May miss rapid changes
- Assumes competitive environment

**Ideal User Profile:** Business strategists, investors, consultants

**Real-World Examples:**
- Industry attractiveness assessment
- Competitive strategy development
- M&A evaluation

### 5. Cost-Benefit Analysis

**Philosophy:** Quantify and compare costs versus benefits.

**Strengths:**
- Objective and data-driven
- Financial clarity
- Decision justification
- Risk assessment capability

**Limitations:**
- Hard to quantify intangibles
- Assumptions can skew results
- May ignore non-financial factors
- Time value of money complexity

**Ideal User Profile:** Financial analysts, project managers, policy makers

**Real-World Examples:**
- Infrastructure investments
- Technology adoption decisions
- Policy impact assessment

### 6. Design Thinking

**Philosophy:** Human-centered, iterative approach to innovation.

**Strengths:**
- User-focused solutions
- Encourages creativity
- Iterative refinement
- Cross-functional collaboration

**Limitations:**
- Time and resource intensive
- Requires user access
- Can lack structure
- May overemphasize prototyping

**Ideal User Profile:** Product designers, UX professionals, innovation teams

**Real-World Examples:**
- App development
- Service design
- Social innovation projects

### 7. Systems Thinking

**Philosophy:** Understand how parts interact within complex systems.

**Strengths:**
- Captures complexity
- Identifies unintended consequences
- Long-term perspective
- Holistic understanding

**Limitations:**
- Very complex
- Requires specialized knowledge
- Can be overwhelming
- Hard to model accurately

**Ideal User Profile:** Policy analysts, organizational consultants, sustainability experts

**Real-World Examples:**
- Climate policy design
- Healthcare system reform
- Supply chain optimization

### 8. Socratic Method

**Philosophy:** Use questioning to explore ideas and assumptions.

**Strengths:**
- Develops critical thinking
- Challenges assumptions
- Promotes deep understanding
- Non-confrontational

**Limitations:**
- Can be slow
- Requires skilled facilitation
- May feel indirect
- Not always practical

**Ideal User Profile:** Educators, coaches, facilitators, philosophers

**Real-World Examples:**
- Executive coaching
- Team learning sessions
- Ethical deliberations

### 9. Pareto Analysis (80/20 Rule)

**Philosophy:** Focus on the 20% of causes driving 80% of effects.

**Strengths:**
- Simple prioritization
- Data-driven
- Quick results
- Resource efficient

**Limitations:**
- Requires data
- Oversimplifies complexity
- May miss important minorities
- Not always 80/20 split

**Ideal User Profile:** Operations managers, quality engineers, time managers

**Real-World Examples:**
- Defect reduction programs
- Customer complaint analysis
- Sales territory optimization

### 10. MECE Principle

**Philosophy:** Break problems into Mutually Exclusive, Collectively Exhaustive categories.

**Strengths:**
- Comprehensive coverage
- Clear structure
- Avoids overlaps
- Professional presentation

**Limitations:**
- Can be rigid
- Time-consuming to develop
- May force artificial categories
- Requires practice

**Ideal User Profile:** Consultants, analysts, strategists, presenters

**Real-World Examples:**
- Market segmentation
- Problem decomposition
- Strategic option generation

### 11. Hypothesis-Driven Analysis

**Philosophy:** Develop and test hypotheses systematically.

**Strengths:**
- Focused and efficient
- Scientific rigor
- Falsifiable
- Learns from failures

**Limitations:**
- Can miss unexpected insights
- Requires good hypotheses
- Confirmation bias risk
- Data-dependent

**Ideal User Profile:** Researchers, data scientists, strategists, investigators

**Real-World Examples:**
- Market research
- Product testing
- Business strategy validation

### 12. Scenario Planning

**Philosophy:** Develop multiple plausible future scenarios.

**Strengths:**
- Handles uncertainty well
- Strategic flexibility
- Challenges assumptions
- Team alignment

**Limitations:**
- Resource intensive
- Can create paralysis
- Subjective scenarios
- Implementation challenges

**Ideal User Profile:** Strategic planners, risk managers, executives, policy makers

**Real-World Examples:**
- Corporate strategy development
- Climate adaptation planning
- Geopolitical risk assessment

## Framework Selection Decision Tree

```
START: What is the primary goal?

├─ INNOVATE/CREATE NEW SOLUTIONS
│  ├─ Fundamental breakthrough needed? → First Principles Thinking
│  ├─ User needs unclear? → Design Thinking
│  └─ Multiple futures possible? → Scenario Planning
│
├─ DIAGNOSE PROBLEMS
│  ├─ Simple, repeated issue? → 5 Whys
│  ├─ Complex system issue? → Systems Thinking
│  └─ Need to test theories? → Hypothesis-Driven Analysis
│
├─ MAKE DECISIONS
│  ├─ Financial justification needed? → Cost-Benefit Analysis
│  ├─ Strategic assessment needed? → SWOT Analysis
│  └─ Need to prioritize? → Pareto Analysis
│
├─ UNDERSTAND COMPETITION/MARKET
│  ├─ Industry-level analysis? → Porter's Five Forces
│  ├─ Company positioning? → SWOT Analysis
│  └─ Market uncertainties? → Scenario Planning
│
├─ STRUCTURE THINKING
│  ├─ Break down complex problem? → MECE Principle
│  ├─ Challenge assumptions? → Socratic Method
│  └─ Test hypotheses? → Hypothesis-Driven Analysis
│
└─ MULTIPLE OBJECTIVES
   └─ Combine frameworks based on sub-goals
```

## Prompt Availability Status

| Framework | Prompt Title in Library | Status |
|-----------|------------------------|--------|
| First Principles Thinking | "First Principles Thinking to analyze problems" | ✅ Available |
| 5 Whys | "5 Whys method to analyze problems" | ✅ Available |
| SWOT Analysis | "SWOT to analyze problems" | ✅ Available |
| Porter's Five Forces | "Porter's Five Forces model to analyze problems" | ✅ Available |
| Cost-Benefit Analysis | "Cost-Benefit Analysis to analyze problems" | ✅ Available |
| Design Thinking | "Design Thinking to analyze problems" | ✅ Available |
| Systems Thinking | "Systems Thinking to analyze problems" | ✅ Available |
| Socratic Method | "Socratic Method to analyze problems" | ✅ Available |
| Pareto Analysis | "Pareto Analysis to analyze problems" | ✅ Available |
| MECE Principle | "MECE Principle to analyze problems" | ✅ Available |
| Hypothesis-Driven Analysis | "Hypothesis-Driven Analysis to analyze problems" | ✅ Available |
| Scenario Planning | "Scenario Planning to analyze problems" | ✅ Available |

**Note:** All 12 analytical frameworks are now fully available in your prompt-house-local library!
