# Intelligence Gathering Strategy Guide

Comprehensive guide for effective web search and information retrieval in Super Analyst 2.0.

## Core Principles

1. **Quality over Quantity** - 4-6 well-targeted searches beat 20 random ones
2. **Chinese-English Balance** - Leverage both languages
3. **Strategic Sequencing** - Start broad then narrow, or vice versa
4. **Dynamic Adjustment** - Adapt based on findings
5. **Source Diversity** - Multiple perspectives increase reliability

## Search Keyword Design

### Keyword Formulas by Information Type

**Market Size & Growth:**
```
Chinese: "[市场] 规模 2024" → "印度电商市场 规模 2024"
English: "[market] size 2024" → "India ecommerce market size 2024"
```

**Company Analysis:**
```
Chinese: "[公司] 竞争优势" → "特斯拉 竞争优势"
English: "[company] competitive advantage" → "Tesla competitive advantage"
```

**Industry Trends:**
```
Chinese: "[行业] 发展趋势 2025" → "人工智能 发展趋势 2025"
English: "[industry] trends 2025" → "AI industry trends 2025"
```

**Competitive Intelligence:**
```
Chinese: "[产品] 市场份额 排名" → "智能手机 市场份额 排名"
English: "[product] market share ranking" → "smartphone market share ranking"
```

## Chinese vs English Strategy

### Use Chinese For:
- 🇨🇳 Chinese companies (阿里巴巴, 腾讯, 比亚迪)
- 🇨🇳 Chinese market data
- 🇨🇳 Domestic industry analysis
- 🇨🇳 Local regulations and policies

### Use English For:
- 🌍 International companies (Apple, Google, Amazon)
- 🌍 Global market data
- 🌍 Academic research
- 🌍 Technology and innovation

### Use BOTH When:
- 📊 Topic has domestic + international dimensions
- 📊 Need verification from multiple sources
- 📊 Comparing perspectives

## web_search vs web_fetch

**web_search - Use for:**
- Quick overviews and statistics
- Multiple perspectives
- Current news and trends
- Initial exploration

**web_fetch - Use for:**
- Complete research reports
- Detailed analysis articles
- In-depth case studies
- Official documents

## Search Execution by Complexity

**Level 1:** 0-1 search (usually none)  
**Level 2:** 2-4 searches  
**Level 3:** 5-10 searches + 2-3 fetches

## Source Credibility Tiers

**Tier 1 - Highly Credible:**
- Official reports, government statistics
- Major research firms (McKinsey, BCG, Gartner)
- Academic journals
- Established financial media

**Tier 2 - Generally Credible:**
- Industry associations
- Reputable news outlets
- Professional research platforms

**Tier 3 - Use with Caution:**
- News aggregators
- Forums and Q&A sites
- Unverified blogs

## Quick Reference

| Goal | Pattern | Example |
|------|---------|---------|
| Market Size | [Market] + Size + Year | "India ecommerce market size 2024" |
| Growth | [Market] + Growth/CAGR | "EV market growth rate 2024-2030" |
| Market Share | [Industry] + Market Share | "smartphone market share ranking" |
| Comparison | [A] vs [B] | "Tesla vs BYD comparison" |
| Trends | [Industry] + Trends + Year | "AI industry trends 2025" |

---

For detailed strategies, see complete search-strategy-guide.md in skill package.

**Version:** 2.0 | **Last Updated:** October 2025
