# Sequential Thinking Templates for Super Analyst 2.0

Structured thinking templates for the two critical decision points.

## Overview

Super Analyst 2.0 uses Sequential Thinking at two decision points:

1. **Stage 2: Intelligence Planning** - What information to gather and how
2. **Stage 4: Framework Selection** - Which analytical frameworks to apply

## DECISION POINT #1: Intelligence Planning

### Level 2 (Medium) - 5-7 Thoughts Template

**Thought 1: Problem Information Requirements**
```
What specific information do I need to answer this question?
- [Key aspect 1] - specifically [what data/info]
- [Key aspect 2] - specifically [what data/info]  
Priority: [Essential/Important/Supplementary]
```

**Thought 2: Information Sources**
```
Where can I find this information?
- Chinese sources for: [what]
- English sources for: [what]
```

**Thought 3: Search Keywords**
```
Optimal keywords:
- Chinese: "[keywords]"
- English: "[keywords]"
```

**Thought 4: Search Sequence**
```
Order:
1. [Topic] - Foundation
2. [Topic] - Key data
3. [Topic] - Verification
```

**Thought 5: Execution Strategy**
```
- X web_search for [purpose]
- Y web_fetch if [condition]
```

### Level 3 (Complex) - 8-12 Thoughts

Extend Level 2 with:
- Multi-dimensional information mapping
- Comprehensive search plan (Phase 1/2/3)
- Quality control strategy
- Integration planning

---

## DECISION POINT #2: Framework Selection

### Level 1 (Simple) - 3-5 Thoughts Template

**Thought 1: Problem Essence**
```
This is a [diagnostic/strategic/innovative/decision/understanding] problem.
Core challenge: [what]
```

**Thought 2: Framework Matching**
```
Candidates:
1. [Framework A] - because [reason]
2. [Framework B] - because [reason]
```

**Thought 3: Information Compatibility**
```
[Framework] needs: [info types]
What I have: [available]
Fit: [Strong/Adequate/Weak]
```

**Thought 4: Confirmation**
```
Selected: [Framework]
This will provide: [outcome]
```

### Level 2 (Medium) - 5-8 Thoughts

**Additional considerations:**
- Multi-dimensional analysis
- Single vs multiple framework decision
- Application strategy (sequential/parallel)
- Focus areas for each framework

### Level 3 (Complex) - 10-15 Thoughts

**Comprehensive evaluation:**
- Framework evaluation matrix
- Multi-framework coordination design
- Trade-off analysis
- Integration strategy detail
- Quality assurance checks

---

## Example: Medium Problem

**Problem:** "Analyze Tesla's competitive advantages"

**Sequential Thinking (Intelligence Planning):**
```
Thought 1: Need Tesla's advantages + competitor comparison
Priority: Advantages essential, comparison important

Thought 2: English primary (international company)
Chinese useful for China market view

Thought 3: Keywords:
- "Tesla competitive advantage 2024"
- "特斯拉 竞争优势"
- "Tesla vs BYD comparison"

Thought 4: Sequence: Tesla first, then comparison

Thought 5: 3 web_search, possibly 1 fetch
```

**Sequential Thinking (Framework Selection):**
```
Thought 1: Competitive positioning analysis

Thought 2: SWOT best match - addresses advantages directly

Thought 3: Have good data on strengths and competitive context

Thought 4: Single framework sufficient

Thought 5: Focus on Strengths section
```

---

## Best Practices

**DO:**
- ✅ Start with clear objectives
- ✅ Consider both languages
- ✅ Plan logically
- ✅ Define success criteria

**DON'T:**
- ❌ Jump without thinking
- ❌ Over-plan (stick to thought limits)
- ❌ Ignore prioritization

---

## Thinking Depth Guide

| Level | Stage 2 | Stage 4 |
|-------|---------|---------|
| 1 | Skip | 3-5 thoughts |
| 2 | 5-7 thoughts | 5-8 thoughts |
| 3 | 8-12 thoughts | 10-15 thoughts |

---

For complete templates with detailed examples, see full sequential-thinking-prompts.md.

**Version:** 2.0 | **Last Updated:** October 2025
