# Super Analyst Usage Examples

This document provides concrete examples of how to use the Super Analyst skill with different types of problems.

## Example 1: Product Innovation

**User Request:** "We want to create a revolutionary electric vehicle battery that's both affordable and high-performance. How should we approach this?"

**Framework Selection:** First Principles Thinking + Cost-Benefit Analysis

**Approach:**
1. Use First Principles to deconstruct battery fundamentals (chemistry, energy density, materials)
2. Apply Cost-Benefit Analysis to evaluate different material/design options
3. Combine insights to identify breakthrough approaches

**Expected Output:** Novel battery design concepts with financial viability assessment

---

## Example 2: Recurring Quality Issues

**User Request:** "Our customer support keeps getting complaints about slow website load times. This has been ongoing for months."

**Framework Selection:** 5 Whys + Pareto Analysis

**Approach:**
1. Use 5 Whys to identify root cause of performance issues
2. Apply Pareto Analysis to identify which pages/components cause 80% of problems
3. Prioritize fixes based on impact

**Expected Output:** Root cause identification and prioritized fix list

---

## Example 3: Market Entry Decision

**User Request:** "Should we enter the Southeast Asian e-commerce market?"

**Framework Selection:** Porter's Five Forces + SWOT + Scenario Planning

**Approach:**
1. Use Porter's Five Forces to analyze industry attractiveness
2. Apply SWOT to assess company readiness
3. Use Scenario Planning for different market evolution paths
4. Synthesize into go/no-go recommendation

**Expected Output:** Comprehensive market entry assessment with risk scenarios

---

## Example 4: Process Optimization

**User Request:** "Our team is overwhelmed. We need to focus on what matters most."

**Framework Selection:** Pareto Analysis + MECE

**Approach:**
1. Use MECE to categorize all activities comprehensively
2. Apply Pareto Analysis to identify high-impact activities
3. Create prioritization framework

**Expected Output:** Clear prioritization matrix with recommended focus areas

---

## Example 5: Product Development

**User Request:** "How can we build an app that elderly people will actually use?"

**Framework Selection:** Design Thinking + Socratic Method

**Approach:**
1. Use Design Thinking phases (Empathize, Define, Ideate, Prototype, Test)
2. Apply Socratic Method to challenge assumptions about elderly users
3. Iterate based on user feedback

**Expected Output:** User-centered design approach with prototype concepts

---

## Example 6: Strategic Planning

**User Request:** "What should our company strategy be for the next 5 years in this uncertain tech landscape?"

**Framework Selection:** Scenario Planning + Systems Thinking + SWOT

**Approach:**
1. Use Scenario Planning to map 3-4 plausible future states
2. Apply Systems Thinking to understand industry ecosystem dynamics
3. Use SWOT for current position assessment
4. Develop adaptive strategy that works across scenarios

**Expected Output:** Multi-scenario strategy with trigger points and contingencies

---

## Example 7: Complex Problem Diagnosis

**User Request:** "Our organizational change initiative failed. Why do transformation efforts always struggle?"

**Framework Selection:** Systems Thinking + 5 Whys + Hypothesis-Driven

**Approach:**
1. Use Systems Thinking to map organizational dynamics
2. Apply 5 Whys to specific failure points
3. Develop hypotheses about systemic barriers
4. Test hypotheses against evidence

**Expected Output:** Systemic understanding of change resistance with tested hypotheses

---

## Example 8: Investment Decision

**User Request:** "Should we invest $5M in AI automation or hire 50 more employees?"

**Framework Selection:** Cost-Benefit Analysis + Scenario Planning

**Approach:**
1. Use Cost-Benefit Analysis for quantitative comparison
2. Apply Scenario Planning for different business growth/contraction scenarios
3. Assess decision robustness across scenarios

**Expected Output:** Financial comparison with scenario sensitivity analysis

---

## Example 9: Business Model Innovation

**User Request:** "How can we disrupt the traditional hotel industry?"

**Framework Selection:** First Principles + Design Thinking + Porter's Five Forces

**Approach:**
1. Use First Principles to deconstruct what "lodging" fundamentally provides
2. Apply Porter's Five Forces to understand industry structure
3. Use Design Thinking to reimagine customer experience
4. Synthesize into disruptive business model

**Expected Output:** Innovative business model with competitive advantage analysis

---

## Example 10: Team Conflict Resolution

**User Request:** "Our engineering and product teams keep clashing over priorities."

**Framework Selection:** Socratic Method + MECE

**Approach:**
1. Use Socratic questioning to surface underlying assumptions from both sides
2. Apply MECE to structure the problem space comprehensively
3. Find mutually exclusive resolution paths that address both concerns

**Expected Output:** Structured understanding of conflict with resolution framework

---

## Framework Combination Patterns

### Pattern 1: Diagnosis → Solution
- 5 Whys → First Principles → Design Thinking
- *Use when:* Need to understand problem, then innovate solution

### Pattern 2: Strategic Assessment
- SWOT → Porter's Five Forces → Scenario Planning
- *Use when:* Making major strategic decisions

### Pattern 3: Optimization Focus
- Pareto → Cost-Benefit → Hypothesis-Driven
- *Use when:* Resource-constrained optimization needed

### Pattern 4: Complex Analysis
- Systems Thinking → MECE → Scenario Planning
- *Use when:* Dealing with highly complex, interconnected systems

### Pattern 5: Innovation Pipeline
- First Principles → Design Thinking → Cost-Benefit
- *Use when:* Developing breakthrough ideas with viability check

---

## Quick Framework Selection Shortcuts

**Problem Type → Framework(s)**

- "Why does X keep happening?" → 5 Whys
- "How can we innovate?" → First Principles + Design Thinking
- "Should we do X or Y?" → Cost-Benefit Analysis
- "What's our strategy?" → SWOT + Porter's + Scenario Planning
- "What should we prioritize?" → Pareto + MECE
- "How do we understand X?" → Socratic + First Principles
- "Is this market attractive?" → Porter's Five Forces
- "What will the future look like?" → Scenario Planning
- "How do we test this idea?" → Hypothesis-Driven
- "How does this system work?" → Systems Thinking
- "How do we structure this?" → MECE
- "What do users need?" → Design Thinking

---

## Tips for Effective Framework Application

1. **Start simple:** When in doubt, use First Principles Thinking - it's versatile
2. **Combine thoughtfully:** Don't use all frameworks at once; select 2-3 max
3. **Sequence matters:** Often diagnose before solving (e.g., 5 Whys then Design Thinking)
4. **Adapt depth:** Scale analysis depth to decision importance
5. **Iterate:** Be ready to pivot to different framework if initial choice isn't working
6. **Document assumptions:** Explicitly state assumptions for each framework application
7. **Validate outputs:** Cross-check framework conclusions against reality
8. **Time-box analysis:** Set time limits to avoid analysis paralysis
