# Research Progress Tracker

Use this template to track progress through graduated research protocol.

## Current Investigation: [Topic]

**Started**: [timestamp]
**Current Level**: [1 / 2 / 3]
**Plugin**: [PluginName if applicable]
**Context**: [Brief problem description]

---

## Level 1 Progress (Quick Investigation)

- [ ] Parse research topic (extract keywords, JUCE components, problem type)
- [ ] Search local troubleshooting docs (grep -r, check by-symptom/)
- [ ] Check Context7 JUCE docs (quick API lookup)
- [ ] Assess confidence (HIGH/MEDIUM/LOW)
- [ ] Decision: Present solution / Escalate to Level 2

**Level 1 Findings**:
- [Finding 1]
- [Finding 2]

**Confidence**: [HIGH / MEDIUM / LOW]
**Outcome**: [Solved / Escalated to Level 2]

---

## Level 2 Progress (Moderate Investigation)

- [ ] Context7 deep-dive (module docs, code examples, patterns)
- [ ] JUCE forum search via WebSearch
- [ ] GitHub issue search (juce-framework/JUCE)
- [ ] Synthesize findings from multiple sources
- [ ] Assess confidence (HIGH/MEDIUM/LOW)
- [ ] Decision: Present solution / Escalate to Level 3

**Level 2 Findings**:
- Context7: [Finding]
- JUCE forum: [Finding]
- GitHub: [Finding]

**Confidence**: [HIGH / MEDIUM / LOW]
**Outcome**: [Solved / Escalated to Level 3]

---

## Level 3 Progress (Deep Investigation)

- [ ] Identify 2-3 research approaches
- [ ] Spawn Subagent 1: [Focus/goal]
- [ ] Spawn Subagent 2: [Focus/goal]
- [ ] Spawn Subagent 3: [Focus/goal] (optional)
- [ ] Wait for all subagents to complete
- [ ] Synthesize findings with extended thinking
- [ ] Generate comprehensive report
- [ ] Present decision menu with recommendations

**Subagent Results**:

**Subagent 1** ([Focus]):
- [Key findings]
- Complexity: [X/5]
- Pros: [List]
- Cons: [List]

**Subagent 2** ([Focus]):
- [Key findings]
- Complexity: [X/5]
- Pros: [List]
- Cons: [List]

**Subagent 3** ([Focus]):
- [Key findings]
- Complexity: [X/5]
- Pros: [List]
- Cons: [List]

**Synthesis**:
- Recommended approach: [Approach name]
- Rationale: [Why recommended]
- Implementation complexity: [Assessment]

**Confidence**: [HIGH / MEDIUM / LOW]
**Outcome**: [Solution presented]

---

## Final Report

**Total Time**: [X] minutes
**Levels Used**: [1 / 1→2 / 1→2→3]
**Confidence**: [Final confidence level]
**Solution**: [Brief description]
**Next Step**: [Apply solution / Document / Other]
