# [Aesthetic Name]

> **Vibe:** [One-sentence vibe description]
>
> **Source:** Created from [PluginName] mockup v[N]
>
> **Best For:** [Plugin types or design approaches this aesthetic suits]

---

## Visual Identity

[2-3 sentence description of the overall visual aesthetic. What's the core design philosophy? What feelings or associations does it evoke?]

---

## Color System

### Primary Palette

**Background Colors:**
- Main background: [Description + example code]
- Surface/panel background: [Description + example code]
- Elevated surfaces: [Description + example code]

**Accent Colors:**
- Primary accent: [Description + example code]
- Secondary accent: [Description + example code]
- Hover/active state: [Description + example code]

**Text Colors:**
- Primary text: [Description + example code]
- Secondary/muted text: [Description + example code]
- Labels: [Description + example code]

### Control Colors

**Knobs/Rotary Controls:**
- Base color: [Description]
- Pointer/indicator: [Description]
- Active state: [Description]

**Sliders:**
- Track color: [Description]
- Thumb color: [Description]
- Fill color: [Description]

**Buttons/Toggles:**
- Default state: [Description]
- Active/on state: [Description]
- Hover state: [Description]

### Philosophy

[Describe the color philosophy: warm vs cool, high contrast vs subtle, monochromatic vs varied, etc.]

---

## Typography

**Font Families:**
- Headings: [Font family or generic description like "bold sans-serif"]
- Body text: [Font family or generic description]
- Values/numbers: [Font family or generic description, often monospace]

**Font Sizing:**
- Plugin title: [Size description: large, medium, small + example like "24px"]
- Section labels: [Size description + example]
- Parameter labels: [Size description + example]
- Parameter values: [Size description + example]

**Font Styling:**
- Title weight: [Bold/normal + numeric like 700/400]
- Label weight: [Bold/normal + numeric]
- Letter spacing: [Tight/normal/loose + example like "0.05em"]
- Text transform: [Uppercase/normal/lowercase preference]

**Philosophy:**
[Describe typography approach: technical/readable, decorative/ornate, minimal/modern, vintage/classic, etc.]

---

## Controls

### Knob Style

**Visual Design:**
- Shape: [Circle, rounded square, hexagon, etc.]
- Size: [Small (50px), medium (70px), large (100px), or specific]
- Indicator style: [Tick marks, pointer line, dot, arc fill, etc.]
- Border treatment: [None, subtle, prominent + style]

**Surface Treatment:**
- Base appearance: [Flat, gradient, textured, metallic, etc.]
- Depth: [Flat 2D, subtle 3D, prominent 3D, skeuomorphic]
- Tick marks: [None, subtle dots, prominent lines, numbers, etc.]
- Center indicator: [Yes/no + description]

**Interaction Feel:**
[How should the knob feel to interact with? Smooth rotation? Stepped? Visual feedback on change?]

### Slider Style

**Layout:**
- Orientation preference: [Vertical, horizontal, both work equally]
- Dimensions: [Thin/medium/thick + approximate sizes]
- Track design: [Filled, hollow, gradient, segmented]

**Thumb Design:**
- Shape: [Circle, rectangle, custom]
- Size: [Small, medium, large relative to track]
- Style: [Flat, 3D, grab handle, etc.]

**Visual Treatment:**
- Track appearance: [Color, texture, borders]
- Fill behavior: [Bottom-up, left-right, highlight, etc.]
- Scale marks: [None, subtle ticks, prominent lines, numeric]

### Button Style

**Shape & Size:**
- Shape: [Rectangle, rounded, pill, circle]
- Padding: [Compact, comfortable, spacious]
- Aspect ratio: [Square, wide, tall]

**Visual Design:**
- Default state: [Flat, outlined, filled, 3D]
- Active state: [How it changes when on/pressed]
- Border: [None, subtle, prominent + style]

**Typography:**
- Label style: [Bold, normal, all-caps, icon only]
- Icon treatment: [None, icon + text, icon only]

---

## Spacing & Layout Philosophy

**Overall Density:**
[Compact/tight, comfortable/moderate, generous/spacious - describe the feeling]

**Control Spacing:**
- Between controls: [Tight (8-16px), moderate (20-32px), generous (40+px)]
- Vertical rhythm: [How vertical spacing creates visual hierarchy]
- Grouping strategy: [How related controls are visually grouped]

**Padding & Margins:**
- Edge margins: [How much breathing room from window edges]
- Section padding: [Space around logical sections]
- Label-to-control gap: [How close labels sit to their controls]

**Layout Flexibility:**
[How does spacing adapt with more/fewer parameters? Does it maintain fixed gaps or scale proportionally?]

---

## Surface Treatment

### Textures

**Background:**
- Texture type: [None, subtle noise, paper texture, brushed metal, wood grain, etc.]
- Intensity: [None, barely visible, subtle, noticeable, prominent]
- Implementation: [Pattern description or technique]

**Control Surfaces:**
- Control texture: [Flat, subtle grain, tactile texture, etc.]
- Consistency: [All controls same, or varied by type]

### Depth & Dimensionality

**Shadow Strategy:**
- Shadow presence: [None, subtle, medium, dramatic]
- Shadow color: [Black, colored, etc.]
- Shadow blur: [Sharp, soft]
- Typical shadow values: [Example like "0 2px 8px rgba(0,0,0,0.2)"]

**Elevation System:**
- Layers: [Everything flat, subtle elevation differences, clear z-axis]
- How elevation is shown: [Shadows, borders, both, highlights]

**Borders:**
- Border presence: [None, selective, everywhere]
- Border style: [Subtle lines, prominent frames, 3D bevels, etc.]
- Border color approach: [Same as background, contrasting, accent color]

---

## Details & Embellishments

**Special Features:**
[Any unique visual elements: animations, glows, highlights, decorative elements, etc.]

**Active State Feedback:**
[How do controls show they're being interacted with? Glow, color change, scale, etc.]

**Hover States:**
[How do controls react to hover? Brightness change, underline, border, shadow, etc.]

**Focus Indicators:**
[How is keyboard focus shown? Outline, glow, background change, etc.]

**Decorative Elements:**
[Any ornamental details: corner brackets, divider lines, icons, badges, etc.]

---

## Technical Patterns

**CSS Patterns:**
- Border radius: [None (0), subtle (4px), medium (8px), prominent (16px+)]
- Transition speed: [None, fast (150ms), normal (300ms), slow (500ms+)]
- Easing: [Linear, ease, ease-in-out, custom curve]

**Layout Techniques:**
- Preferred layout: [Flexbox, grid, absolute positioning]
- Responsive strategy: [Fixed sizes, relative units, viewport-based]
- Alignment: [Centered, left-aligned, grid-based]

**Performance Considerations:**
[Any special considerations: heavy textures, many animations, complex shadows, etc.]

---

## Interaction Feel

**Responsiveness:**
[How quickly do controls react to input? Immediate, subtle delay, animated transitions?]

**Feedback:**
[What feedback does the user get? Visual only, implied audio-like visual response, etc.]

**Tactility:**
[Does it feel like physical hardware, smooth software, or abstract interface?]

**Overall UX Personality:**
[Professional/technical, playful/creative, vintage/nostalgic, futuristic/modern, etc.]

---

## Best Suited For

**Plugin Types:**
[What types of plugins does this aesthetic work well with? Compressors, EQs, creative effects, etc.]

**Design Contexts:**
[When would you choose this aesthetic? Quick prototypes, client work, personal projects, etc.]

**Not Recommended For:**
[What types of plugins or contexts might this NOT work well for?]

---

## Application Guidelines

### When Applying to New Plugin

**Parameter Count Adaptation:**
- **1-3 parameters:** [Layout suggestions for this count]
- **4-6 parameters:** [Layout suggestions for this count]
- **7-9 parameters:** [Layout suggestions for this count]
- **10+ parameters:** [Layout suggestions for this count]

**Control Type Mapping:**
- Float parameters → [Which control style to use]
- Boolean parameters → [Which control style to use]
- Choice parameters → [Which control style to use]

**Prominent Parameter Handling:**
[How should prominent parameters like Mix, Output, Dry/Wet be visually distinguished?]

### Customization Points

**Easy to Adjust:**
[What aspects of this aesthetic are easy to customize per plugin?]

**Core Identity Elements:**
[What aspects should remain consistent to preserve the aesthetic identity?]

### Integration Notes

[Any special considerations when implementing this aesthetic: browser compatibility, performance, build setup, etc.]

---

## Example Color Codes

[Provide concrete color values as reference examples, even though prose descriptions above]

```css
/* Backgrounds */
--bg-main: [hex/rgb value];
--bg-surface: [hex/rgb value];

/* Accents */
--accent-primary: [hex/rgb value];
--accent-hover: [hex/rgb value];

/* Text */
--text-primary: [hex/rgb value];
--text-secondary: [hex/rgb value];

/* Controls */
--control-base: [hex/rgb value];
--control-active: [hex/rgb value];

/* Additional as needed */
```

---

## Implementation Checklist

When applying this aesthetic to a new plugin:

- [ ] Extract core color palette and define CSS variables
- [ ] Apply typography hierarchy (fonts, sizes, weights)
- [ ] Style each control type according to specifications
- [ ] Implement spacing system (gaps, padding, margins)
- [ ] Add surface treatments (textures, shadows, borders)
- [ ] Apply interaction states (hover, active, focus)
- [ ] Test with different parameter counts
- [ ] Verify visual consistency with source aesthetic
- [ ] Validate WebView constraints (no viewport units, etc.)
- [ ] Test in both Debug and Release builds
