---
name: brand-voice-glossary
description: Tone, diction, and phrasebook system for consistent writing + localization.
---

# Brand Voice Glossary Skill

## When to Use
- Launching or updating tone-of-voice guidance.
- Training agencies, freelancers, or new hires on copy standards.
- Localizing content while staying on-brand.

## Framework
1. **Voice Attributes** – list do/don't traits with examples (e.g., Bold not boastful).
2. **Vocabulary Pillars** – preferred nouns, verbs, phrases, banned words.
3. **Grammar & Formatting** – casing, punctuation, bullet styles, inclusive language rules.
4. **Persona Variations** – how tone flexes for exec, developer, partner, or consumer audiences.
5. **Localization Notes** – translation guardrails, cultural considerations, fallback phrases.

## Templates
- **Voice Matrix**: See `assets/voice_matrix.md` for attributes and vocabulary.
- **One-page cheat sheet** for quick reference.
- **Long-form guide** with annotated examples.
- **Localization briefing form** capturing nuance requirements.

## Tips
- Include audio/video examples for spoken tone if possible.
- Refresh quarterly with new product names and competitive language shifts.
- Pair with `define-brand-platform` and `design-multi-channel-brand-experience` to auto-insert tone guidance.

---
