---
name: dashboard-playbook
description: Best-practice kit for BI dashboard layout, storytelling, and adoption.
---

# Dashboard Playbook Skill

## When to Use
- Designing new dashboards or refreshing existing ones for GTM stakeholders.
- Auditing dashboards that suffer from low engagement or unclear narratives.
- Training analysts on consistent storytelling and UX patterns.

## Framework
1. **Audience & Decisions** – document persona, cadence, and key decisions.
2. **Story Arc** – headline metric, supporting evidence, drill-downs, and action prompts.
3. **Layout System** – hero tiles, contextual panels, alerts, and annotation space.
4. **Governance Hooks** – data freshness indicator, owner info, and SLA links.
5. **Adoption Loop** – training plans, feedback capture, and iteration cadence.

## Templates
- **Wireframe Template**: See `templates/dashboard_wireframe.md` for layout structure.
- **Dashboard brief** (goals, KPIs, filters, mockups).
- **Adoption checklist** (enablement, comms, success metrics).

## Tips
- Limit hero metrics to 3–5; move detailed tables into drill sections.
- Use consistent color semantics for good vs risk states.
- Pair with `build-exec-dashboard` to package specs + rollout plan.

---
