---
name: metric-governance-kit
description: Framework for defining, approving, and auditing GTM metrics and KPIs.
---

# Metric Governance Kit Skill

## When to Use
- Establishing source-of-truth KPIs for revenue, marketing, or CS teams.
- Resolving conflicting definitions or reporting anomalies.
- Preparing for exec/board reviews where metric accuracy is scrutinized.

## Framework
1. **Metric Charter** – purpose, formula, filters, owner, review cadence.
2. **Data Lineage** – upstream sources, transformations, semantic layer, downstream dashboards.
3. **Quality Controls** – tests, alerts, thresholds, backup calculations.
4. **Change Management** – approval workflow, communication plan, version history.
5. **Adoption Enablement** – cheat sheets, FAQs, and example analyses.

## Templates
- **Metric Dictionary**: See `references/metric_dictionary_template.md` for standard definition format.
- **Metric charter one-pager**.
- **Lineage diagram checklist**.
- **Change log workbook** with approvals + timestamps.

## Tips
- Assign both business and technical owners for each KPI.
- Tag metrics with “tier” (executive, operational, exploratory) to prioritize rigor.
- Pair with `plan-bi-roadmap` to keep initiatives tied to governed metrics.

---
