---
name: escalation
description: Use to define incident tiers, response protocols, and stakeholder communications.
---

# Community Escalation Framework Skill

## When to Use
- Preparing moderators for sensitive situations (security issues, harassment, outages, leaks).
- Coordinating cross-functional response when community incidents impact customers or brand.
- Reviewing past incidents to tighten governance and tooling.

## Framework
1. **Tiering** – classify incidents (info request, policy violation, critical escalation) with examples.
2. **Ownership** – map responders per tier (moderators, comms, legal, security, exec sponsor).
3. **Response Playbooks** – outline steps, messaging, approvals, and timelines per tier.
4. **Tooling & Evidence** – define logging requirements, screenshots, data retention, and ticketing.
5. **Post-incident Review** – document root cause, remediation, and preventive actions.

## Templates
- Escalation matrix (tier → trigger → primary owner → backup → SLA).
- Incident log form with fields for context, actions, and status.
- Postmortem template (summary, timeline, impact, actions, follow-ups).

## Tips
- Tie escalation flows into `community-ops` automation for faster routing.
- Keep response macros ready for common issues to ensure consistent tone.
- Conduct quarterly tabletop exercises to keep responders aligned.

---
