---
name: battlecard-library
description: Template system for building, tagging, and distributing competitive battlecards.
---

# Battlecard Library Skill

## When to Use
- Creating/updating battlecards for new competitors.
- Packaging objection handling + differentiation guidance for field teams.
- Tracking adoption and freshness of competitive assets.

## Framework
1. **Card Structure** – overview, positioning, landmines, differentiation, trap-setting, proof, offer packaging.
2. **Metadata & Tagging** – segment, persona, stage, product module, last updated, SME, confidence level.
3. **Enablement Hooks** – talk tracks, snippets for sequences, asset links, CRM surfaces, content snippets.
4. **Review Cadence** – SME assignments, refresh schedule, localization requirements.
5. **Analytics** – usage tracking, win rate impact, prioritized backlog.

## Templates
- Battlecard deck/Notion template with modular sections.
- Objection handling table (objection → talk track → asset → confidence).
- Update log spreadsheet capturing date, owner, change summary.

## Tips
- Embed battlecards directly into CRM/workspace surfaces where reps already work.
- Flag trap-setting and landmines clearly to avoid disclosure mistakes.
- Pair with `build-battlecard-suite` command to automate population.

---
