---
name: seo-writing
description: Use when planning or drafting search-optimized content that balances keyword intent with GTM messaging.
---

# SEO Writing Skill

## When to Use
- Need pillar/blog content that ranks for a target keyword cluster.
- Building briefs for writers or agencies.
- Auditing existing posts for optimization opportunities.

## Framework
1. **Intent Mapping** – classify keyword as informational, navigational, transactional; align CTA accordingly.
2. **SERP Analysis** – review top 10 results, note content format, length, missing gaps.
3. **Outline Structure** – mirror winning patterns while adding unique POV/data.
4. **On-Page Elements** – optimize title tag (<60 chars), meta description, H1/H2, schema, image alt text.
5. **Internal/External Links** – add minimum 3 internal + 3 authoritative external links.
6. **Conversion Hooks** – insert CTA blocks, lead magnets, or inline product mentions every ~500 words.

## Templates
- Keyword brief template with intent, primary/secondary keywords, CTA, internal targets.
- SERP gap analysis worksheet capturing competitor format, word count, differentiators.
- SEO QA workflow checklist (draft → optimization → publish → refresh schedule).

## Tips
- Refresh top posts quarterly—update stats, add new internal links, re-fetch schema.
- Use heatmaps/scroll data to validate placement of conversion hooks.
- Coordinate with demand gen to align CTAs with current offers.
- Keep keyword cannibalization tracker so multiple teams don’t target same phrase.

## Checklist
- Include primary keyword in H1 + first 100 words.
- Use semantic variants (LSI terms) per section.
- Ensure readability score < grade 9.
- Add FAQ or snippet-ready section.

---
