---
name: storytelling
description: Use when crafting narratives that connect product value to customer pain through clear setup-conflict-resolution arcs.
---

# Storytelling Skill

## When to Use
- Need cohesive narrative for campaigns, product launches, or decks.
- Translating technical capabilities into relatable customer stories.
- Coaching spokespeople or SDRs on better pitch storytelling.

## Framework
1. **Audience & Conflict** – identify who the hero is (customer persona) and what obstacle they face.
2. **Story Arc (SCAR)** – Situation → Complication → Action → Resolution.
3. **Characterization** – give personas motives, stakes, and quotes.
4. **Sensory Detail** – use vivid language, specific metrics, and concrete examples.
5. **Moral/CTA** – tie resolution back to product value and explicit next step.

## Templates
- Narrative outline (hook, scene, rising tension, turn, resolution, CTA).
- Pitch script template:
```
"Most {persona}s today face {pain}. When {trigger}, {impact}. We worked with {customer} to {action}, leading to {result}."
```
- Story inventory tracker to log customer, industry, proof points.

## Tips
- Record customer interviews to capture natural phrasing for quotes.
- Swap metaphors/analogies per persona so stories feel tailored.
- Reinforce numbers with vivid imagery (e.g., "saved hours = extra sprints delivered").
- Align every story with the current positioning doc to avoid mixed messages.

---
