---
name: whitepapers
description: Use when producing research-heavy whitepapers or technical guides that require structured argumentation and data.
---

# Whitepapers Skill

## When to Use
- Deep-dives for regulated or technical buyers (finance, healthcare, energy).
- Support ABM campaigns with detailed solution explainers.
- Repurpose product research into demand-gen anchors.

## Framework
1. **Audience & Compliance** – confirm regulatory constraints, required disclaimers, reading level.
2. **Outline** – Executive summary, background, methodology, findings, recommendations, CTA.
3. **Research Layer** – cite third-party analysts, customer benchmarks, proprietary data.
4. **Design Considerations** – include charts, call-out boxes, and glossary; ensure accessibility.
5. **Peer Review** – involve product/legal SMEs for accuracy.

## Templates
- Draft manuscript with references + citations.
- Data appendix or methodology section.
- Design brief with layout guidance.
- Campaign kit (landing page copy, nurture email, social teasers).

## Tips
- Maintain a citation log to accelerate compliance reviews.
- Use modular sections so data refreshes don’t require full rewrites.
- Pair launch with derivative assets (blogs, webinars) to extend shelf life.
- Version-control legal-approved language for regulated industries.

---
