---
name: asset-tracking
description: Use when managing asset metadata, dependencies, and delivery workflows
  across teams.
---

# Content Asset Tracking Skill

## When to Use
- Coordinating production across writers, designers, video editors, and localization teams.
- Tracking asset dependencies (illustrations, data pulls, interviews) and approvals.
- Preparing handoffs to distribution, enablement, or partner teams.

## Framework
1. **Metadata Schema** – asset ID, pillar, audience, stage, CTA, owner, status, storage link.
2. **Dependency Mapping** – highlight required inputs (stats, quotes, screenshots, product access).
3. **Version Control** – naming conventions, change history, approval timestamps.
4. **Delivery Checklist** – thumbnails, transcripts/captions, localization files, CMS fields.
5. **Analytics Hooks** – UTMs, tracking parameters, reporting sheet references.

## Templates
- Asset tracker spreadsheet/board view.
- Dependency checklist (input, owner, due date, status).
- Delivery package template for distribution + enablement teams.

## Tips
- Centralize assets in shared drives or DAM with consistent naming.
- Automate reminders when dependencies slip or approvals are overdue.
- Tie tracker to distribution calendar to visualize readiness.

---
