---
name: cold-email-personalization
description: Complete cold email system teaching research-driven personalization, "poke the bear" openers, custom signal hunting, and strict QA.
---

# Cold Email Personalization Skill

## When to Use
- **Cold Outbound Ideation**: Drafting initial emails and subject lines.
- **Personalization**: Mapping research signals to first lines.
- **Sequence Building**: Creating follow-up sequences that rotate value propositions.
- **QA & Optimization**: Reviewing drafts against a strict rubric before sending.

## Framework
1. **Message Market Fit > Cleverness**: Show you understand the person/company immediately.
2. **Research IS the Personalization**: Custom signals prove you did your homework.
3. **Personalization in the First Line**: Use bracketed variables `{{...}}` or whole-offer strategy.
4. **Tight, Conversational Copy**: Plain text, minimal fluff, 60–120 words.
5. **One Job Per Email**: Single sharp question or CTA.
6. **Earn Replies, Not Just Meetings**: Confirm situation before selling.

### Core Principles
- **Targeting > Messaging**: Good targeting with bad messaging wastes qualified prospects.
- **Two Paths to Personalization**: Custom Signal Research (Path A) vs. Whole Offer Strategy (Path B).
- **The "Specifically" Line**: "Specifically, it looks like you're trying to sell to {{customer_type}}..."

## Templates
- **[Research Playbook](assets/research-playbook.md)**: How to find custom signals.
- **[Variable Schema](assets/variable-schema.md)**: Standard variables to capture.
- **[Email Structure](assets/email-structure.md)**: Subject lines, body copy, and "punchiness".
- **[Campaign Types](assets/campaign-types.md)**: Custom Signal, Creative Ideas, Whole Offer, Fallback.
- **[Creative Ideas](assets/creative-ideas.md)**: Generating credible ideas for prospects.
- **[Follow-Up Strategy](assets/follow-up-strategy.md)**: Sequence logic and value rotation.
- **[ICP & Objection Mapping](assets/icp-objection-mapping.md)**: Role-playing the skeptical prospect.
- **[QA Checklist](assets/qa-checklist.md)**: Pre-send verification.
- **[Scoring Rubric](assets/scoring-rubric.md)**: 0-100 quality score.
- **[Examples](assets/examples.md)**: Real campaign examples.

## Tips
- **Role-Play First**: Always complete the [ICP & Objection Mapping](assets/icp-objection-mapping.md) before writing.
- **Strict QA**: Use the [QA Checklist](assets/qa-checklist.md) to ensure every email meets the 3:1 recipient:sender ratio.
- **Fresh Signals**: Only use signals from the last 90 days.
- **Don't Hallucinate**: If you can't verify a fact, don't use it.
