# Real Campaign Examples

## Example 1: Pricing Page Insight (Product Video)
**Context**: Targeting SaaS founders. Scraped pricing page to find upgrade paths.
**Subject**: Starter vs. Professional
```
{{First_name}}—had a question about Starter vs. Pro.

Seemed like Starter is for platform access, Pro is for API integrations with CRM.

Do you have a product video showing how easy those integrations are and how much more sales leaders get if they upgrade?

We've attributed 4.7x increase in upgrades after adding product videos.

Worth a chat?
```
**Why it works**:
- Specific observation (Starter vs Pro).
- Metric proof (4.7x).
- Low-effort CTA.

## Example 2: Vanta Engagement Alerts
**Context**: Targeting sales/marketing.
**Subject**: Quick question
```
{{First_name}}—do you get alerts when prospects engage with Vanta's posts?

We pull everyone engaging with any LinkedIn company page, filter by your ICP titles, and send alerts.

Just confirm Vanta works as an example and I'll send you their last 10 posts' engagers.
```
**Why it works**:
- Immediate relevance.
- Value-exchange (confirm -> get data).

## Example 3: LinkedIn Consistency (Taplio)
**Context**: Noticed gap in posting.
**Subject**: saw your post
```
{{first_name}} – Saw one of your recent LinkedIn posts about {{ai_generation}}.

Seems like the last time you posted was {{number_of_days}} days before that though.

With {{number_of_followers}} followers I figured building your brand on LinkedIn might be a priority for you.

LinkedIn's own guidelines stress the importance of consistently creating content. Creators are using our platform to brainstorm and schedule all from one place.

Could I show you how it works sometime?
```
**Why it works**:
- Data point (days between posts).
- Follower count adds credibility.

## Example 4: Whole Offer Strategy (Property Management)
**Context**: Reaching out about late rent.
**Subject**: Ever chase renters for rent?
```
{{First_name}},

We reward renters for paying on time so you increase NOI.

Renters who pay on time get Starbucks gift cards they can spend at {{nearest_mall}}.

If we could increase on-time payments, would that be useful?
```
**Why it works**:
- Subject + preview = entire offer.
- Self-selecting.
- Light AI touch (nearest mall).

## Example 5: Creative Ideas (Follow-Up)
**Context**: Email 2, generating ideas.
```
{{First Name}} – I was back on your site today and had some marketing ideas for you.

{{Creative Ideas}}
• Paid social campaign targeting [specific audience] using [specific platform feature]
• SEO content series around [keyword cluster] based on competitor gaps
• Email nurture sequence for [customer segment] that addresses [specific pain]

But of course, I wrote this without knowing anything about your current bottlenecks and goals.

If it's interesting, we could hop on a call and I'd be happy to share what's working in the {{industry}} industry.
```
**Why it works**:
- Creative ideas campaign.
- Humble disclaimer.
- Value-exchange CTA.
