---
name: message-architecture
description: Use when structuring messaging hierarchy, hook banks, and CTA playbooks.
---

# Message Architecture Systems Skill

## When to Use
- Creating new messaging for campaigns, features, or personas.
- Auditing messaging consistency across channels.
- Onboarding new writers or agencies.

## Framework
1. **Audience & Insight** – persona, pain, desired outcome.
2. **Promise** – primary value proposition + emotional appeal.
3. **Proof** – metrics, customer quotes, product differentiators.
4. **Hooks** – formulas mapped to channels.
5. **CTAs** – stage-specific calls to action + urgency modifiers.

## Templates
- Message house diagram.
- Hook bank sheet with formulas/examples.
- CTA matrix (persona x funnel stage x CTA).

## Tips
- Document banned phrases and compliance notes.
- Keep proof points fresh; retire outdated metrics.
- Pair with `voice-guidelines` skill to maintain tone consistency.

---
