---
name: segmentation-framework
description: Use to design and document customer segments with clear criteria, metrics,
  and governance.
---

# Segmentation Framework Skill

## When to Use
- Building or refreshing customer personas for marketing, sales, or product usage.
- Aligning RevOps/data teams on scoring logic.
- Preparing documentation for GTM activation or reporting.

## Framework
1. **Objective & KPIs** – clarify why segmentation is needed and how it will be measured.
2. **Data Inputs** – list sources (firmographic, technographic, usage, revenue, intent) and required freshness.
3. **Segmentation Logic** – outline rules/cluster definitions, decision trees, and scoring weights.
4. **Validation Checklist** – sample accounts, lift vs KPIs, stakeholder review.
5. **Governance** – refresh cadence, change management process, and owner roster.

## Templates
- Segmentation spec (definition, logic, KPIs, owner).
- Scoring weight table + calculator.
- Adoption tracker + feedback log.

## Tips
- Start with simple rules before layering complex clustering.
- Document exclusions and fallback logic for incomplete data.
- Pair with `activation-map` to ensure each segment has downstream plays.

---
