---
name: voice-of-customer
description: Use to design, run, and synthesize customer feedback programs tied to
  journey stages.
---

# Voice of Customer System Skill

## When to Use
- Planning journey discovery projects or validating hypotheses.
- Building continuous feedback loops (surveys, interviews, community, support mining).
- Translating VOC findings into prioritized journey actions.

## Framework
1. **Program Design** – define objectives, personas, touchpoints, sample size, and incentives.
2. **Channel Mix** – select qualitative (interviews, live sessions) and quantitative (NPS, CES, product usage) data sources per stage.
3. **Signal Processing** – tag insights by emotion, friction type, segment, and impact.
4. **Insight Packaging** – create artifacts (quote boards, heatmaps, KPI overlays) mapped to journey maps.
5. **Action Loop** – pair each insight with a recommended experiment, owner, and expected metric lift.

## Templates
- VOC research brief (question, method, sample, timeline, owner).
- Insight tagging spreadsheet with stage/persona labels.
- Signal-to-action tracker (insight → priority → owner → status).

## Tips
- Rotate participants quarterly to avoid bias; maintain consent logs.
- Combine VOC with telemetry to validate scale of issues.
- Share short audio/video snippets to humanize data for stakeholders.

---
