---
name: brand-governance
description: Use to manage brand guidelines, approvals, and ongoing refresh cadence.
---

# Brand Governance Toolkit Skill

## When to Use
- Rolling out updated brand systems or localization variants.
- Reviewing creative for compliance with legal, accessibility, or partner requirements.
- Auditing asset libraries for version control.

## Framework
1. **Guideline Source of Truth** – centralize docs, design tokens, and change history.
2. **Approval Workflow** – define reviewers, SLAs, and escalation paths for exceptions.
3. **Audit Cadence** – schedule quarterly reviews of live assets, templates, and vendor usage.
4. **Education Layer** – curate training, office hours, and certification quizzes.
5. **Feedback Loop** – capture field requests, track decisions, and prioritize updates.

## Templates
- Brand governance checklist (channel, reviewer, status).
- Exception request form with rationale + decision log.
- Rollout communication plan (audiences, channels, timeline).

## Tips
- Use tagging/versioning in DAM tools to prevent outdated asset usage.
- Pair metrics (brand accuracy, request SLAs) with incentives for compliance.
- Partner with legal/security for regulated industries.

---
