---
name: creative-qa-checklist
description: Use to verify creative assets meet brand, accessibility, and localization
  standards before launch.
---

# Creative QA Checklist Skill

## When to Use
- Final review before publishing web, email, social, or print assets.
- Ensuring agencies/freelancers meet brand and accessibility standards.
- Running localization QA across regions/languages.

## Framework
1. **Brand Compliance** – confirm logo usage, typography, color ratios, and messaging guardrails.
2. **Content Accuracy** – validate copy, pricing, legal disclaimers, CTA, and links.
3. **Accessibility** – check contrast, alt text, captions, keyboard focus, motion sensitivity.
4. **Localization** – verify translations, currencies, time/date formats, right-to-left layouts.
5. **Technical Specs** – ensure file sizes, formats, responsive behavior, and animation limits.

## Templates
- Channel-specific QA checklist (web, email, social, motion, print).
- Bug/feedback tracker with severity + owner.
- Sign-off form for approvers.

## Tips
- Automate baseline checks (contrast, spelling) but keep human review for nuance.
- Capture screenshots/videos for audit logs.
- Pair with `production-playbook` to gate deployments on QA sign-off.

---
