---
name: mood-board-builder
description: Use to compile visual inspiration, color palettes, and typography references
  for creative concepts.
---

# Mood Board Builder Skill

## When to Use
- Early concepting for campaigns, product launches, or rebrands.
- Presenting creative direction options to stakeholders.
- Aligning distributed teams/agencies on look and feel.

## Framework
1. **Inspiration Sourcing** – collect references from brand archives, industry examples, and trend boards.
2. **Palette Definition** – propose color, typography, texture, and motion cues.
3. **Layout Assembly** – organize visuals into narrative sections (story, audience, execution).
4. **Annotation Layer** – add notes on why each reference matters, usage guidelines, and accessibility considerations.
5. **Feedback Hooks** – include prompts for stakeholders to vote/comment.

## Templates
- Figma/Canva board layout.
- PDF deck template with sections (vision, palette, typography, photography).
- Feedback form with scoring rubrics.

## Tips
- Limit each board to 3–4 cohesive directions to avoid choice overload.
- Include real campaign copy snippets to ground visuals.
- Pair with `creative-director` outputs for swift approval.

---
