---
name: retention-ltv-playbook
description: Lifecycle frameworks for driving repeat purchase, loyalty, and subscription
  value.
---

# Retention & LTV Playbook Skill

## When to Use
- Designing lifecycle journeys (onboarding, loyalty, win-back, VIP).
- Benchmarking repeat purchase and churn signals by cohort.
- Equipping lifecycle teams with proven offers, creative angles, and cadences.

## Framework
1. **Lifecycle Matrix** – cohort segmentation (new, active, lapsing, churned, VIP, subscription) with KPIs.
2. **Offer Library** – incentives mapped to cohort + margin guardrails.
3. **Channel Cadence** – recommended mixes (email, SMS, push, communities, direct mail).
4. **Measurement Stack** – dashboards for repeat rate, LTV, churn, loyalty engagement, coupon reliance.
5. **Testing Roadmap** – prioritized experiments per lifecycle cohort.

## Templates
- Journey storyboard (touchpoint, trigger, creative brief, offer, KPI).
- Loyalty program tracker (points, tiers, redemption metrics).
- Experiment log for retention tests with hypotheses + guardrails.

## Tips
- Align offers with merchandising calendar to prevent message fatigue.
- Incorporate zero/first-party data capture prompts early in the lifecycle.
- Pair with `launch-retention-program` for automated plan creation.

---
