---
name: procurement-playbook
description: Use to manage legal, security, and procurement workflows for complex
  deals.
---

# Procurement Playbook Skill

## When to Use
- Enterprise deals entering security/privacy review or contract negotiation.
- RFP/RFI responses requiring coordinated SME input.
- Situations with heavy exception requests, custom terms, or compliance evidence.

## Framework
1. **Requirement Intake** – capture questionnaires, policy docs, and mandatory deliverables.
2. **Workstream Mapping** – assign internal SMEs (legal, security, privacy, finance) with timelines.
3. **Evidence Library** – maintain templates for SOC2, penetration tests, insurance, data flows, DPIA.
4. **Exception Management** – document asks, approvals, fallback positions, and decision owners.
5. **Closeout** – log final concessions, expirations, and follow-up obligations.

## Templates
- Procurement workback plan (deliverable, owner, due date, status).
- Security questionnaire index with sourcing notes.
- Exception request log with approval layers.

## Tips
- Keep source-of-truth links updated; expired certifications stall reviews.
- Coordinate with `cxo-briefing-kit` for executive escalations.
- Pair with `risk-register` to surface procurement blockers early.

---
